/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;

public class HashConfiguration
extends ConfigurationElement<HashConfiguration> {
    public static final AttributeDefinition<ConsistentHashFactory> CONSISTENT_HASH_FACTORY = AttributeDefinition.builder((Enum)Attribute.CONSISTENT_HASH_FACTORY, null, ConsistentHashFactory.class).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder((Enum)Attribute.OWNERS, (Object)2).immutable().build();
    public static final AttributeDefinition<Integer> NUM_SEGMENTS = AttributeDefinition.builder((Enum)Attribute.SEGMENTS, (Object)256).immutable().build();
    public static final AttributeDefinition<Float> CAPACITY_FACTOR = AttributeDefinition.builder((Enum)Attribute.CAPACITY_FACTOR, (Object)Float.valueOf(1.0f)).immutable().global(false).build();
    public static final AttributeDefinition<KeyPartitioner> KEY_PARTITIONER = AttributeDefinition.builder((Enum)Attribute.KEY_PARTITIONER, null, KeyPartitioner.class).copier(original -> {
        KeyPartitioner copy = (KeyPartitioner)Util.getInstance(original.getClass());
        copy.init((KeyPartitioner)original);
        return copy;
    }).initializer(HashFunctionPartitioner::new).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<ConsistentHashFactory> consistentHashFactory;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> numOwners;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> numSegments;
    private final org.infinispan.commons.configuration.attributes.Attribute<Float> capacityFactor;
    private final GroupsConfiguration groupsConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HashConfiguration.class, new AttributeDefinition[]{CONSISTENT_HASH_FACTORY, NUM_OWNERS, NUM_SEGMENTS, CAPACITY_FACTOR, KEY_PARTITIONER});
    }

    HashConfiguration(AttributeSet attributes, GroupsConfiguration groupsConfiguration) {
        super((Enum)Element.HASH, attributes, new ConfigurationElement[0]);
        this.groupsConfiguration = groupsConfiguration;
        this.consistentHashFactory = attributes.attribute(CONSISTENT_HASH_FACTORY);
        this.numOwners = attributes.attribute(NUM_OWNERS);
        this.numSegments = attributes.attribute(NUM_SEGMENTS);
        this.capacityFactor = attributes.attribute(CAPACITY_FACTOR);
        ((KeyPartitioner)attributes.attribute(KEY_PARTITIONER).get()).init(this);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public ConsistentHashFactory<?> consistentHashFactory() {
        return (ConsistentHashFactory)this.consistentHashFactory.get();
    }

    public int numOwners() {
        return (Integer)this.numOwners.get();
    }

    public int numSegments() {
        return (Integer)this.numSegments.get();
    }

    public float capacityFactor() {
        return ((Float)this.capacityFactor.get()).floatValue();
    }

    public KeyPartitioner keyPartitioner() {
        return (KeyPartitioner)this.attributes.attribute(KEY_PARTITIONER).get();
    }

    public GroupsConfiguration groups() {
        return this.groupsConfiguration;
    }
}

