/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import java.awt.image.BufferedImage;

public class Frame {
    private final int streamId;
    private final long pts;
    private final BufferedImage image;
    private final int[] samples;

    protected Frame(int streamId, long pts, BufferedImage image, int[] samples) {
        if (image != null && samples != null) {
            throw new IllegalArgumentException("Only one of image and samples parameters may be non null");
        }
        if (image == null && samples == null) {
            throw new IllegalArgumentException("One of image and samples parameters must be non null");
        }
        this.streamId = streamId;
        this.pts = pts;
        this.image = image;
        this.samples = samples;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public long getPts() {
        return this.pts;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int[] getSamples() {
        return this.samples;
    }

    public String toString() {
        return "Frame{streamId=" + this.streamId + ", pts=" + this.pts + ", image?=" + (this.image != null) + ", samples?=" + (this.samples != null) + '}';
    }

    public static Frame createVideoFrame(int streamId, long pts, BufferedImage image) {
        return new Frame(streamId, pts, image, null);
    }

    public static Frame createAudioFrame(int streamId, long pts, int[] samples) {
        return new Frame(streamId, pts, null, samples);
    }
}

