/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.Histogram;
import com.tdunning.math.stats.Simple64;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;

public class FloatHistogram
extends Histogram {
    private int bitsOfPrecision;
    private int shift;
    private int offset;

    public FloatHistogram(double min, double max) {
        this(min, max, 50.0);
    }

    public FloatHistogram(double min, double max, double binsPerDecade) {
        super(min, max);
        if (max <= 2.0 * min) {
            throw new IllegalArgumentException(String.format("Illegal/nonsensical min, max (%.2f, %.2g)", min, max));
        }
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("Min and max must be positive");
        }
        if (binsPerDecade < 5.0 || binsPerDecade > 10000.0) {
            throw new IllegalArgumentException(String.format("Unreasonable number of bins per decade %.2g. Expected value in range [5,10000]", binsPerDecade));
        }
        this.bitsOfPrecision = (int)Math.ceil(Math.log(binsPerDecade * Math.log10(2.0)) / Math.log(2.0));
        this.shift = 52 - this.bitsOfPrecision;
        this.offset = 1023 << this.bitsOfPrecision;
        this.setupBins(min, max);
    }

    @Override
    protected int bucketIndex(double x) {
        long floatBits = Double.doubleToLongBits(x /= this.min);
        return (int)(floatBits >>> this.shift) - this.offset;
    }

    @Override
    double lowerBound(int k) {
        return this.min * Double.longBitsToDouble((long)k + (1023L << this.bitsOfPrecision) << 52 - this.bitsOfPrecision);
    }

    @Override
    public long[] getCompressedCounts() {
        LongBuffer buf = LongBuffer.allocate(this.counts.length);
        Simple64.compress(buf, this.counts, 0, this.counts.length);
        long[] r = new long[buf.position()];
        buf.flip();
        buf.get(r);
        return r;
    }

    @Override
    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeByte(this.bitsOfPrecision);
        out.writeByte(this.shift);
        ByteBuffer buf = ByteBuffer.allocate(8 * this.counts.length);
        LongBuffer longBuffer = buf.asLongBuffer();
        Simple64.compress(longBuffer, this.counts, 0, this.counts.length);
        buf.position(8 * longBuffer.position());
        byte[] r = new byte[buf.position()];
        out.writeShort(buf.position());
        buf.flip();
        buf.get(r);
        out.write(r);
    }

    @Override
    public void readObject(ObjectInputStream in) throws IOException {
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.bitsOfPrecision = in.readByte();
        this.shift = in.readByte();
        this.offset = 1023 << this.bitsOfPrecision;
        short n = in.readShort();
        ByteBuffer buf = ByteBuffer.allocate(n);
        in.readFully(buf.array(), 0, n);
        int binCount = this.bucketIndex(this.max) + 1;
        if (binCount > 10000) {
            throw new IllegalArgumentException(String.format("Excessive number of bins %d during deserialization = %.2g, %.2g", binCount, this.min, this.max));
        }
        this.counts = new long[binCount];
        Simple64.decompress(buf.asLongBuffer(), this.counts);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    @Override
    void add(Iterable<Histogram> others) {
        for (Histogram other : others) {
            if (!this.getClass().equals(other.getClass())) {
                throw new IllegalArgumentException(String.format("Cannot add %s to FloatHistogram", others.getClass()));
            }
            FloatHistogram actual = (FloatHistogram)other;
            if (actual.min != this.min || actual.max != this.max || actual.counts.length != this.counts.length) {
                throw new IllegalArgumentException("Can only merge histograms with identical bounds and precision");
            }
            for (int i = 0; i < this.counts.length; ++i) {
                int n = i;
                this.counts[n] = this.counts[n] + other.counts[i];
            }
        }
    }
}

