/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregator;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.internal.SearchContext;

public class VariableWidthHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int numBuckets;
    private final int shardSize;
    private final int initialBuffer;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(VariableWidthHistogramAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.NUMERIC, VariableWidthHistogramAggregator::new, true);
    }

    VariableWidthHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, int shardSize, int initialBuffer, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.numBuckets = numBuckets;
        this.shardSize = shardSize;
        this.initialBuffer = initialBuffer;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new IllegalArgumentException("[variable_width_histogram] cannot be nested inside an aggregation that collects more than a single bucket.");
        }
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(VariableWidthHistogramAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new VariableWidthHistogramAggregator(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

