/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.util.List;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogReader;
import org.opensearch.index.translog.TranslogWriter;

public class DefaultTranslogDeletionPolicy
extends TranslogDeletionPolicy {
    private long retentionSizeInBytes;
    private long retentionAgeInMillis;
    private int retentionTotalFiles;

    public DefaultTranslogDeletionPolicy(long retentionSizeInBytes, long retentionAgeInMillis, int retentionTotalFiles) {
        this.retentionSizeInBytes = retentionSizeInBytes;
        this.retentionAgeInMillis = retentionAgeInMillis;
        this.retentionTotalFiles = retentionTotalFiles;
    }

    @Override
    public synchronized long minTranslogGenRequired(List<TranslogReader> readers, TranslogWriter writer) throws IOException {
        long minByLocks = this.getMinTranslogGenRequiredByLocks();
        long minByAge = DefaultTranslogDeletionPolicy.getMinTranslogGenByAge(readers, writer, this.retentionAgeInMillis, this.currentTime());
        long minBySize = DefaultTranslogDeletionPolicy.getMinTranslogGenBySize(readers, writer, this.retentionSizeInBytes);
        long minByAgeAndSize = minBySize == Long.MIN_VALUE && minByAge == Long.MIN_VALUE ? Long.MAX_VALUE : Math.max(minByAge, minBySize);
        long minByNumFiles = DefaultTranslogDeletionPolicy.getMinTranslogGenByTotalFiles(readers, writer, this.retentionTotalFiles);
        return Math.min(Math.max(minByAgeAndSize, minByNumFiles), minByLocks);
    }

    @Override
    public synchronized void setRetentionSizeInBytes(long bytes) {
        this.retentionSizeInBytes = bytes;
    }

    @Override
    public synchronized void setRetentionAgeInMillis(long ageInMillis) {
        this.retentionAgeInMillis = ageInMillis;
    }

    @Override
    protected synchronized void setRetentionTotalFiles(int retentionTotalFiles) {
        this.retentionTotalFiles = retentionTotalFiles;
    }
}

