/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParserBaseVisitor;
import org.opensearch.sql.sql.parser.context.QuerySpecification;

public class AstAggregationBuilder
extends OpenSearchSQLParserBaseVisitor<UnresolvedPlan> {
    private final QuerySpecification querySpec;

    public UnresolvedPlan visit(ParseTree groupByClause) {
        if (this.querySpec.getGroupByItems().isEmpty()) {
            if (this.isAggregatorNotFoundAnywhere()) {
                return null;
            }
            return this.buildImplicitAggregation();
        }
        return this.buildExplicitAggregation();
    }

    private UnresolvedPlan buildExplicitAggregation() {
        List<UnresolvedExpression> groupByItems = this.replaceGroupByItemIfAliasOrOrdinal();
        return new Aggregation(new ArrayList<UnresolvedExpression>(this.querySpec.getAggregators()), Collections.emptyList(), groupByItems);
    }

    private UnresolvedPlan buildImplicitAggregation() {
        Optional<UnresolvedExpression> invalidSelectItem = this.findNonAggregatedItemInSelect();
        if (invalidSelectItem.isPresent()) {
            throw new SemanticCheckException(StringUtils.format("Explicit GROUP BY clause is required because expression [%s] contains non-aggregated column", invalidSelectItem.get()));
        }
        return new Aggregation(new ArrayList<UnresolvedExpression>(this.querySpec.getAggregators()), Collections.emptyList(), this.querySpec.getGroupByItems());
    }

    private List<UnresolvedExpression> replaceGroupByItemIfAliasOrOrdinal() {
        return this.querySpec.getGroupByItems().stream().map(this.querySpec::replaceIfAliasOrOrdinal).map(expr -> new Alias(expr.toString(), (UnresolvedExpression)expr)).collect(Collectors.toList());
    }

    private Optional<UnresolvedExpression> findNonAggregatedItemInSelect() {
        return this.querySpec.getSelectItems().stream().filter(this::isNonAggregateOrLiteralExpression).findFirst();
    }

    private boolean isAggregatorNotFoundAnywhere() {
        return this.querySpec.getAggregators().isEmpty();
    }

    private boolean isNonAggregateOrLiteralExpression(UnresolvedExpression expr) {
        if (expr instanceof AggregateFunction) {
            return false;
        }
        if (expr instanceof QualifiedName) {
            return true;
        }
        List<? extends Node> children = expr.getChild();
        return children.stream().anyMatch(child -> this.isNonAggregateOrLiteralExpression((UnresolvedExpression)child));
    }

    @Generated
    public AstAggregationBuilder(QuerySpecification querySpec) {
        this.querySpec = querySpec;
    }
}

