"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiStep", {
  enumerable: true,
  get: function get() {
    return _step.EuiStep;
  }
});
exports.OuiStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _title = require("../title");
var _step_number = require("./step_number");
var _step = require("../../eui_components/steps/step");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var OuiStep = function OuiStep(_ref) {
  var className = _ref.className,
    children = _ref.children,
    _ref$headingElement = _ref.headingElement,
    headingElement = _ref$headingElement === void 0 ? 'p' : _ref$headingElement,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    title = _ref.title,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    status = _ref.status,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "children", "headingElement", "step", "title", "titleSize", "status"]);
  var classes = (0, _classnames.default)('ouiStep', {
    'ouiStep--small': titleSize === 'xs',
    'ouiStep-isDisabled': status === 'disabled'
  }, className);
  var numberClasses = (0, _classnames.default)('ouiStep__circle', {
    'ouiStepNumber--small': titleSize === 'xs'
  });
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "ouiStep__titleWrapper"
  }, /*#__PURE__*/_react.default.createElement(_step_number.OuiStepNumber, {
    className: numberClasses,
    number: step,
    status: status,
    titleSize: titleSize,
    isHollow: status === 'incomplete'
  }), /*#__PURE__*/_react.default.createElement(_title.OuiTitle, {
    size: titleSize,
    className: "ouiStep__title"
  }, /*#__PURE__*/(0, _react.createElement)(headingElement, null, title))), /*#__PURE__*/_react.default.createElement("div", {
    className: "ouiStep__content"
  }, children));
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiStep = OuiStep;
OuiStep.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node.isRequired,
  /**
     * The HTML tag used for the title
     */
  headingElement: _propTypes.default.string,
  /**
     * The number of the step in the list of steps
     */
  step: _propTypes.default.number,
  title: _propTypes.default.string.isRequired,
  /**
     * May replace the number provided in props.step with alternate styling.
     */
  status: _propTypes.default.any,
  /**
     * Title sizing equivalent to OuiTitle, but only `m`, `s` and `xs`. Defaults to `s`
     */
  titleSize: _propTypes.default.any
};
/* OUI -> EUI Aliases: Build-Time */