// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { KeyringTraceFlag } from '@aws-crypto/material-management';
export const ACTIVE_AS_BYTES = Buffer.from('ACTIVE', 'utf-8');
export const CACHE_ENTRY_ID_DIGEST_ALGORITHM = 'sha384';
export const KDF_DIGEST_ALGORITHM_SHA_256 = 'sha256';
export const ENCRYPT_FLAGS = KeyringTraceFlag.WRAPPING_KEY_ENCRYPTED_DATA_KEY |
    KeyringTraceFlag.WRAPPING_KEY_SIGNED_ENC_CTX;
export const DECRYPT_FLAGS = KeyringTraceFlag.WRAPPING_KEY_DECRYPTED_DATA_KEY |
    KeyringTraceFlag.WRAPPING_KEY_VERIFIED_ENC_CTX;
export const PROVIDER_ID_HIERARCHY = 'aws-kms-hierarchy';
export const PROVIDER_ID_HIERARCHY_AS_BYTES = Buffer.from(PROVIDER_ID_HIERARCHY, 'utf-8');
export const DERIVED_BRANCH_KEY_LENGTH = 32;
// export const CACHE_ENTRY_ID_LENGTH = 32
export const KEY_DERIVATION_LABEL = Buffer.from(PROVIDER_ID_HIERARCHY, 'utf-8');
export const CIPHERTEXT_STRUCTURE = {
    saltLength: 16,
    ivLength: 12,
    branchKeyVersionCompressedLength: 16,
    // Encrypted Key is of variable length
    authTagLength: 16,
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2NvbnN0YW50cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDO0FBRXRDLE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxNQUFNLGlDQUFpQyxDQUFBO0FBRWxFLE1BQU0sQ0FBQyxNQUFNLGVBQWUsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQTtBQUM3RCxNQUFNLENBQUMsTUFBTSwrQkFBK0IsR0FBRyxRQUFRLENBQUE7QUFDdkQsTUFBTSxDQUFDLE1BQU0sNEJBQTRCLEdBQUcsUUFBUSxDQUFBO0FBQ3BELE1BQU0sQ0FBQyxNQUFNLGFBQWEsR0FDeEIsZ0JBQWdCLENBQUMsK0JBQStCO0lBQ2hELGdCQUFnQixDQUFDLDJCQUEyQixDQUFBO0FBQzlDLE1BQU0sQ0FBQyxNQUFNLGFBQWEsR0FDeEIsZ0JBQWdCLENBQUMsK0JBQStCO0lBQ2hELGdCQUFnQixDQUFDLDZCQUE2QixDQUFBO0FBQ2hELE1BQU0sQ0FBQyxNQUFNLHFCQUFxQixHQUFHLG1CQUFtQixDQUFBO0FBQ3hELE1BQU0sQ0FBQyxNQUFNLDhCQUE4QixHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQ3ZELHFCQUFxQixFQUNyQixPQUFPLENBQ1IsQ0FBQTtBQUNELE1BQU0sQ0FBQyxNQUFNLHlCQUF5QixHQUFHLEVBQUUsQ0FBQTtBQUMzQywwQ0FBMEM7QUFDMUMsTUFBTSxDQUFDLE1BQU0sb0JBQW9CLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxPQUFPLENBQUMsQ0FBQTtBQUMvRSxNQUFNLENBQUMsTUFBTSxvQkFBb0IsR0FBRztJQUNsQyxVQUFVLEVBQUUsRUFBRTtJQUNkLFFBQVEsRUFBRSxFQUFFO0lBQ1osZ0NBQWdDLEVBQUUsRUFBRTtJQUNwQyxzQ0FBc0M7SUFDdEMsYUFBYSxFQUFFLEVBQUU7Q0FDbEIsQ0FBQSJ9