/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.batch.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.neuralsearch.highlight.batch.HighlightContext;
import org.opensearch.neuralsearch.highlight.batch.config.HighlightConfig;
import org.opensearch.neuralsearch.processor.InferenceRequest;
import org.opensearch.neuralsearch.processor.highlight.SentenceHighlightingRequest;
import org.opensearch.search.SearchHit;

public class HighlightContextBuilder {
    @Generated
    private static final Logger log = LogManager.getLogger(HighlightContextBuilder.class);

    public HighlightContext build(HighlightConfig config, SearchResponse response, long startTime) {
        ArrayList<SentenceHighlightingRequest> requests = new ArrayList<SentenceHighlightingRequest>();
        ArrayList<SearchHit> validHits = new ArrayList<SearchHit>();
        if (response.getHits() == null || response.getHits().getHits().length == 0) {
            return this.createEmptyContext(config, response, startTime);
        }
        for (SearchHit hit : response.getHits().getHits()) {
            String fieldText = this.extractFieldText(hit, config.getFieldName());
            if (fieldText == null || fieldText.isEmpty()) continue;
            InferenceRequest request = ((SentenceHighlightingRequest.SentenceHighlightingRequestBuilder)((SentenceHighlightingRequest.SentenceHighlightingRequestBuilder)((SentenceHighlightingRequest.SentenceHighlightingRequestBuilder)SentenceHighlightingRequest.builder().modelId(config.getModelId())).question(config.getQueryText())).context(fieldText)).build();
            requests.add((SentenceHighlightingRequest)request);
            validHits.add(hit);
        }
        return HighlightContext.builder().requests(requests).validHits(validHits).fieldName(config.getFieldName()).originalResponse(response).startTime(startTime).preTag(config.getPreTag()).postTag(config.getPostTag()).modelId(config.getModelId()).modelType(config.getModelType()).build();
    }

    private String extractFieldText(SearchHit hit, String fieldName) {
        Map sourceMap = hit.getSourceAsMap();
        if (sourceMap == null || !sourceMap.containsKey(fieldName)) {
            return null;
        }
        Object fieldValue = sourceMap.get(fieldName);
        if (fieldValue instanceof String) {
            return (String)fieldValue;
        }
        if (fieldValue instanceof List) {
            List values = (List)fieldValue;
            StringBuilder sb = new StringBuilder();
            for (Object value : values) {
                if (value == null) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(value.toString());
            }
            return sb.toString();
        }
        if (fieldValue != null) {
            return fieldValue.toString();
        }
        return null;
    }

    private HighlightContext createEmptyContext(HighlightConfig config, SearchResponse response, long startTime) {
        return HighlightContext.builder().requests(new ArrayList<SentenceHighlightingRequest>()).validHits(new ArrayList<SearchHit>()).fieldName(config.getFieldName()).originalResponse(response).startTime(startTime).modelId(config.getModelId()).modelType(config.getModelType()).preTag(config.getPreTag()).postTag(config.getPostTag()).build();
    }
}

