/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.CreateRoleMappingResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateRoleMappingRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateRoleMappingRequest> {
    @Nonnull
    private final List<String> andBackendRoles;
    @Nonnull
    private final List<String> backendRoles;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean hidden;
    @Nonnull
    private final List<String> hosts;
    @Nullable
    private final Boolean reserved;
    @Nonnull
    private final String role;
    @Nonnull
    private final List<String> users;
    public static final JsonpDeserializer<CreateRoleMappingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateRoleMappingRequest::setupCreateRoleMappingRequestDeserializer);
    public static final Endpoint<CreateRoleMappingRequest, CreateRoleMappingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateRoleMappingRequest, CreateRoleMappingResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/rolesmapping/");
        SimpleEndpoint.pathEncode(request.role, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateRoleMappingResponse._DESERIALIZER);

    private CreateRoleMappingRequest(Builder builder) {
        super(builder);
        this.andBackendRoles = ApiTypeHelper.unmodifiable(builder.andBackendRoles);
        this.backendRoles = ApiTypeHelper.unmodifiable(builder.backendRoles);
        this.description = builder.description;
        this.hidden = builder.hidden;
        this.hosts = ApiTypeHelper.unmodifiable(builder.hosts);
        this.reserved = builder.reserved;
        this.role = ApiTypeHelper.requireNonNull(builder.role, this, "role");
        this.users = ApiTypeHelper.unmodifiable(builder.users);
    }

    public static CreateRoleMappingRequest of(Function<Builder, ObjectBuilder<CreateRoleMappingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> andBackendRoles() {
        return this.andBackendRoles;
    }

    @Nonnull
    public final List<String> backendRoles() {
        return this.backendRoles;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean hidden() {
        return this.hidden;
    }

    @Nonnull
    public final List<String> hosts() {
        return this.hosts;
    }

    @Nullable
    public final Boolean reserved() {
        return this.reserved;
    }

    @Nonnull
    public final String role() {
        return this.role;
    }

    @Nonnull
    public final List<String> users() {
        return this.users;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.andBackendRoles)) {
            generator.writeKey("and_backend_roles");
            generator.writeStartArray();
            for (String item0 : this.andBackendRoles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.backendRoles)) {
            generator.writeKey("backend_roles");
            generator.writeStartArray();
            for (String item0 : this.backendRoles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.hidden != null) {
            generator.writeKey("hidden");
            generator.write(this.hidden.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.hosts)) {
            generator.writeKey("hosts");
            generator.writeStartArray();
            for (String item0 : this.hosts) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.users)) {
            generator.writeKey("users");
            generator.writeStartArray();
            for (String item0 : this.users) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateRoleMappingRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::andBackendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "and_backend_roles");
        op.add(Builder::backendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backend_roles");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::hosts, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "hosts");
        op.add(Builder::reserved, JsonpDeserializer.booleanDeserializer(), "reserved");
        op.add(Builder::users, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "users");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.andBackendRoles);
        result = 31 * result + Objects.hashCode(this.backendRoles);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.hidden);
        result = 31 * result + Objects.hashCode(this.hosts);
        result = 31 * result + Objects.hashCode(this.reserved);
        result = 31 * result + this.role.hashCode();
        result = 31 * result + Objects.hashCode(this.users);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRoleMappingRequest other = (CreateRoleMappingRequest)o;
        return Objects.equals(this.andBackendRoles, other.andBackendRoles) && Objects.equals(this.backendRoles, other.backendRoles) && Objects.equals(this.description, other.description) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.hosts, other.hosts) && Objects.equals(this.reserved, other.reserved) && this.role.equals(other.role) && Objects.equals(this.users, other.users);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateRoleMappingRequest> {
        @Nullable
        private List<String> andBackendRoles;
        @Nullable
        private List<String> backendRoles;
        @Nullable
        private String description;
        @Nullable
        private Boolean hidden;
        @Nullable
        private List<String> hosts;
        @Nullable
        private Boolean reserved;
        private String role;
        @Nullable
        private List<String> users;

        public Builder() {
        }

        private Builder(CreateRoleMappingRequest o) {
            super(o);
            this.andBackendRoles = Builder._listCopy(o.andBackendRoles);
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.description = o.description;
            this.hidden = o.hidden;
            this.hosts = Builder._listCopy(o.hosts);
            this.reserved = o.reserved;
            this.role = o.role;
            this.users = Builder._listCopy(o.users);
        }

        private Builder(Builder o) {
            super(o);
            this.andBackendRoles = Builder._listCopy(o.andBackendRoles);
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.description = o.description;
            this.hidden = o.hidden;
            this.hosts = Builder._listCopy(o.hosts);
            this.reserved = o.reserved;
            this.role = o.role;
            this.users = Builder._listCopy(o.users);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder andBackendRoles(List<String> list) {
            this.andBackendRoles = Builder._listAddAll(this.andBackendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder andBackendRoles(String value, String ... values) {
            this.andBackendRoles = Builder._listAdd(this.andBackendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(List<String> list) {
            this.backendRoles = Builder._listAddAll(this.backendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(String value, String ... values) {
            this.backendRoles = Builder._listAdd(this.backendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder hidden(@Nullable Boolean value) {
            this.hidden = value;
            return this;
        }

        @Nonnull
        public final Builder hosts(List<String> list) {
            this.hosts = Builder._listAddAll(this.hosts, list);
            return this;
        }

        @Nonnull
        public final Builder hosts(String value, String ... values) {
            this.hosts = Builder._listAdd(this.hosts, value, values);
            return this;
        }

        @Nonnull
        public final Builder reserved(@Nullable Boolean value) {
            this.reserved = value;
            return this;
        }

        @Nonnull
        public final Builder role(String value) {
            this.role = value;
            return this;
        }

        @Nonnull
        public final Builder users(List<String> list) {
            this.users = Builder._listAddAll(this.users, list);
            return this;
        }

        @Nonnull
        public final Builder users(String value, String ... values) {
            this.users = Builder._listAdd(this.users, value, values);
            return this;
        }

        @Override
        @Nonnull
        public CreateRoleMappingRequest build() {
            this._checkSingleUse();
            return new CreateRoleMappingRequest(this);
        }
    }
}

