/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CompoundBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CompoundBeaconList;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedPartsList;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SignedPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SignedPartsList;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.StandardBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualFieldList;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;

public class BeaconVersion {
    public int _version;
    public IKeyStoreClient _keyStore;
    public BeaconKeySource _keySource;
    public DafnySequence<? extends StandardBeacon> _standardBeacons;
    public Option<DafnySequence<? extends CompoundBeacon>> _compoundBeacons;
    public Option<DafnySequence<? extends VirtualField>> _virtualFields;
    public Option<DafnySequence<? extends EncryptedPart>> _encryptedParts;
    public Option<DafnySequence<? extends SignedPart>> _signedParts;
    private static final TypeDescriptor<BeaconVersion> _TYPE = TypeDescriptor.referenceWithInitializer(BeaconVersion.class, () -> BeaconVersion.Default());
    private static final BeaconVersion theDefault = BeaconVersion.create(0, null, BeaconKeySource.Default(), (DafnySequence<? extends StandardBeacon>)DafnySequence.empty(StandardBeacon._typeDescriptor()), (Option<DafnySequence<? extends CompoundBeacon>>)Option.Default(CompoundBeaconList._typeDescriptor()), (Option<DafnySequence<? extends VirtualField>>)Option.Default(VirtualFieldList._typeDescriptor()), (Option<DafnySequence<? extends EncryptedPart>>)Option.Default(EncryptedPartsList._typeDescriptor()), (Option<DafnySequence<? extends SignedPart>>)Option.Default(SignedPartsList._typeDescriptor()));

    public BeaconVersion(int version, IKeyStoreClient keyStore, BeaconKeySource keySource, DafnySequence<? extends StandardBeacon> standardBeacons, Option<DafnySequence<? extends CompoundBeacon>> compoundBeacons, Option<DafnySequence<? extends VirtualField>> virtualFields, Option<DafnySequence<? extends EncryptedPart>> encryptedParts, Option<DafnySequence<? extends SignedPart>> signedParts) {
        this._version = version;
        this._keyStore = keyStore;
        this._keySource = keySource;
        this._standardBeacons = standardBeacons;
        this._compoundBeacons = compoundBeacons;
        this._virtualFields = virtualFields;
        this._encryptedParts = encryptedParts;
        this._signedParts = signedParts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BeaconVersion o = (BeaconVersion)other;
        return this._version == o._version && this._keyStore == o._keyStore && Objects.equals(this._keySource, o._keySource) && Objects.equals(this._standardBeacons, o._standardBeacons) && Objects.equals(this._compoundBeacons, o._compoundBeacons) && Objects.equals(this._virtualFields, o._virtualFields) && Objects.equals(this._encryptedParts, o._encryptedParts) && Objects.equals(this._signedParts, o._signedParts);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._version);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._keyStore);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._keySource);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._standardBeacons);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._compoundBeacons);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._virtualFields);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptedParts);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._signedParts);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyDbEncryptionSdkDynamoDbTypes.BeaconVersion.BeaconVersion");
        s.append("(");
        s.append(this._version);
        s.append(", ");
        s.append(Helpers.toString((Object)this._keyStore));
        s.append(", ");
        s.append(Helpers.toString((Object)this._keySource));
        s.append(", ");
        s.append(Helpers.toString(this._standardBeacons));
        s.append(", ");
        s.append(Helpers.toString(this._compoundBeacons));
        s.append(", ");
        s.append(Helpers.toString(this._virtualFields));
        s.append(", ");
        s.append(Helpers.toString(this._encryptedParts));
        s.append(", ");
        s.append(Helpers.toString(this._signedParts));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<BeaconVersion> _typeDescriptor() {
        return _TYPE;
    }

    public static BeaconVersion Default() {
        return theDefault;
    }

    public static BeaconVersion create(int version, IKeyStoreClient keyStore, BeaconKeySource keySource, DafnySequence<? extends StandardBeacon> standardBeacons, Option<DafnySequence<? extends CompoundBeacon>> compoundBeacons, Option<DafnySequence<? extends VirtualField>> virtualFields, Option<DafnySequence<? extends EncryptedPart>> encryptedParts, Option<DafnySequence<? extends SignedPart>> signedParts) {
        return new BeaconVersion(version, keyStore, keySource, standardBeacons, compoundBeacons, virtualFields, encryptedParts, signedParts);
    }

    public static BeaconVersion create_BeaconVersion(int version, IKeyStoreClient keyStore, BeaconKeySource keySource, DafnySequence<? extends StandardBeacon> standardBeacons, Option<DafnySequence<? extends CompoundBeacon>> compoundBeacons, Option<DafnySequence<? extends VirtualField>> virtualFields, Option<DafnySequence<? extends EncryptedPart>> encryptedParts, Option<DafnySequence<? extends SignedPart>> signedParts) {
        return BeaconVersion.create(version, keyStore, keySource, standardBeacons, compoundBeacons, virtualFields, encryptedParts, signedParts);
    }

    public boolean is_BeaconVersion() {
        return true;
    }

    public int dtor_version() {
        return this._version;
    }

    public IKeyStoreClient dtor_keyStore() {
        return this._keyStore;
    }

    public BeaconKeySource dtor_keySource() {
        return this._keySource;
    }

    public DafnySequence<? extends StandardBeacon> dtor_standardBeacons() {
        return this._standardBeacons;
    }

    public Option<DafnySequence<? extends CompoundBeacon>> dtor_compoundBeacons() {
        return this._compoundBeacons;
    }

    public Option<DafnySequence<? extends VirtualField>> dtor_virtualFields() {
        return this._virtualFields;
    }

    public Option<DafnySequence<? extends EncryptedPart>> dtor_encryptedParts() {
        return this._encryptedParts;
    }

    public Option<DafnySequence<? extends SignedPart>> dtor_signedParts() {
        return this._signedParts;
    }
}

