/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;

public class ClusterInfoHolder
implements ClusterStateListener {
    public static final String CLUSTER_MANAGER_NOT_PRESENT = "Cluster manager not present";
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile DiscoveryNodes nodes = null;
    private volatile Boolean isLocalNodeElectedClusterManager = null;
    private volatile boolean initialized;
    private final String clusterName;

    public ClusterInfoHolder(String clusterName) {
        this.clusterName = clusterName;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.nodes == null || event.nodesChanged()) {
            this.nodes = event.state().nodes();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder now initialized for 'nodes'");
            }
            this.initialized = true;
        }
        this.isLocalNodeElectedClusterManager = event.localNodeClusterManager() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isLocalNodeElectedClusterManager() {
        return this.isLocalNodeElectedClusterManager;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Version getMinNodeVersion() {
        if (this.nodes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder not initialized yet for 'nodes'");
            }
            return null;
        }
        return this.nodes.getMinNodeVersion();
    }

    public Boolean hasNode(DiscoveryNode node) {
        if (this.nodes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder not initialized yet for 'nodes'");
            }
            return null;
        }
        return this.nodes.nodeExists(node) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Boolean hasClusterManager() {
        if (this.nodes != null) {
            return this.nodes.getClusterManagerNode() != null;
        }
        return false;
    }

    public String getReasonForUnavailability() {
        if (!this.hasClusterManager().booleanValue()) {
            return CLUSTER_MANAGER_NOT_PRESENT;
        }
        return null;
    }
}

