/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.mrtree.TreeLayoutProvider;
import org.eclipse.elk.alg.mrtree.options.EdgeRoutingMode;
import org.eclipse.elk.alg.mrtree.options.MrTreeMetaDataProvider;
import org.eclipse.elk.alg.mrtree.options.OrderWeighting;
import org.eclipse.elk.alg.mrtree.options.TreeifyingOrder;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.options.TopdownNodeTypes;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class MrTreeOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.mrtree";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(20.0);
    public static final IProperty<ElkPadding> PADDING = new Property<ElkPadding>(CoreOptions.PADDING, PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 20.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property<Double>(CoreOptions.SPACING_NODE_NODE, Double.valueOf(20.0));
    private static final double SPACING_EDGE_NODE_DEFAULT = 3.0;
    public static final IProperty<Double> SPACING_EDGE_NODE = new Property<Double>(CoreOptions.SPACING_EDGE_NODE, Double.valueOf(3.0));
    private static final double ASPECT_RATIO_DEFAULT = (double)1.6f;
    public static final IProperty<Double> ASPECT_RATIO = new Property<Double>(CoreOptions.ASPECT_RATIO, Double.valueOf(1.6f));
    private static final int PRIORITY_DEFAULT = 1;
    public static final IProperty<Integer> PRIORITY = new Property<Integer>(CoreOptions.PRIORITY, Integer.valueOf(1));
    private static final boolean SEPARATE_CONNECTED_COMPONENTS_DEFAULT = true;
    public static final IProperty<Boolean> SEPARATE_CONNECTED_COMPONENTS = new Property<Boolean>(CoreOptions.SEPARATE_CONNECTED_COMPONENTS, Boolean.valueOf(true));
    public static final IProperty<Boolean> DEBUG_MODE = CoreOptions.DEBUG_MODE;
    private static final Direction DIRECTION_DEFAULT = Direction.UNDEFINED;
    public static final IProperty<Direction> DIRECTION = new Property<Direction>(CoreOptions.DIRECTION, DIRECTION_DEFAULT);
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<Boolean> INTERACTIVE_LAYOUT = CoreOptions.INTERACTIVE_LAYOUT;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<Boolean> NODE_SIZE_FIXED_GRAPH_SIZE = CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE;
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = CoreOptions.NODE_SIZE_MINIMUM;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    public static final IProperty<EnumSet<NodeLabelPlacement>> NODE_LABELS_PLACEMENT = CoreOptions.NODE_LABELS_PLACEMENT;
    public static final IProperty<Boolean> OMIT_NODE_MICRO_LAYOUT = CoreOptions.OMIT_NODE_MICRO_LAYOUT;
    public static final IProperty<EnumSet<PortLabelPlacement>> PORT_LABELS_PLACEMENT = CoreOptions.PORT_LABELS_PLACEMENT;
    public static final IProperty<OrderWeighting> WEIGHTING = MrTreeMetaDataProvider.WEIGHTING;
    public static final IProperty<TreeifyingOrder> SEARCH_ORDER = MrTreeMetaDataProvider.SEARCH_ORDER;
    public static final IProperty<Boolean> TOPDOWN_LAYOUT = CoreOptions.TOPDOWN_LAYOUT;
    public static final IProperty<Double> TOPDOWN_SCALE_FACTOR = CoreOptions.TOPDOWN_SCALE_FACTOR;
    public static final IProperty<Double> TOPDOWN_HIERARCHICAL_NODE_WIDTH = CoreOptions.TOPDOWN_HIERARCHICAL_NODE_WIDTH;
    public static final IProperty<Double> TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO = CoreOptions.TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO;
    private static final TopdownNodeTypes TOPDOWN_NODE_TYPE_DEFAULT = TopdownNodeTypes.HIERARCHICAL_NODE;
    public static final IProperty<TopdownNodeTypes> TOPDOWN_NODE_TYPE = new Property<TopdownNodeTypes>(CoreOptions.TOPDOWN_NODE_TYPE, TOPDOWN_NODE_TYPE_DEFAULT);
    public static final IProperty<Integer> POSITION_CONSTRAINT = MrTreeMetaDataProvider.POSITION_CONSTRAINT;
    public static final IProperty<EdgeRoutingMode> EDGE_ROUTING_MODE = MrTreeMetaDataProvider.EDGE_ROUTING_MODE;
    public static final IProperty<Integer> TREE_LEVEL = MrTreeMetaDataProvider.TREE_LEVEL;
    public static final IProperty<Boolean> COMPACTION = MrTreeMetaDataProvider.COMPACTION;
    public static final IProperty<Double> EDGE_END_TEXTURE_LENGTH = MrTreeMetaDataProvider.EDGE_END_TEXTURE_LENGTH;

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Mr. Tree").description("Tree-based algorithm provided by the Eclipse Layout Kernel. Computes a spanning tree of the input graph and arranges all nodes according to the resulting parent-children hierarchy. I pity the fool who doesn't use Mr. Tree Layout.").providerFactory(new MrtreeFactory()).category("org.eclipse.elk.tree").melkBundleName(null).definingBundleId("org.eclipse.elk.alg.mrtree").imagePath("images/mrtree_layout.png").supportedFeatures(EnumSet.of(GraphFeature.DISCONNECTED)).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", 20.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.edgeNode", 3.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", 1.6f);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.priority", 1);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.separateConnectedComponents", true);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", DEBUG_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.direction", (Object)DIRECTION_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactiveLayout", INTERACTIVE_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.fixedGraphSize", NODE_SIZE_FIXED_GRAPH_SIZE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.minimum", NODE_SIZE_MINIMUM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeLabels.placement", NODE_LABELS_PLACEMENT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.omitNodeMicroLayout", OMIT_NODE_MICRO_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.portLabels.placement", PORT_LABELS_PLACEMENT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.weighting", (Object)WEIGHTING.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.searchOrder", (Object)SEARCH_ORDER.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdownLayout", TOPDOWN_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdown.scaleFactor", TOPDOWN_SCALE_FACTOR.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdown.hierarchicalNodeWidth", TOPDOWN_HIERARCHICAL_NODE_WIDTH.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdown.hierarchicalNodeAspectRatio", TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdown.nodeType", (Object)TOPDOWN_NODE_TYPE_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.positionConstraint", POSITION_CONSTRAINT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.edgeRoutingMode", (Object)EDGE_ROUTING_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.treeLevel", TREE_LEVEL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.compaction", COMPACTION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.edgeEndTextureLength", EDGE_END_TEXTURE_LENGTH.getDefault());
    }

    public static class MrtreeFactory
    implements IFactory<AbstractLayoutProvider> {
        @Override
        public AbstractLayoutProvider create() {
            TreeLayoutProvider provider = new TreeLayoutProvider();
            provider.initialize("");
            return provider;
        }

        @Override
        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

