/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartLegend
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartLegend() {
        super(false, CommandChartLegend.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartLegend.class.getName(), RegexLeaf.start(), new RegexLeaf("legend"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "POSITION", "(left|right|top|bottom)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        ChartDiagram.LegendPosition legendPosition;
        String position = arg.get("POSITION", 0);
        switch (position.toLowerCase()) {
            case "left": {
                legendPosition = ChartDiagram.LegendPosition.LEFT;
                break;
            }
            case "right": {
                legendPosition = ChartDiagram.LegendPosition.RIGHT;
                break;
            }
            case "top": {
                legendPosition = ChartDiagram.LegendPosition.TOP;
                break;
            }
            case "bottom": {
                legendPosition = ChartDiagram.LegendPosition.BOTTOM;
                break;
            }
            default: {
                return CommandExecutionResult.error("Invalid legend position: " + position);
            }
        }
        return diagram.setLegendPosition(legendPosition);
    }
}

