/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.preproc.Define;
import net.sourceforge.plantuml.preproc.EvalBoolean;
import net.sourceforge.plantuml.preproc.Truth;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TVariableScope;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.version.Version;

public class Defines
implements Truth {
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Map<String, Define> values = new LinkedHashMap<String, Define>();
    private static final String DATE = "(?i)%date(\\[(.+?)\\])?%";
    private static final Pattern datePattern = Pattern.compile("(?i)%date(\\[(.+?)\\])?%");

    @Deprecated
    public Defines() {
        this.environment.put("PLANTUML_VERSION", "" + Version.versionString());
    }

    public String toString() {
        return this.values.keySet().toString() + " " + this.environment.keySet();
    }

    public static Defines createEmpty() {
        return new Defines();
    }

    public void copyTo(TMemory memory, StringLocated location) throws EaterException {
        for (Map.Entry<String, Define> ent : this.values.entrySet()) {
            String name = ent.getKey();
            Define def = ent.getValue();
            memory.putVariable(name, def.asTVariable(), TVariableScope.GLOBAL, location);
        }
    }

    public void overrideFilename(String filename) {
        if (filename != null) {
            this.environment.put("filename", filename);
            this.environment.put("filenameNoExtension", Defines.nameNoExtension(filename));
        }
    }

    public void overrideDirPath(String fileDir) {
        if (fileDir != null) {
            this.environment.put("dirpath", fileDir.replace('\\', '/'));
        }
    }

    public void importFrom(Defines other) {
        this.environment.putAll(other.environment);
        this.values.putAll(other.values);
    }

    public Defines cloneMe() {
        Defines result = new Defines();
        result.importFrom(this);
        return result;
    }

    public static Defines createWithFileName(SFile file) {
        Objects.requireNonNull(file);
        Defines result = Defines.createEmpty();
        result.overrideFilename(file.getName());
        result.environment.put("filedate", new Date(file.lastModified()).toString());
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            result.environment.put("dirpath", file.getAbsoluteFile().getParentFile().getAbsolutePath().replace('\\', '/'));
        }
        return result;
    }

    public static Defines createWithFileName(File file) {
        Objects.requireNonNull(file);
        Defines result = Defines.createEmpty();
        result.overrideFilename(file.getName());
        result.environment.put("filedate", new Date(file.lastModified()).toString());
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            result.environment.put("dirpath", file.getAbsoluteFile().getParentFile().getAbsolutePath().replace('\\', '/'));
        }
        return result;
    }

    public String getEnvironmentValue(String key) {
        return this.environment.get(key);
    }

    private static String nameNoExtension(String name) {
        int x = name.lastIndexOf(46);
        if (x == -1) {
            return name;
        }
        return name.substring(0, x);
    }

    public void define(String name, List<String> value, boolean emptyParentheses) {
        this.values.put(name, new Define(name, value, emptyParentheses));
    }

    public boolean isDefine(String expression) {
        try {
            EvalBoolean eval = new EvalBoolean(expression, this);
            return eval.eval();
        }
        catch (IllegalArgumentException e) {
            Log.info(() -> "Error in " + expression);
            return false;
        }
    }

    @Override
    public boolean isTrue(String name) {
        for (String key : this.values.keySet()) {
            if (!key.equals(name) && !key.startsWith(name + "(")) continue;
            return true;
        }
        return false;
    }

    public void undefine(String name) {
        this.values.remove(name);
    }

    public List<String> applyDefines(String line) {
        line = this.manageDate(line);
        line = this.manageEnvironment(line);
        line = this.method1(line);
        return Arrays.asList(line.split("\n"));
    }

    private String method1(String line) {
        for (Define def : this.values.values()) {
            line = def.apply(line);
        }
        return line;
    }

    private String manageEnvironment(String line) {
        for (Map.Entry<String, String> ent : this.environment.entrySet()) {
            String key = Pattern.quote("%" + ent.getKey() + "%");
            line = line.replaceAll(key, ent.getValue());
        }
        return line;
    }

    private String manageDate(String line) {
        Matcher m = datePattern.matcher(line);
        if (m.find()) {
            String replace;
            String format = m.group(2);
            if (format == null) {
                replace = new Date().toString();
            } else {
                try {
                    replace = new SimpleDateFormat(format).format(new Date());
                }
                catch (Exception e) {
                    replace = "(BAD DATE PATTERN:" + format + ")";
                }
            }
            line = line.replaceAll(DATE, replace);
        }
        return line;
    }
}

