/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.impl.VcsSelectionHistoryDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SelectedBlockHistoryAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(1);
        }
        Project project = event.getProject();
        assert (project != null);
        VcsSelection selection = VcsSelectionUtil.getSelection((AnAction)this, event);
        assert (selection != null);
        SelectedBlockHistoryAction.showHistoryForSelection(selection, project);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = event.getPresentation();
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        VcsSelection selection = VcsSelectionUtil.getSelection((AnAction)this, event);
        presentation.setEnabled(SelectedBlockHistoryAction.isEnabled(project, selection));
        if (selection != null) {
            presentation.setText(selection.getActionName());
        }
    }

    public static boolean isEnabled(@Nullable Project project, @Nullable VcsSelection selection) {
        if (project == null || selection == null) {
            return false;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        if (file == null) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (activeVcs == null) {
            return false;
        }
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        if (provider == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    public static void showHistoryForSelection(VcsSelection selection, Project project) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        assert (file != null);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        assert (activeVcs != null);
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        assert (provider != null);
        int selectionStart = selection.getSelectionStartLineNumber();
        int selectionEnd = selection.getSelectionEndLineNumber();
        VcsSelectionHistoryDialog dialog = new VcsSelectionHistoryDialog(project, file, selection.getDocument(), provider, activeVcs, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), selection.getDialogTitle());
        dialog.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

