\name{WrapPadImageFilter}
\alias{WrapPadImageFilter}
\title{WrapPadImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Increase the image size by padding with replicants of the input image
value.
WrapPadImageFilter}
\details{
WrapPadImageFilter changes the image bounds of an image. Added pixels are filled in with
a wrapped replica of the input image. For instance, if the output
image needs a pixel that is two pixels to the left of the
LargestPossibleRegion of the input image, the value assigned will be
from the pixel two pixels inside the right boundary of the
LargestPossibleRegion. The image bounds of the output must be
specified.
Visual explanation of padding regions.
This filter is implemented as a multithreaded filter. It provides a
ThreadedGenerateData() method for its implementation.
See:
MirrorPadImageFilter , ConstantPadImageFilter
WrapPad for the procedural interface
itk::WrapPadImageFilter for the Doxygen on the original ITK class.
WrapPadImageFilter}
%C++ includes: sitkWrapPadImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetPadLowerBound() const:}{}
\item{std::vector< unsigned int > GetPadUpperBound() const:}{}
\item{Self SetPadLowerBound(std::vector< unsigned int > PadLowerBound):}{}
\item{Self SetPadUpperBound(std::vector< unsigned int > PadUpperBound):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ WrapPadImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~WrapPadImageFilter():}{
Destructor
}
}
}
