/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script.options;

import java.util.EnumSet;
import schemacrawler.tools.command.script.options.ScriptLanguageType;
import schemacrawler.tools.command.script.options.ScriptOptions;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.ConfigUtility;
import schemacrawler.tools.scripting.options.LanguageOptionsBuilder;

public final class ScriptLanguageOptionsBuilder
extends LanguageOptionsBuilder<ScriptLanguageType, ScriptOptions> {
    private Config config = ConfigUtility.newConfig();

    public static ScriptLanguageOptionsBuilder builder() {
        return new ScriptLanguageOptionsBuilder();
    }

    private ScriptLanguageOptionsBuilder() {
        super("script-language", "script", ScriptLanguageType.unknown);
    }

    @Override
    public ScriptLanguageOptionsBuilder fromConfig(Config config) {
        super.fromConfig(config);
        this.config = ConfigUtility.fromConfig((Config)config);
        return this;
    }

    public ScriptLanguageOptionsBuilder fromOptions(ScriptOptions options) {
        super.fromOptions(options);
        if (options != null) {
            this.config = options.getConfig();
        }
        return this;
    }

    public ScriptOptions toOptions() {
        return new ScriptOptions((ScriptLanguageType)this.getLanguage(), this.getScript(), this.config);
    }

    @Override
    protected ScriptLanguageType languageFromString(String languageName) {
        for (ScriptLanguageType scriptLanguageType : EnumSet.complementOf(EnumSet.of(ScriptLanguageType.unknown))) {
            if (!scriptLanguageType.matches(languageName)) continue;
            return scriptLanguageType;
        }
        return ScriptLanguageType.unknown;
    }
}

