/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.complex;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;

public final class PComplex
extends PythonBuiltinObject {
    private final double real;
    private final double imag;

    public PComplex(Object clazz, Shape instanceShape, double real, double imaginary) {
        super(clazz, instanceShape);
        this.real = real;
        this.imag = imaginary;
    }

    public boolean equals(Object c) {
        if (c instanceof PComplex) {
            return this.real == ((PComplex)c).real && this.imag == ((PComplex)c).imag;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean notEqual(PComplex c) {
        return this.real != c.real || this.imag != c.imag;
    }

    public boolean greaterEqual(PComplex c) {
        throw new RuntimeException("cannot compare complex numbers using <, <=, >, >=");
    }

    public boolean greaterThan(PComplex c) {
        throw new RuntimeException("cannot compare complex numbers using <, <=, >, >=");
    }

    public boolean lessEqual(PComplex c) {
        throw new RuntimeException("cannot compare complex numbers using <, <=, >, >=");
    }

    public boolean lessThan(PComplex c) {
        throw new RuntimeException("cannot compare complex numbers using <, <=, >, >=");
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (Double.compare(this.real, 0.0) == 0) {
            return Double.compare(this.imag, 0.0) >= 0 ? PComplex.toString(this.imag) + "j" : String.format("-%sj", PComplex.toString(-this.imag));
        }
        String realString = PComplex.toString(this.real);
        if (this.real == 0.0) {
            realString = "-0";
        }
        if (Double.compare(this.imag, 0.0) >= 0) {
            return String.format("(%s+%sj)", realString, PComplex.toString(this.imag));
        }
        return String.format("(%s-%sj)", realString, PComplex.toString(-this.imag));
    }

    private static String toString(double value) {
        if (value == Math.floor(value) && value <= 9.223372036854776E18 && value >= -9.223372036854776E18) {
            return Long.toString((long)value);
        }
        if (Double.isInfinite(value)) {
            if (Double.NEGATIVE_INFINITY == value) {
                return "-inf";
            }
            return "inf";
        }
        if (Double.isNaN(value)) {
            return "nan";
        }
        return Double.toString(value);
    }
}

