/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.builtins.objects.contextvars.Hamt;
import com.oracle.truffle.api.CompilerDirectives;

public final class HamtIterator {
    private static final int MAX_DEPTH = 8;
    private final int[] nodeIndices = new int[8];
    private final Hamt.TreePart[] path = new Hamt.TreePart[8];
    private int level = 0;

    public HamtIterator(Hamt hamt) {
        this.path[0] = hamt.root;
        this.findFirstEntry();
    }

    private void visitLeftmost(Hamt.TreePart parent) {
        ++this.level;
        if (parent instanceof Hamt.CollisionPart) {
            Hamt.CollisionPart part = (Hamt.CollisionPart)parent;
            this.path[this.level] = part.elems[0];
            this.nodeIndices[this.level - 1] = 0;
        } else if (parent instanceof Hamt.BitmapPart) {
            Hamt.BitmapPart part = (Hamt.BitmapPart)parent;
            this.path[this.level] = part.elems[0];
            this.nodeIndices[this.level - 1] = 0;
        } else if (parent instanceof Hamt.ArrayPart) {
            Hamt.ArrayPart part = (Hamt.ArrayPart)parent;
            for (int ret = 0; ret < part.elems.length; ++ret) {
                if (part.elems[ret] == null) continue;
                this.path[this.level] = part.elems[ret];
                this.nodeIndices[this.level - 1] = ret;
                break;
            }
        } else {
            if (parent instanceof Hamt.Entry) {
                throw CompilerDirectives.shouldNotReachHere((String)"got Entry in method for non-leaf nodes");
            }
            throw CompilerDirectives.shouldNotReachHere((String)"unhandled TreePart type");
        }
    }

    private void findFirstEntry() {
        if (this.path[this.level] == null) {
            this.level = -1;
            return;
        }
        while (!(this.path[this.level] instanceof Hamt.Entry)) {
            this.visitLeftmost(this.path[this.level]);
        }
    }

    private void nextInArr(Hamt.TreePart[] arr, int idx) {
        for (int nextIdx = idx + 1; nextIdx < arr.length; ++nextIdx) {
            if (arr[nextIdx] == null) continue;
            this.nodeIndices[this.level] = nextIdx;
            ++this.level;
            this.path[this.level] = arr[nextIdx];
            this.findFirstEntry();
            return;
        }
        this.nextEntry();
    }

    private void nextEntry() {
        --this.level;
        if (this.level < 0) {
            this.level = -1;
            return;
        }
        Hamt.TreePart toAdvance = this.path[this.level];
        int idx = this.nodeIndices[this.level];
        if (toAdvance instanceof Hamt.CollisionPart) {
            this.nextInArr(((Hamt.CollisionPart)toAdvance).elems, idx);
        } else if (toAdvance instanceof Hamt.BitmapPart) {
            this.nextInArr(((Hamt.BitmapPart)toAdvance).elems, idx);
        } else if (toAdvance instanceof Hamt.ArrayPart) {
            this.nextInArr(((Hamt.ArrayPart)toAdvance).elems, idx);
        } else {
            if (toAdvance instanceof Hamt.Entry) {
                throw CompilerDirectives.shouldNotReachHere((String)"Entry in non-leaf method");
            }
            throw CompilerDirectives.shouldNotReachHere((String)"TreePart type not handled");
        }
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public Hamt.Entry next() {
        if (this.level == -1) {
            return null;
        }
        Hamt.TreePart result = this.path[this.level];
        if (!(result instanceof Hamt.Entry)) {
            throw CompilerDirectives.shouldNotReachHere((String)"Hamt path in invalid state");
        }
        this.nextEntry();
        return (Hamt.Entry)result;
    }
}

