/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.util;

import java.sql.SQLException;
import java.util.Optional;

public final class SQLExceptionChainBuilder<E extends SQLException> {
    private E root;

    public SQLExceptionChainBuilder() {
        this(null);
    }

    public SQLExceptionChainBuilder(E root) {
        this.root = root;
    }

    public SQLExceptionChainBuilder<E> append(E sqle) {
        if (this.root == null) {
            this.root = sqle;
        } else {
            ((SQLException)this.root).setNextException((SQLException)sqle);
        }
        return this;
    }

    public SQLExceptionChainBuilder<E> addFirst(E sqle) {
        E originalRoot = this.root;
        if (originalRoot != null) {
            ((SQLException)sqle).setNextException((SQLException)originalRoot);
        }
        this.root = sqle;
        return this;
    }

    public boolean hasException() {
        return this.root != null;
    }

    public E getException() {
        return this.root;
    }

    public Optional<SQLException> optException() {
        return Optional.ofNullable(this.root);
    }

    public void throwIfPresent() throws SQLException {
        E root = this.root;
        if (root != null) {
            throw root;
        }
    }
}

