/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.lib.CallBinaryOp1Node;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateCached(value=false)
public abstract class PySequenceConcatNode
extends PNodeWithContext {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

    @Specialization(guards={"isBuiltinList(left)", "isBuiltinList(right)"})
    static PList doPList(Node inliningTarget, PList left, PList right, @Cached.Shared @Cached SequenceStorageNodes.ConcatListOrTupleNode concatNode, @Bind PythonLanguage language) {
        SequenceStorage newStore = concatNode.execute(inliningTarget, left.getSequenceStorage(), right.getSequenceStorage());
        return PFactory.createList(language, newStore);
    }

    @Specialization(guards={"isBuiltinTuple(left)", "isBuiltinTuple(right)"})
    static PTuple doTuple(Node inliningTarget, PTuple left, PTuple right, @Cached.Shared @Cached SequenceStorageNodes.ConcatListOrTupleNode concatNode, @Bind PythonLanguage language) {
        SequenceStorage concatenated = concatNode.execute(inliningTarget, left.getSequenceStorage(), right.getSequenceStorage());
        return PFactory.createTuple(language, concatenated);
    }

    @Specialization
    static TruffleString doIt(TruffleString left, TruffleString right, @Cached(inline=false) TruffleString.ConcatNode concatNode) {
        return concatNode.execute((AbstractTruffleString)left, (AbstractTruffleString)right, PythonUtils.TS_ENCODING, false);
    }

    @Fallback
    static Object doIt(VirtualFrame frame, Node inliningTarget, Object v, Object w, @Cached.Exclusive @Cached GetClassNode getVClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached.Exclusive @Cached GetClassNode getWClass, @Cached PySequenceCheckNode pySeqCheckV, @Cached PySequenceCheckNode pySeqCheckW, @Cached CallBinaryOp1Node callBinaryOp1Node, @Cached InlinedBranchProfile hasNbAddSlot, @Cached InlinedBranchProfile hasNbAddResult, @Cached TpSlotBinaryFunc.CallSlotBinaryFuncNode callBinarySlotNode, @Cached PRaiseNode raiseNode) {
        Object classV = getVClass.execute(inliningTarget, v);
        TpSlots slotsV = getVSlots.execute(inliningTarget, classV);
        if (slotsV.sq_concat() != null) {
            return callBinarySlotNode.execute(frame, inliningTarget, slotsV.sq_concat(), v, w);
        }
        if (pySeqCheckV.execute(inliningTarget, v) && pySeqCheckW.execute(inliningTarget, w)) {
            Object classW = getWClass.execute(inliningTarget, w);
            TpSlots slotsW = getWSlots.execute(inliningTarget, classW);
            hasNbAddSlot.enter(inliningTarget);
            Object result = callBinaryOp1Node.execute(frame, inliningTarget, v, classV, slotsV, w, classW, slotsW, TpSlotBinaryOp.ReversibleSlot.NB_ADD);
            if (result != PNotImplemented.NOT_IMPLEMENTED) {
                hasNbAddResult.enter(inliningTarget);
                return result;
            }
        }
        return PySequenceConcatNode.raiseNotSupported(inliningTarget, v, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Node inliningTarget, Object v, PRaiseNode raiseNode) {
        return raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANT_BE_CONCATENATED, v);
    }
}

