/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.engine.AbstractTemplateEvent;
import org.thymeleaf.engine.IEngineTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.IModelVisitor;
import org.thymeleaf.model.IProcessingInstruction;

final class ProcessingInstruction
extends AbstractTemplateEvent
implements IProcessingInstruction,
IEngineTemplateEvent {
    private final String target;
    private final String content;
    private final String processingInstruction;

    ProcessingInstruction(String target, String content) {
        this.target = target;
        this.content = content;
        this.processingInstruction = this.computeProcessingInstruction();
    }

    ProcessingInstruction(String processingInstruction, String target, String content, String templateName, int line, int col) {
        super(templateName, line, col);
        this.target = target;
        this.content = content;
        this.processingInstruction = processingInstruction != null ? processingInstruction : this.computeProcessingInstruction();
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getProcessingInstruction() {
        return this.processingInstruction;
    }

    private String computeProcessingInstruction() {
        StringBuilder strBuilder = new StringBuilder(100);
        strBuilder.append("<?");
        strBuilder.append(this.target);
        if (this.content != null) {
            strBuilder.append(' ');
            strBuilder.append(this.content);
        }
        strBuilder.append("?>");
        return strBuilder.toString();
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.processingInstruction);
    }

    static ProcessingInstruction asEngineProcessingInstruction(IProcessingInstruction processingInstruction) {
        if (processingInstruction instanceof ProcessingInstruction) {
            return (ProcessingInstruction)processingInstruction;
        }
        return new ProcessingInstruction(null, processingInstruction.getTarget(), processingInstruction.getContent(), processingInstruction.getTemplateName(), processingInstruction.getLine(), processingInstruction.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleProcessingInstruction(this);
    }

    public String toString() {
        return this.getProcessingInstruction();
    }
}

