/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.trace;

import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.DatabaseLogHandler;
import com.ibm.db2.cmx.runtime.internal.trace.PrintWriterHandler;
import com.ibm.db2.cmx.runtime.internal.trace.SimpleLogFormatter;
import com.ibm.db2.cmx.runtime.internal.trace.SqlCode;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.ejs.ras.ManagerAdmin;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;

public class Log {
    private static Logger logger__;
    private static String passedCMXServerlogFileName_;
    private static MemoryHandler memoryHandler__;
    public static Object initializeLock__;
    private static Properties lastRefreshProperties;
    public static final String LOGGER_NAME = "com.ibm.db2.cmx";
    public static final String LOGGER_NAME_API = "com.ibm.db2.cmx.api";
    public static final String LOGGER_NAME_API_STATIC = "com.ibm.db2.cmx.api.static";
    public static final String LOGGER_NAME_API_DYNAMIC = "com.ibm.db2.cmx.api.dynamic";
    public static final String LOGGER_NAME_CO = "com.ibm.db2.cmx.co";
    public static final String LOGGER_NAME_CO_STATIC = "com.ibm.db2.cmx.co.static";
    public static final String LOGGER_NAME_CO_DYNAMIC = "com.ibm.db2.cmx.co.dynamic";
    public static final String LOGGER_NAME_CMX = "com.ibm.db2.cmx";
    public static final String LOGGER_NAME_CMX_CLIENT = "com.ibm.db2.cmx.cmxclient";
    public static final String LOGGER_NAME_CMX_SERVER = "com.ibm.db2.cmx.cmxserver";
    public static final String LOGGER_NAME_DATABASE = "com.ibm.db2.cmx.database";
    public static final String LOGGER_NAME_USER_LEVEL = "com.ibm.db2.cmx.userlevel";
    private static Logger userLevelLogger__;
    private static boolean websphereRingBufferAvailable_;
    private static int[] sqlErrorCodesForLogDump;
    private static int randomJVMId__;
    public static Level effectiveParentLoggerLevel_;
    private static boolean loggerInitialized_;
    private static DateFormat dateFormatter__;
    private static Date date__;
    private static final String[] logLevelNames__;
    private static Logger[] loggers__;

    private static synchronized int[] getSqlErrorCodesForLogDump() {
        if (sqlErrorCodesForLogDump == null) {
            Serializable serializable;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n2 : SqlCode.jccErrorCodesToTriggerLogDump) {
                hashSet.add(n2);
            }
            for (int n2 : SqlCode.db2LuwErrorCodesToTriggerLogDump) {
                hashSet.add(n2);
            }
            for (int n2 : SqlCode.db2ZErrorCodesToTriggerLogDump) {
                hashSet.add(n2);
            }
            Object object = new HashSet();
            String string = DataProperties.getProperty("pdq.dumpLogsExcludingSqlCodes");
            if (string != null && string.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    try {
                        serializable = Integer.valueOf(string2);
                        ((HashSet)object).add(serializable);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (string2.toLowerCase().equals("default")) {
                            ((AbstractCollection)object).addAll(hashSet);
                            continue;
                        }
                        Log.getGlobalLogger().log(Level.CONFIG, string2 + " is not a valid integer error code for" + "pdq.dumpLogsExcludingSqlCodes" + " property.");
                        throw numberFormatException;
                    }
                }
            }
            Log.getGlobalLogger();
            String string3 = DataProperties.getProperty("pdq.dumpLogsOnSqlCodes");
            if (string3 == null) {
                string3 = "default";
            }
            if (string3 != null) {
                Object object2;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                serializable = new HashSet();
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken().trim();
                    try {
                        object2 = Integer.valueOf(string4);
                        ((HashSet)serializable).add(object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (string4.toLowerCase().equals("default")) {
                            ((AbstractCollection)((Object)serializable)).addAll(hashSet);
                            continue;
                        }
                        Log.getGlobalLogger().log(Level.CONFIG, string4 + " is not a valid integer error code for " + "pdq.dumpLogsOnSqlCodes" + " property.");
                        throw numberFormatException;
                    }
                }
                ((AbstractSet)((Object)serializable)).removeAll((Collection<?>)object);
                int n3 = ((HashSet)serializable).size();
                object2 = new int[n3];
                int n4 = 0;
                Iterator iterator = ((HashSet)serializable).iterator();
                while (iterator.hasNext()) {
                    Integer n5 = (Integer)iterator.next();
                    object2[n4++] = n5;
                }
                if (((Object)object2).length > 1) {
                    Arrays.sort((int[])object2);
                }
                sqlErrorCodesForLogDump = (int[])object2;
                if (Log.getGlobalLogger().isLoggable(Level.FINEST)) {
                    Log.getGlobalLogger().logp(Level.FINEST, "Log", "getSqlErrorCodesForLogDump", "Error codes that cause a log dump: " + Log.toString(sqlErrorCodesForLogDump));
                }
            } else {
                sqlErrorCodesForLogDump = new int[0];
                if (Log.getGlobalLogger().isLoggable(Level.FINEST)) {
                    Log.getGlobalLogger().logp(Level.FINEST, "Log", "getSqlErrorCodesForLogDump", "Error codes that cause a log dump: none. Set pdq.dumpLogsOnSqlCodes=default in pdq.properties to apply default list of error codes that cause a log buffer dump.");
                }
            }
        }
        return sqlErrorCodesForLogDump;
    }

    private static String toString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (nArray != null) {
            int n2 = nArray.length;
            for (int i10 = 0; i10 < n2; ++i10) {
                stringBuilder.append(Integer.toString(nArray[i10]));
                stringBuilder.append(',');
            }
        }
        return stringBuilder.toString();
    }

    public static Logger getLogger() {
        if (ToolsLogger.isAUtilityRunning()) {
            return ToolsLogger.getLogger();
        }
        return Log.getGlobalLogger();
    }

    public static Logger getAPILogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        return Logger.getLogger(LOGGER_NAME_API);
    }

    public static Logger getClientOptimizerLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        return Logger.getLogger(LOGGER_NAME_CO);
    }

    public static Logger getClientOptimizerStaticLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        Log.getClientOptimizerLogger();
        return Logger.getLogger(LOGGER_NAME_CO_STATIC);
    }

    public static Logger getClientOptimizerDynamicLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        Log.getClientOptimizerLogger();
        return Logger.getLogger(LOGGER_NAME_CO_DYNAMIC);
    }

    public static Logger getCMXLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        return Logger.getLogger("com.ibm.db2.cmx");
    }

    public static Logger getCMXClientLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        Log.getCMXLogger();
        return Logger.getLogger(LOGGER_NAME_CMX_CLIENT);
    }

    public static Logger getCMXServerLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        Log.getCMXLogger();
        return Logger.getLogger(LOGGER_NAME_CMX_SERVER);
    }

    public static Logger getUserLevelLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        Log.getCMXLogger();
        return Logger.getLogger(LOGGER_NAME_USER_LEVEL);
    }

    public static void setLogFileDirectory(String string) {
        if (string != null) {
            passedCMXServerlogFileName_ = string;
        }
    }

    public static String getLogFileDirectory() {
        return passedCMXServerlogFileName_;
    }

    public static Logger getAPIStaticLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        Log.getClientOptimizerLogger();
        return Logger.getLogger(LOGGER_NAME_API_STATIC);
    }

    public static Logger getAPIDynamicLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        Log.getClientOptimizerLogger();
        return Logger.getLogger(LOGGER_NAME_API_DYNAMIC);
    }

    public static Logger getDatabaseLogger() {
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        return Logger.getLogger(LOGGER_NAME_DATABASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getGlobalLogger() {
        if (!DataProperties.isDataPropertiesInitialized()) {
            return Logger.getLogger("com.ibm.db2.cmx");
        }
        if (loggerInitialized_) {
            return logger__;
        }
        Object object = initializeLock__;
        synchronized (object) {
            List<Object> list;
            try {
                logger__ = Logger.getLogger("com.ibm.db2.cmx");
                Log.configureLogger(false, false, null);
            }
            catch (Exception exception) {
                System.err.println(Messages.getText("ERR_INIT_LOG", new Object[0]));
                exception.printStackTrace(System.err);
                logger__ = Logger.getLogger("com.ibm.db2.cmx");
            }
            finally {
                loggerInitialized_ = true;
            }
            try {
                DataVersion.getConfiguration();
            }
            catch (Exception exception) {
                logger__.log(Level.SEVERE, exception.getMessage());
            }
            Log.getSqlErrorCodesForLogDump();
            if (logger__ != null && logger__.isLoggable(Level.SEVERE) && (list = DataProperties.getDeferredExceptionsToLog()) != null) {
                for (Throwable object2 : list) {
                    logger__.log(Level.SEVERE, Messages.getText("ERR_BEFORE_LOG_INIT", new Object[0]), object2);
                }
                DataProperties.setDeferredExceptionsToLog(null);
            }
            if (logger__ != null) {
                list = DataProperties.getDeferredPropertyLogs();
                for (String[] stringArray : list) {
                    DataLogger.logConfigHighVis(logger__, DataProperties.class, stringArray[0], stringArray[1], true);
                }
                DataLogger.logConfigHighVis(logger__, Log.class, "getGlobalLogger", DataLogger.getPmrStamp(), false);
            }
        }
        return logger__;
    }

    public static Logger configureLogger(boolean bl2, boolean bl3, Properties properties) throws NumberFormatException, Exception {
        Handler handler;
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n4;
        Logger[] loggerArray;
        Level level;
        Level level2;
        Level level3 = Level.OFF;
        Level level4 = Log.getEffectiveLogLevelOfGlobalLogger();
        String string = DataProperties.getProperty("pdq.traceFile");
        String string2 = DataProperties.getProperty("pdq.traceLevel");
        Level level5 = level2 = Log.getLevelFromPropertyValue(string2);
        String string3 = passedCMXServerlogFileName_;
        String string4 = DataProperties.getProperty("pdq.cmxServerLogTraceLevel");
        Level level6 = level = Log.getLevelFromPropertyValue(string4);
        if (logger__ == null) {
            logger__ = Log.getGlobalLogger();
            return logger__;
        }
        if (level2.intValue() <= level4.intValue() || bl3 && !bl2 && logger__.getLevel() != null) {
            logger__.setLevel(level2);
            loggerArray = Log.getAllLoggers();
            for (n4 = 1; n4 < loggerArray.length; ++n4) {
                object5 = loggerArray[n4];
                object4 = ((Logger)object5).getLevel();
                if (object4 == null || level2.intValue() > ((Level)object4).intValue()) continue;
                ((Logger)object5).setLevel(level2);
            }
        }
        loggerArray = Log.getAllLoggers();
        for (n4 = 1; n4 < loggerArray.length; ++n4) {
            object5 = logLevelNames__[n4];
            object4 = loggerArray[n4];
            object3 = DataProperties.getProperty((String)object5);
            if (object3 == null) continue;
            object3 = ((String)object3).trim();
            ((Logger)object4).setLevel(Log.getLevelFromPropertyValue((String)object3));
            if (((Logger)object4).getLevel().intValue() > level5.intValue()) continue;
            level5 = ((Logger)object4).getLevel();
        }
        userLevelLogger__ = Log.getUserLevelLogger();
        userLevelLogger__.setLevel(level);
        userLevelLogger__.setUseParentHandlers(false);
        String string5 = "pdq.traceLevel.com.ibm.db2.cmx";
        object5 = logger__;
        object4 = DataProperties.getProperty(string5);
        if (object4 != null) {
            object4 = ((String)object4).trim();
            ((Logger)object5).setLevel(Log.getLevelFromPropertyValue((String)object4));
            if (((Logger)object5).getLevel().intValue() <= level5.intValue()) {
                level5 = ((Logger)object5).getLevel();
            }
        }
        if (!bl3) {
            object3 = Log.getDatabaseLogger();
            ((Logger)object3).setUseParentHandlers(false);
            if (((Logger)object3).getLevel() != null && ((Logger)object3).isLoggable(Level.CONFIG)) {
                ((Logger)object3).addHandler(new DatabaseLogHandler());
            } else {
                ((Logger)object3).addHandler(new DatabaseLogHandler());
                ((Logger)object3).setLevel(Level.OFF);
            }
        }
        object3 = DataProperties.getProperty("pdq.enableRollingLog");
        String string6 = DataProperties.getProperty("pdq.rollingLogFileCount");
        String string7 = DataProperties.getProperty("pdq.rollingLogFileSize");
        String string8 = DataProperties.getProperty("pdq.enableCMXServerLog");
        String string9 = passedCMXServerlogFileName_;
        String string10 = DataProperties.getProperty("pdq.cmxServerLogFileCount");
        String string11 = DataProperties.getProperty("pdq.cmxServerLogFileSize");
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        String string18 = null;
        String string19 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl3 && !bl2) {
            string12 = properties.getProperty("pdq.traceFile");
            string13 = properties.getProperty("pdq.enableRollingLog");
            string14 = properties.getProperty("pdq.rollingLogFileCount");
            string15 = properties.getProperty("pdq.rollingLogFileSize");
            bl4 = string12 == null && string != null || string12 != null && !string12.equals(string);
            bl5 = string13 == null && object3 != null || !string13.equals(object3) || string14 == null && string6 != null || !string14.equals(string6) || string15 == null && string7 != null || !string15.equals(string7);
            bl6 = level3.equals(Level.OFF) && !level5.equals(Level.OFF);
            bl7 = !level3.equals(Level.OFF) && level5.equals(Level.OFF);
        }
        boolean bl8 = false;
        boolean bl9 = false;
        if (bl2) {
            string17 = passedCMXServerlogFileName_;
            string16 = properties.getProperty("pdq.enableCMXServerLog");
            string18 = properties.getProperty("pdq.cmxServerLogFileCount");
            string19 = properties.getProperty("pdq.cmxServerLogFileSize");
            bl8 = string17 == null && string9 != null || !string17.equals(string9);
            boolean bl10 = bl9 = string16 == null && string8 != null || !string16.equals(string8) || string18 == null && string10 != null || !string18.equals(string10) || string19 == null && string11 != null || !string19.equals(string11);
        }
        if (bl5 || bl4 || bl7) {
            object = object2 = logger__.getHandlers();
            n3 = ((Handler[])object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                handler = object[n2];
                logger__.removeHandler(handler);
            }
        }
        if (bl2) {
            object = object2 = userLevelLogger__.getHandlers();
            n3 = ((Handler[])object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                handler = object[n2];
                userLevelLogger__.removeHandler(handler);
            }
        }
        if (!bl3 || bl5 || bl4 || bl6) {
            if (!level5.equals(Level.OFF) && string != null && ((String)object3).equals("ON")) {
                object2 = null;
                object2 = new FileHandler(string, Integer.valueOf(string7), (int)Integer.valueOf(string6), false);
                ((Handler)object2).setFormatter(new SimpleLogFormatter());
                logger__.addHandler((Handler)object2);
            } else if (!level5.equals(Level.OFF) && string != null && ((String)object3).equals("OFF")) {
                object2 = new PrintWriterHandler(DataLogger.getPrintWriter(string));
                logger__.addHandler((Handler)object2);
            }
        }
        if (bl2) {
            object2 = null;
            if (!level6.equals(Level.OFF) && string3 != null && string8.equals("ON")) {
                object2 = new FileHandler(string3, Integer.valueOf(string11), (int)Integer.valueOf(string10), false);
                ((Handler)object2).setFormatter(new SimpleLogFormatter(true));
                userLevelLogger__.addHandler((Handler)object2);
            }
        }
        if (!bl3) {
            object2 = null;
            if (!level5.equals(Level.OFF) && ((String)object3).equals("OFF")) {
                Level level7;
                if (string != null) {
                    object2 = new PrintWriterHandler(DataLogger.getPrintWriter(string));
                } else if ("ON".equalsIgnoreCase(DataProperties.getProperty("pdq.consoleTrace")) && !Level.OFF.equals(level7 = Log.getLevelFromPropertyValue((String)(object = string2)))) {
                    PrintWriterHandler printWriterHandler = new PrintWriterHandler(new PrintWriter(System.out));
                    printWriterHandler.setFormatter(new SimpleLogFormatter());
                    logger__.addHandler(printWriterHandler);
                }
            }
            if (object2 != null && ((String)object3).equals("OFF")) {
                int n5;
                memoryHandler__ = null;
                object = DataProperties.getProperty("pdq.traceBufferRowCount");
                if (object != null && ((String)object).length() > 0 && (n5 = Integer.parseInt(((String)object).trim())) > 0) {
                    logger__.removeHandler((Handler)object2);
                    memoryHandler__ = new MemoryHandler((Handler)object2, n5, Level.SEVERE);
                    logger__.addHandler(memoryHandler__);
                }
            }
        }
        level3 = level5;
        if (bl3 && (bl5 || bl4)) {
            DataProperties.logReconfiguredProperties();
        }
        if (bl2) {
            DataProperties.logReconfiguredProperties();
        }
        return logger__;
    }

    public static Level getLevelFromPropertyValue(String string) {
        Level level = Log.getLevelFromPropertyValueNullIfNotFound(string);
        return null != level ? level : Level.OFF;
    }

    public static Level getLevelFromPropertyValueNullIfNotFound(String string) {
        if (string != null) {
            string = string.trim();
        }
        if ("OFF".equalsIgnoreCase(string)) {
            return Level.OFF;
        }
        if ("SEVERE".equalsIgnoreCase(string)) {
            return Level.SEVERE;
        }
        if ("WARNING".equalsIgnoreCase(string)) {
            return Level.WARNING;
        }
        if ("INFO".equalsIgnoreCase(string)) {
            return Level.INFO;
        }
        if ("CONFIG".equalsIgnoreCase(string)) {
            return Level.CONFIG;
        }
        if ("FINE".equalsIgnoreCase(string)) {
            return Level.FINE;
        }
        if ("FINER".equalsIgnoreCase(string)) {
            return Level.FINER;
        }
        if ("FINEST".equalsIgnoreCase(string)) {
            return Level.FINEST;
        }
        if ("ALL".equalsIgnoreCase(string)) {
            return Level.ALL;
        }
        if ("ON".equalsIgnoreCase(string)) {
            return Level.ALL;
        }
        if ("-1".equalsIgnoreCase(string)) {
            return Level.ALL;
        }
        return null;
    }

    public static Level getEffectiveLogLevelOfGlobalLogger() {
        if (effectiveParentLoggerLevel_ == null) {
            effectiveParentLoggerLevel_ = Log.getEffectiveLogLevel(logger__);
        }
        return effectiveParentLoggerLevel_;
    }

    public static Level getEffectiveLogLevel(Logger logger) {
        Level level = null;
        Level level2 = null;
        for (Logger logger2 = logger; logger2 != null && (level2 = logger2.getLevel()) == null; logger2 = logger2.getParent()) {
        }
        level = level2 == null ? Level.OFF : level2;
        return level;
    }

    public static void dumpRingBuffer(Throwable throwable) {
        String string = DataProperties.getProperty("pdq.traceFile");
        if (memoryHandler__ != null) {
            memoryHandler__.push();
        } else if (websphereRingBufferAvailable_) {
            String string2 = DataProperties.getProperty("pdq.dumpLogsOnSqlCodes");
            if (string2 == null) {
                Log.getGlobalLogger().logp(Level.FINEST, "Log", "dumpRingBuffer", "pdq.dumpLogsOnSqlCodes property was not specified. Logs will not be dumped. Set pdq.dumpLogsOnSqlCodes=default to apply default list of error codes that cause a log buffer dump.");
                Log.insertLogToDb(throwable, string, false);
                return;
            }
            try {
                string = Log.dumpRingBufferInternal();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                websphereRingBufferAvailable_ = false;
                String string3 = noClassDefFoundError.getMessage();
                if (!"com.ibm.ejs.ras.ManagerAdmin".endsWith(string3)) {
                    Log.getGlobalLogger().log(Level.ALL, "dumpRingBuffer: If not using Webspehere's ring buffer, then ignore this error.", noClassDefFoundError);
                }
            }
            catch (Exception exception) {
                websphereRingBufferAvailable_ = false;
                DataLogger.logThrowable(Log.getGlobalLogger(), exception);
            }
        }
        Log.insertLogToDb(throwable, string, true);
    }

    private static void insertLogToDb(Throwable throwable, String string, boolean bl2) {
        Logger logger;
        if (throwable != null && (logger = Log.getDatabaseLogger()).isLoggable(Level.CONFIG)) {
            if (bl2) {
                logger.logp(Level.CONFIG, "dump", string, "Error: " + throwable.getMessage() + "\n\nIf log buffering was enabled, a log dump was made into " + string + ".", throwable);
            } else {
                logger.logp(Level.CONFIG, "dump", string, "Error: " + throwable.getMessage() + "\n\nLog buffering was not enabled because pdq.dumpLogsOnSqlCodes was not set. Log dump was not made.", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dumpRingBufferInternal() {
        String string = DataProperties.getProperty("pdq.traceFile");
        if (string == null || string.trim().length() == 0) {
            string = "pdq.log";
        }
        if (string != null) {
            String string2;
            DateFormat dateFormat = dateFormatter__;
            synchronized (dateFormat) {
                date__.setTime(System.currentTimeMillis());
                string2 = dateFormatter__.format(date__);
            }
            if (string != null) {
                int n2 = string.lastIndexOf(46);
                string = n2 > -1 ? string.substring(0, n2) + "." + string2 + string.substring(n2) : string + "." + string2 + ".log";
            }
        }
        ManagerAdmin.dumpRingBuffer((String)string);
        return string;
    }

    public static boolean isLoggable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n2 = sQLException.getErrorCode();
            if (Log.isLoggableErrorCode(n2)) {
                if (ErrorLog.addNewError(n2)) {
                    return true;
                }
                logger__.logp(Level.FINEST, "Log", "isLoggable", "Skipping log dump. We have already processed error code " + n2 + " within the last 5 minutes.");
                return false;
            }
        } else {
            return true;
        }
        return false;
    }

    private static boolean isLoggableErrorCode(int n2) {
        int[] nArray = Log.getSqlErrorCodesForLogDump();
        return Arrays.binarySearch(nArray, n2) >= 0;
    }

    public static void updateLoggersIfNeeded(Properties properties) {
        Log.setLogLevelsIfNeeded(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setLogLevelsIfNeeded(Properties properties) {
        Object object;
        String string;
        String string2;
        String string3;
        Object object2;
        Logger[] loggerArray = Log.getAllLoggers();
        for (int i10 = 0; i10 < loggerArray.length; ++i10) {
            object2 = logLevelNames__[i10];
            string3 = properties.getProperty((String)object2);
            if (string3 == null) continue;
            string3 = string3.trim();
            string2 = lastRefreshProperties.getProperty((String)object2);
            if (string2 != null && string2.equals(string3)) continue;
            logger__.log(Level.CONFIG, "Applying " + (String)object2 + " = " + string3);
            loggerArray[i10].setLevel(Log.getLevelFromPropertyValue(string3));
            lastRefreshProperties.setProperty((String)object2, string3);
        }
        String string4 = "pdq.traceLevel.com.ibm.db2.cmx";
        object2 = logger__;
        string3 = DataProperties.getProperty(string4);
        if (string3 != null) {
            string3 = string3.trim();
            logger__.log(Level.CONFIG, "Applying " + string4 + " = " + string3);
            ((Logger)object2).setLevel(Log.getLevelFromPropertyValue(string3));
        }
        string2 = properties.getProperty("pdq.dumpLogsExcludingSqlCodes");
        boolean bl2 = false;
        if (!(string2 == null || string2.length() <= 0 || (string = lastRefreshProperties.getProperty("pdq.dumpLogsExcludingSqlCodes")) != null && string.equals(string2))) {
            logger__.log(Level.CONFIG, "Applying " + string4 + " = " + string2);
            lastRefreshProperties.setProperty("pdq.dumpLogsExcludingSqlCodes", string2);
            bl2 = true;
        }
        if (!((string = properties.getProperty("pdq.dumpLogsOnSqlCodes")) == null || string.length() <= 0 || (object = lastRefreshProperties.getProperty("pdq.dumpLogsOnSqlCodes")) != null && ((String)object).equals(string))) {
            logger__.log(Level.CONFIG, "Applying " + string4 + " = " + string);
            lastRefreshProperties.setProperty("pdq.dumpLogsOnSqlCodes", string);
            bl2 = true;
        }
        if (!bl2) return;
        object = Log.class;
        synchronized (Log.class) {
            sqlErrorCodesForLogDump = null;
            // ** MonitorExit[var8_9] (shouldn't be in output)
            return;
        }
    }

    private static Logger[] getAllLoggers() {
        Logger[] loggerArray;
        if (logger__ == null) {
            Log.getGlobalLogger();
        }
        if ((loggerArray = loggers__) == null) {
            loggerArray = new Logger[]{logger__, Log.getAPILogger(), Log.getCMXLogger(), Log.getCMXClientLogger(), Log.getCMXServerLogger(), Log.getClientOptimizerLogger(), Log.getClientOptimizerDynamicLogger(), Log.getClientOptimizerStaticLogger(), Log.getAPIDynamicLogger(), Log.getAPIStaticLogger(), Log.getDatabaseLogger()};
            loggers__ = loggerArray;
        }
        return loggerArray;
    }

    public static int getRandomJVMID(String string) {
        if (randomJVMId__ == -1) {
            if (string == null) {
                string = "";
            }
            int n2 = 0;
            char[] cArray = string.toCharArray();
            for (int i10 = 0; i10 < cArray.length; ++i10) {
                n2 += cArray[i10] + i10;
            }
            Random random = new Random(n2);
            int n3 = random.nextInt(1000000000);
            random = new Random(System.currentTimeMillis());
            int n4 = random.nextInt(1000000000);
            randomJVMId__ = n3 + n4;
        }
        return randomJVMId__;
    }

    private static void bubbleSortErrorCodes(int[] nArray, long[] lArray) {
        boolean bl2;
        int n2 = lArray.length;
        int n3 = 0;
        do {
            bl2 = false;
            ++n3;
            for (int i10 = 0; i10 < n2 - n3; ++i10) {
                int n4 = i10 + 1;
                if (lArray[i10] >= lArray[n4]) continue;
                long l2 = lArray[n4];
                lArray[n4] = lArray[i10];
                lArray[i10] = l2;
                int n5 = nArray[n4];
                nArray[n4] = nArray[i10];
                nArray[i10] = n5;
                bl2 = true;
            }
        } while (bl2);
    }

    static {
        passedCMXServerlogFileName_ = null;
        initializeLock__ = new Object();
        lastRefreshProperties = new Properties();
        websphereRingBufferAvailable_ = true;
        sqlErrorCodesForLogDump = null;
        randomJVMId__ = -1;
        dateFormatter__ = new SimpleDateFormat("yyyyMMdd_HH_mm_ss_SSS");
        date__ = new Date();
        logLevelNames__ = new String[]{"pdq.traceLevel", "pdq.traceLevel.com.ibm.db2.cmx.api", "pdq.traceLevel.com.ibm.db2.cmx", "pdq.traceLevel.com.ibm.db2.cmx.cmxclient", "pdq.traceLevel.com.ibm.db2.cmx.cmxserver", "pdq.traceLevel.com.ibm.db2.cmx.co", "pdq.traceLevel.com.ibm.db2.cmx.co.dynamic", "pdq.traceLevel.com.ibm.db2.cmx.co.static", "pdq.traceLevel.com.ibm.db2.cmx.api.dynamic", "pdq.traceLevel.com.ibm.db2.cmx.api.static", "pdq.traceLevel.com.ibm.db2.cmx.database"};
        loggers__ = null;
    }

    static class ErrorLog {
        static final int NUM_ERR_CODES = 5;
        static final long timePeriod__ = 300000L;
        static int[] errorCodes_ = new int[5];
        static long[] lastDumpTimeInMillis_ = new long[5];

        ErrorLog() {
        }

        public static synchronized boolean addNewError(int n2) {
            long l2 = System.currentTimeMillis();
            int n3 = errorCodes_.length;
            for (int i10 = 0; i10 < n3; ++i10) {
                if (n2 != errorCodes_[i10]) continue;
                if (lastDumpTimeInMillis_[i10] > l2 - 300000L) {
                    return false;
                }
                ErrorLog.lastDumpTimeInMillis_[i10] = l2;
                return true;
            }
            Log.bubbleSortErrorCodes(ErrorLog.errorCodes_, ErrorLog.lastDumpTimeInMillis_);
            System.arraycopy(errorCodes_, 0, errorCodes_, 1, 4);
            System.arraycopy(lastDumpTimeInMillis_, 0, lastDumpTimeInMillis_, 1, 4);
            ErrorLog.errorCodes_[0] = n2;
            ErrorLog.lastDumpTimeInMillis_[0] = l2;
            return true;
        }
    }
}

