/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.jdbc.connector.OracleLocalTransaction;
import oracle.jdbc.connector.OracleManagedConnectionMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.xa.OracleXAConnection;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_MANAGEMENT})
public class OracleManagedConnection
implements ManagedConnection {
    private OracleXAConnection xaConnection;
    private Hashtable connectionListeners;
    private Connection connection;
    private PrintWriter logWriter;
    private PasswordCredential passwordCredential;
    private OracleLocalTransaction localTxn;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    OracleManagedConnection(XAConnection xaconn) {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$15, null, xaconn);
            }
            this.xaConnection = null;
            this.connectionListeners = null;
            this.connection = null;
            this.logWriter = null;
            this.passwordCredential = null;
            this.localTxn = null;
            this.xaConnection = (OracleXAConnection)xaconn;
            this.connectionListeners = new Hashtable(10);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection connection;
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$0, this, subject, connectionRequestInfo);
                }
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    connection = this.connection = this.xaConnection.getConnection();
                    if (!bl) break block8;
                }
                catch (SQLException exc) {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    EISSystemException eISSystemException = rexc;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$0, this, (Throwable)eISSystemException);
                    }
                    throw eISSystemException;
                }
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$0, this, connection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$0, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void destroy() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$1, this, new Object[0]);
            }
            try {
                if (this.xaConnection != null) {
                    Connection _pconn = this.xaConnection.getPhysicalHandle();
                    if (this.localTxn != null && this.localTxn.isBeginCalled || ((OracleConnection)_pconn).getTxnMode() == 1) {
                        IllegalStateException illegalStateException = new IllegalStateException("Could not close connection while transaction is active");
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$1, this, (Throwable)illegalStateException);
                        }
                        throw illegalStateException;
                    }
                }
                if (this.connection != null) {
                    this.connection.close();
                }
                if (this.xaConnection != null) {
                    this.xaConnection.close();
                }
            }
            catch (SQLException exc) {
                EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                EISSystemException eISSystemException = rexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$1, this, (Throwable)eISSystemException);
                }
                throw eISSystemException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public void cleanup() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$2, this, new Object[0]);
            }
            try {
                if (this.connection != null) {
                    if (this.localTxn != null && this.localTxn.isBeginCalled || ((OracleConnection)this.connection).getTxnMode() == 1) {
                        IllegalStateException illegalStateException = new IllegalStateException("Could not close connection while transaction is active");
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$2, this, (Throwable)illegalStateException);
                        }
                        throw illegalStateException;
                    }
                    this.connection.close();
                }
            }
            catch (SQLException exc) {
                EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                EISSystemException eISSystemException = rexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$2, this, (Throwable)eISSystemException);
                }
                throw eISSystemException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public void associateConnection(Object object) {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$3, this, object);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            void listener;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$4, this, connectionEventListener);
            }
            this.connectionListeners.put(listener, listener);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            void listener;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$5, this, connectionEventListener);
            }
            this.connectionListeners.remove(listener);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    public XAResource getXAResource() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            XAResource xAResource;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$6, this, new Object[0]);
                }
                try {
                    xAResource = this.xaConnection.getXAResource();
                    if (!bl) break block7;
                }
                catch (SQLException e2) {
                    ResourceException resourceException = new ResourceException((Throwable)e2);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$6, this, (Throwable)resourceException);
                    }
                    throw resourceException;
                }
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$6, this, xAResource);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$6, this, null);
            }
            return xAResource;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (this.localTxn == null) {
                this.localTxn = new OracleLocalTransaction(this);
            }
            OracleLocalTransaction oracleLocalTransaction = this.localTxn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$7, this, oracleLocalTransaction);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$7, this, null);
            }
            return oracleLocalTransaction;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$8, this, new Object[0]);
            }
            OracleManagedConnectionMetaData oracleManagedConnectionMetaData = new OracleManagedConnectionMetaData(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$8, this, oracleManagedConnectionMetaData);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$8, this, null);
            }
            return oracleManagedConnectionMetaData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            void out;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$9, this, printWriter);
            }
            this.logWriter = out;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$10, this, new Object[0]);
            }
            PrintWriter printWriter = this.logWriter;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$10, this, printWriter);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$10, this, null);
            }
            return printWriter;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    Connection getPhysicalConnection() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection connection;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$11, this, new Object[0]);
                }
                try {
                    connection = this.xaConnection.getPhysicalHandle();
                    if (!bl) break block7;
                }
                catch (Exception exc) {
                    EISSystemException rexc = new EISSystemException("Exception: " + exc.getMessage());
                    rexc.setLinkedException(exc);
                    EISSystemException eISSystemException = rexc;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$11, this, (Throwable)eISSystemException);
                    }
                    throw eISSystemException;
                }
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$11, this, connection);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$11, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setPasswordCredential(PasswordCredential passwordCredential) {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pcred;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$12, this, passwordCredential);
            }
            this.passwordCredential = pcred;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    PasswordCredential getPasswordCredential() {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$13, this, new Object[0]);
            }
            PasswordCredential passwordCredential = this.passwordCredential;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$13, this, passwordCredential);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$13, this, null);
            }
            return passwordCredential;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void eventOccurred(int n2) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$14, this, n2);
            }
            Enumeration allListeners = this.connectionListeners.keys();
            block9: while (allListeners.hasMoreElements()) {
                void eventType;
                ConnectionEventListener listener = (ConnectionEventListener)allListeners.nextElement();
                ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, (int)eventType);
                switch (eventType) {
                    case 1: {
                        listener.connectionClosed(ce);
                        continue block9;
                    }
                    case 2: {
                        listener.localTransactionStarted(ce);
                        continue block9;
                    }
                    case 3: {
                        listener.localTransactionCommitted(ce);
                        continue block9;
                    }
                    case 4: {
                        listener.localTransactionRolledback(ce);
                        continue block9;
                    }
                    case 5: {
                        listener.connectionErrorOccurred(ce);
                        continue block9;
                    }
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal eventType in eventOccurred(): " + (int)eventType);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$14, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleManagedConnection.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$15 = OracleManagedConnection.class.getDeclaredConstructor(XAConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleManagedConnection.class.getDeclaredMethod("eventOccurred", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleManagedConnection.class.getDeclaredMethod("getPasswordCredential", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleManagedConnection.class.getDeclaredMethod("setPasswordCredential", PasswordCredential.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleManagedConnection.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleManagedConnection.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleManagedConnection.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleManagedConnection.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleManagedConnection.class.getDeclaredMethod("getLocalTransaction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleManagedConnection.class.getDeclaredMethod("getXAResource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleManagedConnection.class.getDeclaredMethod("removeConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleManagedConnection.class.getDeclaredMethod("addConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleManagedConnection.class.getDeclaredMethod("associateConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleManagedConnection.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleManagedConnection.class.getDeclaredMethod("destroy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleManagedConnection.class.getDeclaredMethod("getConnection", Subject.class, ConnectionRequestInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

