/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class CancelLock {
    private CancelState state;
    private OracleStatement statement;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    CancelLock(OracleStatement stmt) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null, stmt);
            }
            this.state = null;
            this.statement = null;
            this.statement = stmt;
            this.state = new CancelState();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    boolean isIdle() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.state.acquireCloseableLock();
                try {
                    boolean bl3 = this.state.isIdle();
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, throwable4);
            }
            throw throwable;
        }
    }

    boolean isCanceled() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.state.acquireCloseableLock();
                try {
                    boolean bl3 = this.state.isCanceled();
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    void enterExecuting() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.state.acquireCloseableLock();
            try {
                if (!$assertionsDisabled && !this.state.isIdle()) {
                    AssertionError assertionError = new AssertionError();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                this.state.setExecuting();
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void exitExecuting() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block23: {
                Monitor.CloseableLock lock;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, new Object[0]);
                }
                while (true) {
                    lock = this.state.acquireCloseableLock();
                    if (this.state.isExecuting()) {
                        this.state.setIdle();
                        if (lock != null) {
                            lock.close();
                        }
                        break block23;
                    }
                    if (this.state.isCanceling()) {
                        try {
                            this.state.monitorWait();
                        }
                        finally {
                            if (lock == null) continue;
                            lock.close();
                            continue;
                        }
                    }
                    if (this.state.isCanceled()) {
                        if (this.statement != null && this.statement.connection.cancelInProgressFlag && bl) {
                            OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "Cancel still in progress ...");
                        }
                        this.state.setIdle();
                        if (lock != null) {
                            lock.close();
                        }
                        break block23;
                    }
                    if (lock == null) continue;
                    lock.close();
                    continue;
                    break;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    boolean enterCanceling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, new Object[0]);
                        }
                        lock = this.state.acquireCloseableLock();
                        try {
                            if (!this.state.isExecuting()) break block13;
                            this.state.setCanceling();
                            boolean bl4 = true;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, null);
                    }
                    return bl3;
                }
                boolean bl5 = false;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, throwable4);
            }
            throw throwable;
        }
    }

    void exitCanceling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.state.acquireCloseableLock();
            try {
                if (!$assertionsDisabled && !this.state.isCanceling()) {
                    AssertionError assertionError = new AssertionError();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                this.state.setCanceled();
                this.state.monitorNotify();
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, throwable4);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = CancelLock.class.getDeclaredConstructor(OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CancelLock.class.getDeclaredMethod("exitCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CancelLock.class.getDeclaredMethod("enterCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CancelLock.class.getDeclaredMethod("exitExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CancelLock.class.getDeclaredMethod("enterExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CancelLock.class.getDeclaredMethod("isCanceled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CancelLock.class.getDeclaredMethod("isIdle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

