
/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * IUnknown.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_2;

import org.virtualbox_7_2.jaxws.*;
import javax.xml.ws.*;

public class IUnknown
{
    protected String obj;
    protected ObjectRefManager objMgr;
    protected final VboxPortType port;

    public IUnknown(String obj, ObjectRefManager objMgr, VboxPortType port)
    {
        this.obj    = obj;
        this.objMgr = objMgr;
        this.port   = port;
        objMgr.registerObj(this);
    }

    public final String getWrapped()
    {
        return this.obj;
    }

    public final VboxPortType getRemoteWSPort()
    {
        return this.port;
    }

    public final ObjectRefManager getObjMgr()
    {
        return this.objMgr;
    }

    public synchronized void releaseRemote() throws WebServiceException
    {
        if (obj == null)
            return;

        try
        {
            this.port.iManagedObjectRefRelease(obj);
            this.obj = null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new WebServiceException(e);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new WebServiceException(e);
        }
    }
}
