; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -global-isel -verify-machineinstrs -stop-after=irtranslator < %s | FileCheck %s

%struct.A = type { i8, float, i32, i32, i32 }

define void @f() {
  ; CHECK-LABEL: name: f
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}

define void @foo1(i32 %x){
  ; CHECK-LABEL: name: foo1
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[COPY]](s64)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
    ret void
}

define void @foo2(i64 %x){
  ; CHECK-LABEL: name: foo2
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
    ret void
}

define void @foo3(<7 x i8> %x) {
  ; CHECK-LABEL: name: foo3
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x8
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x9
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<7 x s64>) = G_BUILD_VECTOR [[COPY]](s64), [[COPY1]](s64), [[COPY2]](s64), [[COPY3]](s64), [[COPY4]](s64), [[COPY5]](s64), [[COPY6]](s64)
  ; CHECK:   [[TRUNC7:%[0-9]+]]:_(<7 x s8>) = G_TRUNC [[BUILD_VECTOR]](<7 x s64>)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}



define void @foo_notrunc(<7 x i64> %x) {
  ; CHECK-LABEL: name: foo_notrunc
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x8
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x9
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<7 x s64>) = G_BUILD_VECTOR [[COPY]](s64), [[COPY1]](s64), [[COPY2]](s64), [[COPY3]](s64), [[COPY4]](s64), [[COPY5]](s64), [[COPY6]](s64)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}

define void @foo_pt(ptr %x) {
  ; CHECK-LABEL: name: foo_pt
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x3
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}

; TODO: The correct registers used to pass struct arguments in this example
; are R3, R4 and R5. Currently, the calling convention used for GlobalISel
; does not handle passing structs and will need to implemented at a later time.
define dso_local void @foo_struct(%struct.A %a) #0 {
  ; CHECK-LABEL: name: foo_struct
  ; CHECK: bb.1.entry:
  ; CHECK:   liveins: $f1, $x3, $x5, $x6, $x7
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[COPY]](s64)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $f1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK:   [[TRUNC2:%[0-9]+]]:_(s32) = G_TRUNC [[COPY2]](s64)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK:   [[TRUNC3:%[0-9]+]]:_(s32) = G_TRUNC [[COPY3]](s64)
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK:   [[TRUNC4:%[0-9]+]]:_(s32) = G_TRUNC [[COPY4]](s64)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
entry:
  ret void
}

define void @foo_int(ptr %x) {
  ; CHECK-LABEL: name: foo_int
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x3
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}

define void @foo(ptr %x) {
  ; CHECK-LABEL: name: foo
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x3
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}

define void @foo_multiple(i1 %a, i8 %b, i16 %c, i32 %d, i64 %e, i128 %f){
  ; CHECK-LABEL: name: foo_multiple
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s1) = G_TRUNC [[COPY]](s64)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s8) = G_TRUNC [[COPY1]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK:   [[TRUNC2:%[0-9]+]]:_(s16) = G_TRUNC [[COPY2]](s64)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK:   [[TRUNC3:%[0-9]+]]:_(s32) = G_TRUNC [[COPY3]](s64)
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x8
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x9
  ; CHECK:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY5]](s64), [[COPY6]](s64)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
    ret void
}

define void @foo_multiple_same_ty(i64 %x, i64 %y, i64 %z){
  ; CHECK-LABEL: name: foo_multiple_same_ty
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3, $x4, $x5
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
    ret void
}

define void @foo_float(float %x) {
  ; CHECK-LABEL: name: foo_float
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $f1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $f1
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}

define void @foo_dbl(double %x) {
  ; CHECK-LABEL: name: foo_dbl
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $f1
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $f1
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}

define void @foo_array([7 x i8] %x) {
  ; CHECK-LABEL: name: foo_array
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[COPY]](s64)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s8) = G_TRUNC [[COPY1]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK:   [[TRUNC2:%[0-9]+]]:_(s8) = G_TRUNC [[COPY2]](s64)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK:   [[TRUNC3:%[0-9]+]]:_(s8) = G_TRUNC [[COPY3]](s64)
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK:   [[TRUNC4:%[0-9]+]]:_(s8) = G_TRUNC [[COPY4]](s64)
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x8
  ; CHECK:   [[TRUNC5:%[0-9]+]]:_(s8) = G_TRUNC [[COPY5]](s64)
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x9
  ; CHECK:   [[TRUNC6:%[0-9]+]]:_(s8) = G_TRUNC [[COPY6]](s64)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
  ret void
}
