; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2,+gfni | FileCheck %s --check-prefixes=GFNISSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512BW

;
; 128 Bit Vector Shifts
;

define <16 x i8> @var_shl_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: var_shl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    psllw $5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm0, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    paddb %xmm2, %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: var_shl_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpaddb %xmm0, %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_shl_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_shl_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %shift = shl <16 x i8> %a, %b
  ret <16 x i8> %shift
}

define <16 x i8> @var_lshr_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: var_lshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    psllw $5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm0, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: var_lshr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_lshr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_lshr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %shift = lshr <16 x i8> %a, %b
  ret <16 x i8> %shift
}

define <16 x i8> @var_ashr_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: var_ashr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    psllw $5, %xmm1
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; GFNISSE-NEXT:    movdqa %xmm3, %xmm4
; GFNISSE-NEXT:    psraw $4, %xmm4
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm4
; GFNISSE-NEXT:    psraw $2, %xmm4
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm4
; GFNISSE-NEXT:    psraw $1, %xmm4
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    psraw $4, %xmm2
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    psraw $2, %xmm2
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    psraw $1, %xmm2
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: var_ashr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1OR2-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1OR2-NEXT:    vpsraw $4, %xmm3, %xmm4
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm2, %xmm4, %xmm3, %xmm3
; GFNIAVX1OR2-NEXT:    vpsraw $2, %xmm3, %xmm4
; GFNIAVX1OR2-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm2, %xmm4, %xmm3, %xmm3
; GFNIAVX1OR2-NEXT:    vpsraw $1, %xmm3, %xmm4
; GFNIAVX1OR2-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm2, %xmm4, %xmm3, %xmm2
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1OR2-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1OR2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1OR2-NEXT:    vpsraw $4, %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpsraw $2, %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpaddw %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpsraw $1, %xmm0, %xmm3
; GFNIAVX1OR2-NEXT:    vpaddw %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_ashr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpsravd %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_ashr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpmovsxbw %xmm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsravw %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %shift = ashr <16 x i8> %a, %b
  ret <16 x i8> %shift
}

define <16 x i8> @splatvar_shl_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_shl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psllw %xmm1, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm2, %xmm2
; GFNISSE-NEXT:    psllw %xmm1, %xmm2
; GFNISSE-NEXT:    pxor %xmm1, %xmm1
; GFNISSE-NEXT:    pshufb %xmm1, %xmm2
; GFNISSE-NEXT:    pand %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_shl_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; GFNIAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_shl_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; GFNIAVX2-NEXT:    vpbroadcastb %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_shl_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpslld %xmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_shl_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %shift = shl <16 x i8> %a, %splat
  ret <16 x i8> %shift
}

define <16 x i8> @splatvar_lshr_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_lshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psrlw %xmm1, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm2, %xmm2
; GFNISSE-NEXT:    psrlw %xmm1, %xmm2
; GFNISSE-NEXT:    pshufb {{.*#+}} xmm2 = xmm2[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNISSE-NEXT:    pand %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_lshr_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNIAVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_lshr_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpbroadcastb %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_lshr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrld %xmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_lshr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %shift = lshr <16 x i8> %a, %splat
  ret <16 x i8> %shift
}

define <16 x i8> @splatvar_ashr_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_ashr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psrlw %xmm1, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm2, %xmm2
; GFNISSE-NEXT:    psrlw %xmm1, %xmm2
; GFNISSE-NEXT:    pshufb {{.*#+}} xmm2 = xmm2[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNISSE-NEXT:    pand %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [32896,32896,32896,32896,32896,32896,32896,32896]
; GFNISSE-NEXT:    psrlw %xmm1, %xmm2
; GFNISSE-NEXT:    pxor %xmm2, %xmm0
; GFNISSE-NEXT:    psubb %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_ashr_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNIAVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [32896,32896,32896,32896,32896,32896,32896,32896]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_ashr_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpbroadcastb %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_ashr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpsrad %xmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_ashr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpmovsxbw %xmm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsraw %xmm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %shift = ashr <16 x i8> %a, %splat
  ret <16 x i8> %shift
}

define <16 x i8> @constant_shl_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_shl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNISSE-NEXT:    psllw $8, %xmm1
; GFNISSE-NEXT:    pmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    por %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_shl_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_shl_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,128,64,32,16,8,4,2,1]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; GFNIAVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vzeroupper
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_shl_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_shl_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %shift = shl <16 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <16 x i8> %shift
}

define <16 x i8> @constant_lshr_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_lshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pxor %xmm2, %xmm2
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [2,4,8,16,32,64,128,256]
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [256,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm0, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_lshr_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNIAVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1 # [2,4,8,16,32,64,128,256]
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNIAVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [256,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_lshr_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [256,128,64,32,16,8,4,2,2,4,8,16,32,64,128,256]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; GFNIAVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vzeroupper
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_lshr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_lshr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsrlvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %shift = lshr <16 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <16 x i8> %shift
}

define <16 x i8> @constant_ashr_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_ashr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNISSE-NEXT:    psraw $8, %xmm1
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [2,4,8,16,32,64,128,256]
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psraw $8, %xmm0
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0 # [256,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_ashr_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1 # [2,4,8,16,32,64,128,256]
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [256,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_ashr_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovsxbw %xmm0, %ymm0
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [256,128,64,32,16,8,4,2,2,4,8,16,32,64,128,256]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; GFNIAVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vzeroupper
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_ashr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpsravd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_ashr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovsxbw %xmm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsravw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %shift = ashr <16 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <16 x i8> %shift
}

define <16 x i8> @splatconstant_shl_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_shl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_shl_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_shl_v16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNIAVX512-NEXT:    retq
  %shift = shl <16 x i8> %a, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  ret <16 x i8> %shift
}

define <16 x i8> @splatconstant_lshr_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_lshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_lshr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_lshr_v16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNIAVX512-NEXT:    retq
  %shift = lshr <16 x i8> %a, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <16 x i8> %shift
}

define <16 x i8> @splatconstant_ashr_v16i8(<16 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_ashr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_ashr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_ashr_v16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNIAVX512-NEXT:    retq
  %shift = ashr <16 x i8> %a, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  ret <16 x i8> %shift
}

;
; 256 Bit Vector Shifts
;

define <32 x i8> @var_shl_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: var_shl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm5 = [16909320,16909320]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm6
; GFNISSE-NEXT:    psllw $5, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm6 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm7
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm7
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm7, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm7
; GFNISSE-NEXT:    paddb %xmm2, %xmm7
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm7, %xmm2
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm4
; GFNISSE-NEXT:    psllw $5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    paddb %xmm1, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_shl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm3 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; GFNIAVX1-NEXT:    vpsllw $5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_shl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_shl_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_shl_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %shift = shl <32 x i8> %a, %b
  ret <32 x i8> %shift
}

define <32 x i8> @var_lshr_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: var_lshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm6
; GFNISSE-NEXT:    psllw $5, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm6 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm7
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm7
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm7, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm8
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm2
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm4
; GFNISSE-NEXT:    psllw $5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm6, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_lshr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm3 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; GFNIAVX1-NEXT:    vpsllw $5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    # xmm6 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm2, %xmm7
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm3, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_lshr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_lshr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_lshr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %shift = lshr <32 x i8> %a, %b
  ret <32 x i8> %shift
}

define <32 x i8> @var_ashr_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: var_ashr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm4
; GFNISSE-NEXT:    psllw $5, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm4[8],xmm5[9],xmm4[9],xmm5[10],xmm4[10],xmm5[11],xmm4[11],xmm5[12],xmm4[12],xmm5[13],xmm4[13],xmm5[14],xmm4[14],xmm5[15],xmm4[15]
; GFNISSE-NEXT:    movdqa %xmm5, %xmm6
; GFNISSE-NEXT:    psraw $4, %xmm6
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm6
; GFNISSE-NEXT:    psraw $2, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm6
; GFNISSE-NEXT:    psraw $1, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3],xmm2[4],xmm4[4],xmm2[5],xmm4[5],xmm2[6],xmm4[6],xmm2[7],xmm4[7]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm4
; GFNISSE-NEXT:    psraw $4, %xmm4
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm4
; GFNISSE-NEXT:    psraw $2, %xmm4
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm4
; GFNISSE-NEXT:    psraw $1, %xmm4
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm4, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm5, %xmm2
; GFNISSE-NEXT:    psllw $5, %xmm3
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm3[8],xmm0[9],xmm3[9],xmm0[10],xmm3[10],xmm0[11],xmm3[11],xmm0[12],xmm3[12],xmm0[13],xmm3[13],xmm0[14],xmm3[14],xmm0[15],xmm3[15]
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm1[8],xmm4[9],xmm1[9],xmm4[10],xmm1[10],xmm4[11],xmm1[11],xmm4[12],xmm1[12],xmm4[13],xmm1[13],xmm4[14],xmm1[14],xmm4[15],xmm1[15]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm5
; GFNISSE-NEXT:    psraw $4, %xmm5
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm5
; GFNISSE-NEXT:    psraw $2, %xmm5
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm5
; GFNISSE-NEXT:    psraw $1, %xmm5
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    psraw $4, %xmm3
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    psraw $2, %xmm3
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    psraw $1, %xmm3
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm4, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_ashr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsraw $2, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsraw $1, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm6, %xmm5, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm4, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsraw $2, %xmm4, %xmm5
; GFNIAVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsraw $1, %xmm4, %xmm5
; GFNIAVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm5, %xmm4, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm4, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsraw $2, %xmm4, %xmm5
; GFNIAVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsraw $1, %xmm4, %xmm5
; GFNIAVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm4, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsraw $2, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpaddw %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsraw $1, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpaddw %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpblendvb %xmm1, %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_ashr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsraw $4, %ymm3, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsraw $2, %ymm3, %ymm4
; GFNIAVX2-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsraw $1, %ymm3, %ymm4
; GFNIAVX2-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsraw $4, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsraw $2, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsraw $1, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_ashr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsraw $4, %ymm3, %ymm4
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpsraw $2, %ymm3, %ymm4
; GFNIAVX512VL-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpsraw $1, %ymm3, %ymm4
; GFNIAVX512VL-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsraw $4, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsraw $2, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsraw $1, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_ashr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsravw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %shift = ashr <32 x i8> %a, %b
  ret <32 x i8> %shift
}

define <32 x i8> @splatvar_shl_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_shl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psllw %xmm2, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm3, %xmm3
; GFNISSE-NEXT:    psllw %xmm2, %xmm3
; GFNISSE-NEXT:    pxor %xmm4, %xmm4
; GFNISSE-NEXT:    pshufb %xmm4, %xmm3
; GFNISSE-NEXT:    pand %xmm3, %xmm0
; GFNISSE-NEXT:    psllw %xmm2, %xmm1
; GFNISSE-NEXT:    pand %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_shl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_shl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; GFNIAVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_shl_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; GFNIAVX512VL-NEXT:    vpbroadcastb %xmm1, %ymm1
; GFNIAVX512VL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_shl_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <32 x i8> %b, <32 x i8> undef, <32 x i32> zeroinitializer
  %shift = shl <32 x i8> %a, %splat
  ret <32 x i8> %shift
}

define <32 x i8> @splatvar_lshr_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_lshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psrlw %xmm2, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm3, %xmm3
; GFNISSE-NEXT:    psrlw %xmm2, %xmm3
; GFNISSE-NEXT:    pshufb {{.*#+}} xmm3 = xmm3[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNISSE-NEXT:    pand %xmm3, %xmm0
; GFNISSE-NEXT:    psrlw %xmm2, %xmm1
; GFNISSE-NEXT:    pand %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_lshr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_lshr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_lshr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpbroadcastb %xmm1, %ymm1
; GFNIAVX512VL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_lshr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <32 x i8> %b, <32 x i8> undef, <32 x i32> zeroinitializer
  %shift = lshr <32 x i8> %a, %splat
  ret <32 x i8> %shift
}

define <32 x i8> @splatvar_ashr_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_ashr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psrlw %xmm2, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm3, %xmm3
; GFNISSE-NEXT:    psrlw %xmm2, %xmm3
; GFNISSE-NEXT:    pshufb {{.*#+}} xmm3 = xmm3[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNISSE-NEXT:    pand %xmm3, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [32896,32896,32896,32896,32896,32896,32896,32896]
; GFNISSE-NEXT:    psrlw %xmm2, %xmm4
; GFNISSE-NEXT:    pxor %xmm4, %xmm0
; GFNISSE-NEXT:    psubb %xmm4, %xmm0
; GFNISSE-NEXT:    psrlw %xmm2, %xmm1
; GFNISSE-NEXT:    pand %xmm3, %xmm1
; GFNISSE-NEXT:    pxor %xmm4, %xmm1
; GFNISSE-NEXT:    psubb %xmm4, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_ashr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [32896,32896,32896,32896,32896,32896,32896,32896]
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsubb %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpxor %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsubb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_ashr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; GFNIAVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} ymm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; GFNIAVX2-NEXT:    vpsrlw %xmm1, %ymm2, %ymm1
; GFNIAVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_ashr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %xmm3, %xmm1
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpbroadcastb %xmm1, %ymm1
; GFNIAVX512VL-NEXT:    vpternlogq $108, %ymm0, %ymm2, %ymm1
; GFNIAVX512VL-NEXT:    vpsubb %ymm2, %ymm1, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_ashr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <32 x i8> %b, <32 x i8> undef, <32 x i32> zeroinitializer
  %shift = ashr <32 x i8> %a, %splat
  ret <32 x i8> %shift
}

define <32 x i8> @constant_shl_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_shl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm2 = [1,4,16,64,128,32,8,2]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm3
; GFNISSE-NEXT:    pmaddubsw %xmm2, %xmm3
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm4, %xmm3
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNISSE-NEXT:    pmaddubsw %xmm5, %xmm0
; GFNISSE-NEXT:    psllw $8, %xmm0
; GFNISSE-NEXT:    por %xmm3, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    pmaddubsw %xmm2, %xmm3
; GFNISSE-NEXT:    pand %xmm4, %xmm3
; GFNISSE-NEXT:    pmaddubsw %xmm5, %xmm1
; GFNISSE-NEXT:    psllw $8, %xmm1
; GFNISSE-NEXT:    por %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_shl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = [1,4,16,64,128,32,8,2]
; GFNIAVX1-NEXT:    vpmaddubsw %xmm2, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX1-NEXT:    vpmaddubsw %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpor %xmm1, %xmm3, %xmm1
; GFNIAVX1-NEXT:    vpmaddubsw %xmm2, %xmm0, %xmm2
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpmaddubsw %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsllw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpor %xmm0, %xmm2, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_shl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_shl_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; GFNIAVX512VL-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX512VL-NEXT:    vpsllw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpternlogd $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_shl_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %shift = shl <32 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <32 x i8> %shift
}

define <32 x i8> @constant_lshr_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_lshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pxor %xmm4, %xmm4
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [2,4,8,16,32,64,128,256]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm6 = [256,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm6, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm0, %xmm2
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm4[8],xmm1[9],xmm4[9],xmm1[10],xmm4[10],xmm1[11],xmm4[11],xmm1[12],xmm4[12],xmm1[13],xmm4[13],xmm1[14],xmm4[14],xmm1[15],xmm4[15]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    pmullw %xmm6, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    packuswb %xmm1, %xmm3
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_lshr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; GFNIAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [2,4,8,16,32,64,128,256]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [256,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_lshr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8],ymm1[8],ymm0[9],ymm1[9],ymm0[10],ymm1[10],ymm0[11],ymm1[11],ymm0[12],ymm1[12],ymm0[13],ymm1[13],ymm0[14],ymm1[14],ymm0[15],ymm1[15],ymm0[24],ymm1[24],ymm0[25],ymm1[25],ymm0[26],ymm1[26],ymm0[27],ymm1[27],ymm0[28],ymm1[28],ymm0[29],ymm1[29],ymm0[30],ymm1[30],ymm0[31],ymm1[31]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2 # [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[4],ymm1[4],ymm0[5],ymm1[5],ymm0[6],ymm1[6],ymm0[7],ymm1[7],ymm0[16],ymm1[16],ymm0[17],ymm1[17],ymm0[18],ymm1[18],ymm0[19],ymm1[19],ymm0[20],ymm1[20],ymm0[21],ymm1[21],ymm0[22],ymm1[22],ymm0[23],ymm1[23]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_lshr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8],ymm1[8],ymm0[9],ymm1[9],ymm0[10],ymm1[10],ymm0[11],ymm1[11],ymm0[12],ymm1[12],ymm0[13],ymm1[13],ymm0[14],ymm1[14],ymm0[15],ymm1[15],ymm0[24],ymm1[24],ymm0[25],ymm1[25],ymm0[26],ymm1[26],ymm0[27],ymm1[27],ymm0[28],ymm1[28],ymm0[29],ymm1[29],ymm0[30],ymm1[30],ymm0[31],ymm1[31]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2 # [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[4],ymm1[4],ymm0[5],ymm1[5],ymm0[6],ymm1[6],ymm0[7],ymm1[7],ymm0[16],ymm1[16],ymm0[17],ymm1[17],ymm0[18],ymm1[18],ymm0[19],ymm1[19],ymm0[20],ymm1[20],ymm0[21],ymm1[21],ymm0[22],ymm1[22],ymm0[23],ymm1[23]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_lshr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsrlvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %shift = lshr <32 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <32 x i8> %shift
}

define <32 x i8> @constant_ashr_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_ashr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNISSE-NEXT:    psraw $8, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm3 = [2,4,8,16,32,64,128,256]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psraw $8, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [256,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm1[8],xmm2[9],xmm1[9],xmm2[10],xmm1[10],xmm2[11],xmm1[11],xmm2[12],xmm1[12],xmm2[13],xmm1[13],xmm2[14],xmm1[14],xmm2[15],xmm1[15]
; GFNISSE-NEXT:    psraw $8, %xmm2
; GFNISSE-NEXT:    pmullw %xmm3, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psraw $8, %xmm1
; GFNISSE-NEXT:    pmullw %xmm4, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_ashr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [2,4,8,16,32,64,128,256]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [256,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_ashr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsraw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsraw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_ashr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsraw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1 # [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsraw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_ashr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsravw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %shift = ashr <32 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <32 x i8> %shift
}

define <32 x i8> @splatconstant_shl_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_shl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovsxwq {{.*#+}} xmm2 = [258,258]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_shl_v32i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_shl_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %shift = shl <32 x i8> %a, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  ret <32 x i8> %shift
}

define <32 x i8> @splatconstant_lshr_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_lshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_lshr_v32i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_lshr_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %shift = lshr <32 x i8> %a, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <32 x i8> %shift
}

define <32 x i8> @splatconstant_ashr_v32i8(<32 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_ashr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,64,32,16,8,4,128,128,128,64,32,16,8,4]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_ashr_v32i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_ashr_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %shift = ashr <32 x i8> %a, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <32 x i8> %shift
}

;
; 512 Bit Vector Shifts
;

define <64 x i8> @var_shl_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: var_shl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    movdqa %xmm0, %xmm4
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm9 = [16909320,16909320]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm10
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm10
; GFNISSE-NEXT:    psllw $5, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm10 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm11
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm11
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm11, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm11
; GFNISSE-NEXT:    paddb %xmm4, %xmm11
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm11, %xmm4
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm8
; GFNISSE-NEXT:    psllw $5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm8
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    paddb %xmm1, %xmm8
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm5
; GFNISSE-NEXT:    psllw $5, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    paddb %xmm2, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm5
; GFNISSE-NEXT:    psllw $5, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm5
; GFNISSE-NEXT:    paddb %xmm7, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    paddb %xmm3, %xmm5
; GFNISSE-NEXT:    paddb %xmm7, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_shl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; GFNIAVX1-NEXT:    vpsllw $5, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm5 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm6, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm7
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm7, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm0, %xmm7
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm7, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm7
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm7, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm7
; GFNIAVX1-NEXT:    vpsllw $5, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm6
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpsllw $5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_shl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm5
; GFNIAVX2-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm6
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm6, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm6
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm6, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpsllw $5, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_shl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm2, %ymm4
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm5
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm6
; GFNIAVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm6, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm6
; GFNIAVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm6, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_shl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpsllw $5, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    retq
  %shift = shl <64 x i8> %a, %b
  ret <64 x i8> %shift
}

define <64 x i8> @var_lshr_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: var_lshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    movdqa %xmm0, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm9 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm10
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm10
; GFNISSE-NEXT:    psllw $5, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm10 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm11
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm11
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm11, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm11 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm12
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm12
; GFNISSE-NEXT:    paddb %xmm8, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm12, %xmm4
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm8
; GFNISSE-NEXT:    psllw $5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm8
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm8
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm5
; GFNISSE-NEXT:    psllw $5, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm5
; GFNISSE-NEXT:    psllw $5, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm5
; GFNISSE-NEXT:    paddb %xmm7, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm5
; GFNISSE-NEXT:    paddb %xmm7, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_lshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; GFNIAVX1-NEXT:    vpsllw $5, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX1-NEXT:    # xmm5 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm6, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm8, %xmm6, %xmm8
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    # xmm6 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm8, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm9, %xmm8, %xmm7
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm0, %xmm8
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm0, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm0, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm7
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm8
; GFNIAVX1-NEXT:    vpsllw $5, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm8, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm2, %xmm7
; GFNIAVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm8, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm2, %xmm7
; GFNIAVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm8, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpsllw $5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_lshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm5
; GFNIAVX2-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm6
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm6, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm7
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm7, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpsllw $5, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_lshr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm2, %ymm4
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm5
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm6
; GFNIAVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm6, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm2, %ymm7
; GFNIAVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm7, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm3, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_lshr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpsllw $5, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    retq
  %shift = lshr <64 x i8> %a, %b
  ret <64 x i8> %shift
}

define <64 x i8> @var_ashr_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: var_ashr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm8
; GFNISSE-NEXT:    psllw $5, %xmm4
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm4[8],xmm0[9],xmm4[9],xmm0[10],xmm4[10],xmm0[11],xmm4[11],xmm0[12],xmm4[12],xmm0[13],xmm4[13],xmm0[14],xmm4[14],xmm0[15],xmm4[15]
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm8[8],xmm9[9],xmm8[9],xmm9[10],xmm8[10],xmm9[11],xmm8[11],xmm9[12],xmm8[12],xmm9[13],xmm8[13],xmm9[14],xmm8[14],xmm9[15],xmm8[15]
; GFNISSE-NEXT:    movdqa %xmm9, %xmm10
; GFNISSE-NEXT:    psraw $4, %xmm10
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm10
; GFNISSE-NEXT:    psraw $2, %xmm10
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm10
; GFNISSE-NEXT:    psraw $1, %xmm10
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm9
; GFNISSE-NEXT:    psrlw $8, %xmm9
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3],xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    psraw $4, %xmm8
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    psraw $2, %xmm8
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    psraw $1, %xmm8
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm9, %xmm4
; GFNISSE-NEXT:    psllw $5, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm5[8],xmm0[9],xmm5[9],xmm0[10],xmm5[10],xmm0[11],xmm5[11],xmm0[12],xmm5[12],xmm0[13],xmm5[13],xmm0[14],xmm5[14],xmm0[15],xmm5[15]
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm1[8],xmm8[9],xmm1[9],xmm8[10],xmm1[10],xmm8[11],xmm1[11],xmm8[12],xmm1[12],xmm8[13],xmm1[13],xmm8[14],xmm1[14],xmm8[15],xmm1[15]
; GFNISSE-NEXT:    movdqa %xmm8, %xmm9
; GFNISSE-NEXT:    psraw $4, %xmm9
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm9, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm9
; GFNISSE-NEXT:    psraw $2, %xmm9
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm9, %xmm8
; GFNISSE-NEXT:    movdqa %xmm8, %xmm9
; GFNISSE-NEXT:    psraw $1, %xmm9
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm9, %xmm8
; GFNISSE-NEXT:    psrlw $8, %xmm8
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1],xmm0[2],xmm5[2],xmm0[3],xmm5[3],xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    psraw $4, %xmm5
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    psraw $2, %xmm5
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    psraw $1, %xmm5
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm8, %xmm1
; GFNISSE-NEXT:    psllw $5, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm2[8],xmm5[9],xmm2[9],xmm5[10],xmm2[10],xmm5[11],xmm2[11],xmm5[12],xmm2[12],xmm5[13],xmm2[13],xmm5[14],xmm2[14],xmm5[15],xmm2[15]
; GFNISSE-NEXT:    movdqa %xmm5, %xmm8
; GFNISSE-NEXT:    psraw $4, %xmm8
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm8
; GFNISSE-NEXT:    psraw $2, %xmm8
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm8
; GFNISSE-NEXT:    psraw $1, %xmm8
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    psraw $4, %xmm6
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    psraw $2, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    psraw $1, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm5, %xmm2
; GFNISSE-NEXT:    psllw $5, %xmm7
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm7[8],xmm0[9],xmm7[9],xmm0[10],xmm7[10],xmm0[11],xmm7[11],xmm0[12],xmm7[12],xmm0[13],xmm7[13],xmm0[14],xmm7[14],xmm0[15],xmm7[15]
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm3[8],xmm5[9],xmm3[9],xmm5[10],xmm3[10],xmm5[11],xmm3[11],xmm5[12],xmm3[12],xmm5[13],xmm3[13],xmm5[14],xmm3[14],xmm5[15],xmm3[15]
; GFNISSE-NEXT:    movdqa %xmm5, %xmm6
; GFNISSE-NEXT:    psraw $4, %xmm6
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm6
; GFNISSE-NEXT:    psraw $2, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm6
; GFNISSE-NEXT:    psraw $1, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1],xmm0[2],xmm7[2],xmm0[3],xmm7[3],xmm0[4],xmm7[4],xmm0[5],xmm7[5],xmm0[6],xmm7[6],xmm0[7],xmm7[7]
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    psraw $4, %xmm6
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    psraw $2, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    psraw $1, %xmm6
; GFNISSE-NEXT:    paddw %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    packuswb %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_ashr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; GFNIAVX1-NEXT:    vpsllw $5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm7, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm8, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpsraw $2, %xmm7, %xmm8
; GFNIAVX1-NEXT:    vpaddw %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm8, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpsraw $1, %xmm7, %xmm8
; GFNIAVX1-NEXT:    vpaddw %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm8, %xmm7, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm6[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsraw $2, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsraw $1, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm7, %xmm6, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsraw $2, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpaddw %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsraw $1, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpaddw %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm7, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm0, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsraw $2, %xmm0, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsraw $1, %xmm0, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm5[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsraw $2, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsraw $1, %xmm6, %xmm7
; GFNIAVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm7, %xmm6, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm5[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsraw $2, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsraw $1, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm6, %xmm5, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsraw $2, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsraw $1, %xmm5, %xmm6
; GFNIAVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm6, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $4, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsraw $2, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsraw $1, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_ashr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsraw $4, %ymm5, %ymm6
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm6, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpsraw $2, %ymm5, %ymm6
; GFNIAVX2-NEXT:    vpaddw %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm6, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpsraw $1, %ymm5, %ymm6
; GFNIAVX2-NEXT:    vpaddw %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm6, %ymm5, %ymm4
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsraw $4, %ymm0, %ymm5
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsraw $2, %ymm0, %ymm5
; GFNIAVX2-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsraw $1, %ymm0, %ymm5
; GFNIAVX2-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsllw $5, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsraw $4, %ymm4, %ymm5
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsraw $2, %ymm4, %ymm5
; GFNIAVX2-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsraw $1, %ymm4, %ymm5
; GFNIAVX2-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm3
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsraw $4, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsraw $2, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsraw $1, %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_ashr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm4[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsraw $4, %ymm5, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm6, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpsraw $2, %ymm5, %ymm6
; GFNIAVX512VL-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm6, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpsraw $1, %ymm5, %ymm6
; GFNIAVX512VL-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm6, %ymm5, %ymm3
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm4 = ymm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsraw $4, %ymm4, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsraw $2, %ymm4, %ymm5
; GFNIAVX512VL-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsraw $1, %ymm4, %ymm5
; GFNIAVX512VL-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm5, %ymm4, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsraw $4, %ymm4, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsraw $2, %ymm4, %ymm5
; GFNIAVX512VL-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsraw $1, %ymm4, %ymm5
; GFNIAVX512VL-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm3
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsraw $4, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsraw $2, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsraw $1, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpaddw %ymm1, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_ashr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpsraw $4, %zmm2, %zmm3
; GFNIAVX512BW-NEXT:    vpsllw $5, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm4 = zmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; GFNIAVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm2 {%k1}
; GFNIAVX512BW-NEXT:    vpsraw $2, %zmm2, %zmm3
; GFNIAVX512BW-NEXT:    vpaddw %zmm4, %zmm4, %zmm4
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; GFNIAVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm2 {%k1}
; GFNIAVX512BW-NEXT:    vpsraw $1, %zmm2, %zmm3
; GFNIAVX512BW-NEXT:    vpaddw %zmm4, %zmm4, %zmm4
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; GFNIAVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm2 {%k1}
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsraw $4, %zmm0, %zmm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    vpsraw $2, %zmm0, %zmm3
; GFNIAVX512BW-NEXT:    vpaddw %zmm1, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    vpsraw $1, %zmm0, %zmm3
; GFNIAVX512BW-NEXT:    vpaddw %zmm1, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; GFNIAVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %shift = ashr <64 x i8> %a, %b
  ret <64 x i8> %shift
}

define <64 x i8> @splatvar_shl_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_shl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psllw %xmm4, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm5, %xmm5
; GFNISSE-NEXT:    psllw %xmm4, %xmm5
; GFNISSE-NEXT:    pxor %xmm6, %xmm6
; GFNISSE-NEXT:    pshufb %xmm6, %xmm5
; GFNISSE-NEXT:    pand %xmm5, %xmm0
; GFNISSE-NEXT:    psllw %xmm4, %xmm1
; GFNISSE-NEXT:    pand %xmm5, %xmm1
; GFNISSE-NEXT:    psllw %xmm4, %xmm2
; GFNISSE-NEXT:    pand %xmm5, %xmm2
; GFNISSE-NEXT:    psllw %xmm4, %xmm3
; GFNISSE-NEXT:    pand %xmm5, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_shl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_shl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpbroadcastb %xmm3, %ymm3
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_shl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; GFNIAVX512VL-NEXT:    vpbroadcastb %xmm1, %ymm1
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_shl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpsllw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpsllw %xmm1, %xmm2, %xmm1
; GFNIAVX512BW-NEXT:    vpbroadcastb %xmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %b, <64 x i8> undef, <64 x i32> zeroinitializer
  %shift = shl <64 x i8> %a, %splat
  ret <64 x i8> %shift
}

define <64 x i8> @splatvar_lshr_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_lshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psrlw %xmm4, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm5, %xmm5
; GFNISSE-NEXT:    psrlw %xmm4, %xmm5
; GFNISSE-NEXT:    pshufb {{.*#+}} xmm5 = xmm5[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNISSE-NEXT:    pand %xmm5, %xmm0
; GFNISSE-NEXT:    psrlw %xmm4, %xmm1
; GFNISSE-NEXT:    pand %xmm5, %xmm1
; GFNISSE-NEXT:    psrlw %xmm4, %xmm2
; GFNISSE-NEXT:    pand %xmm5, %xmm2
; GFNISSE-NEXT:    psrlw %xmm4, %xmm3
; GFNISSE-NEXT:    pand %xmm5, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_lshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_lshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpbroadcastb %xmm3, %ymm3
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_lshr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpbroadcastb %xmm1, %ymm1
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_lshr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %xmm2, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpbroadcastb %xmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %b, <64 x i8> undef, <64 x i32> zeroinitializer
  %shift = lshr <64 x i8> %a, %splat
  ret <64 x i8> %shift
}

define <64 x i8> @splatvar_ashr_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: splatvar_ashr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; GFNISSE-NEXT:    psrlw %xmm4, %xmm0
; GFNISSE-NEXT:    pcmpeqd %xmm5, %xmm5
; GFNISSE-NEXT:    psrlw %xmm4, %xmm5
; GFNISSE-NEXT:    pshufb {{.*#+}} xmm5 = xmm5[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNISSE-NEXT:    pand %xmm5, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm6 = [32896,32896,32896,32896,32896,32896,32896,32896]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm6
; GFNISSE-NEXT:    pxor %xmm6, %xmm0
; GFNISSE-NEXT:    psubb %xmm6, %xmm0
; GFNISSE-NEXT:    psrlw %xmm4, %xmm1
; GFNISSE-NEXT:    pand %xmm5, %xmm1
; GFNISSE-NEXT:    pxor %xmm6, %xmm1
; GFNISSE-NEXT:    psubb %xmm6, %xmm1
; GFNISSE-NEXT:    psrlw %xmm4, %xmm2
; GFNISSE-NEXT:    pand %xmm5, %xmm2
; GFNISSE-NEXT:    pxor %xmm6, %xmm2
; GFNISSE-NEXT:    psubb %xmm6, %xmm2
; GFNISSE-NEXT:    psrlw %xmm4, %xmm3
; GFNISSE-NEXT:    pand %xmm5, %xmm3
; GFNISSE-NEXT:    pxor %xmm6, %xmm3
; GFNISSE-NEXT:    psubb %xmm6, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_ashr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [32896,32896,32896,32896,32896,32896,32896,32896]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsubb %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpxor %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsubb %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsubb %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsubb %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_ashr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpbroadcastb %xmm3, %ymm3
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} ymm4 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsubb %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsubb %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_ashr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896,32896]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %xmm4, %xmm4
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX512VL-NEXT:    vpbroadcastb %xmm4, %ymm4
; GFNIAVX512VL-NEXT:    vpternlogq $108, %ymm4, %ymm3, %ymm2
; GFNIAVX512VL-NEXT:    vpsubb %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpternlogq $108, %ymm4, %ymm3, %ymm0
; GFNIAVX512VL-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_ashr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpbroadcastb {{.*#+}} zmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %xmm3, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpbroadcastb %xmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpternlogq $108, %zmm0, %zmm2, %zmm1
; GFNIAVX512BW-NEXT:    vpsubb %zmm2, %zmm1, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %b, <64 x i8> undef, <64 x i32> zeroinitializer
  %shift = ashr <64 x i8> %a, %splat
  ret <64 x i8> %shift
}

define <64 x i8> @constant_shl_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_shl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [1,4,16,64,128,32,8,2]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    pmaddubsw %xmm4, %xmm6
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNISSE-NEXT:    pmaddubsw %xmm7, %xmm0
; GFNISSE-NEXT:    psllw $8, %xmm0
; GFNISSE-NEXT:    por %xmm6, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    pmaddubsw %xmm4, %xmm6
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    pmaddubsw %xmm7, %xmm1
; GFNISSE-NEXT:    psllw $8, %xmm1
; GFNISSE-NEXT:    por %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    pmaddubsw %xmm4, %xmm6
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    pmaddubsw %xmm7, %xmm2
; GFNISSE-NEXT:    psllw $8, %xmm2
; GFNISSE-NEXT:    por %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    pmaddubsw %xmm4, %xmm6
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    pmaddubsw %xmm7, %xmm3
; GFNISSE-NEXT:    psllw $8, %xmm3
; GFNISSE-NEXT:    por %xmm6, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_shl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm3 = [1,4,16,64,128,32,8,2]
; GFNIAVX1-NEXT:    vpmaddubsw %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX1-NEXT:    vpmaddubsw %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpor %xmm2, %xmm4, %xmm2
; GFNIAVX1-NEXT:    vpmaddubsw %xmm3, %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmaddubsw %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsllw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpor %xmm0, %xmm4, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vpmaddubsw %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmaddubsw %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpor %xmm2, %xmm4, %xmm2
; GFNIAVX1-NEXT:    vpmaddubsw %xmm3, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpmaddubsw %xmm6, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpor %xmm1, %xmm3, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_shl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; GFNIAVX2-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmaddubsw %ymm2, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmaddubsw %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsllw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm0, %ymm3, %ymm0
; GFNIAVX2-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpmaddubsw %ymm5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_shl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; GFNIAVX512VL-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm3
; GFNIAVX512VL-NEXT:    vpmaddubsw %ymm2, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX512VL-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmaddubsw %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsllw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpmaddubsw %ymm3, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpsllw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpternlogd $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm2, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_shl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm1 # [1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0,1,0,4,0,16,0,64,0,128,0,32,0,8,0,2,0]
; GFNIAVX512BW-NEXT:    vpmaddubsw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0 # [0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1,0,2,0,8,0,32,0,128,0,64,0,16,0,4,0,1]
; GFNIAVX512BW-NEXT:    vpsllw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpternlogd $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm1, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %shift = shl <64 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <64 x i8> %shift
}

define <64 x i8> @constant_lshr_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_lshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    pxor %xmm6, %xmm6
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [2,4,8,16,32,64,128,256]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [256,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm8, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm1, %xmm0
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm1 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm6[8],xmm4[9],xmm6[9],xmm4[10],xmm6[10],xmm4[11],xmm6[11],xmm4[12],xmm6[12],xmm4[13],xmm6[13],xmm4[14],xmm6[14],xmm4[15],xmm6[15]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    pmullw %xmm8, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm4, %xmm1
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    pmullw %xmm8, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm2, %xmm4
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm5 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm6[8],xmm3[9],xmm6[9],xmm3[10],xmm6[10],xmm3[11],xmm6[11],xmm3[12],xmm6[12],xmm3[13],xmm6[13],xmm3[14],xmm6[14],xmm3[15],xmm6[15]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    pmullw %xmm8, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    packuswb %xmm3, %xmm5
; GFNISSE-NEXT:    movdqa %xmm4, %xmm2
; GFNISSE-NEXT:    movdqa %xmm5, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_lshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [2,4,8,16,32,64,128,256]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [256,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm0[8],xmm3[8],xmm0[9],xmm3[9],xmm0[10],xmm3[10],xmm0[11],xmm3[11],xmm0[12],xmm3[12],xmm0[13],xmm3[13],xmm0[14],xmm3[14],xmm0[15],xmm3[15]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNIAVX1-NEXT:    vpmullw %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; GFNIAVX1-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm3[8],xmm1[9],xmm3[9],xmm1[10],xmm3[10],xmm1[11],xmm3[11],xmm1[12],xmm3[12],xmm1[13],xmm3[13],xmm1[14],xmm3[14],xmm1[15],xmm3[15]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; GFNIAVX1-NEXT:    vpmullw %xmm6, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_lshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8],ymm2[8],ymm0[9],ymm2[9],ymm0[10],ymm2[10],ymm0[11],ymm2[11],ymm0[12],ymm2[12],ymm0[13],ymm2[13],ymm0[14],ymm2[14],ymm0[15],ymm2[15],ymm0[24],ymm2[24],ymm0[25],ymm2[25],ymm0[26],ymm2[26],ymm0[27],ymm2[27],ymm0[28],ymm2[28],ymm0[29],ymm2[29],ymm0[30],ymm2[30],ymm0[31],ymm2[31]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX2-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[4],ymm2[4],ymm0[5],ymm2[5],ymm0[6],ymm2[6],ymm0[7],ymm2[7],ymm0[16],ymm2[16],ymm0[17],ymm2[17],ymm0[18],ymm2[18],ymm0[19],ymm2[19],ymm0[20],ymm2[20],ymm0[21],ymm2[21],ymm0[22],ymm2[22],ymm0[23],ymm2[23]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15],ymm1[24],ymm2[24],ymm1[25],ymm2[25],ymm1[26],ymm2[26],ymm1[27],ymm2[27],ymm1[28],ymm2[28],ymm1[29],ymm2[29],ymm1[30],ymm2[30],ymm1[31],ymm2[31]
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[16],ymm2[16],ymm1[17],ymm2[17],ymm1[18],ymm2[18],ymm1[19],ymm2[19],ymm1[20],ymm2[20],ymm1[21],ymm2[21],ymm1[22],ymm2[22],ymm1[23],ymm2[23]
; GFNIAVX2-NEXT:    vpmullw %ymm5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_lshr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; GFNIAVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15],ymm1[24],ymm2[24],ymm1[25],ymm2[25],ymm1[26],ymm2[26],ymm1[27],ymm2[27],ymm1[28],ymm2[28],ymm1[29],ymm2[29],ymm1[30],ymm2[30],ymm1[31],ymm2[31]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX512VL-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[16],ymm2[16],ymm1[17],ymm2[17],ymm1[18],ymm2[18],ymm1[19],ymm2[19],ymm1[20],ymm2[20],ymm1[21],ymm2[21],ymm1[22],ymm2[22],ymm1[23],ymm2[23]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8],ymm2[8],ymm0[9],ymm2[9],ymm0[10],ymm2[10],ymm0[11],ymm2[11],ymm0[12],ymm2[12],ymm0[13],ymm2[13],ymm0[14],ymm2[14],ymm0[15],ymm2[15],ymm0[24],ymm2[24],ymm0[25],ymm2[25],ymm0[26],ymm2[26],ymm0[27],ymm2[27],ymm0[28],ymm2[28],ymm0[29],ymm2[29],ymm0[30],ymm2[30],ymm0[31],ymm2[31]
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[4],ymm2[4],ymm0[5],ymm2[5],ymm0[6],ymm2[6],ymm0[7],ymm2[7],ymm0[16],ymm2[16],ymm0[17],ymm2[17],ymm0[18],ymm2[18],ymm0[19],ymm2[19],ymm0[20],ymm2[20],ymm0[21],ymm2[21],ymm0[22],ymm2[22],ymm0[23],ymm2[23]
; GFNIAVX512VL-NEXT:    vpmullw %ymm5, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_lshr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %shift = lshr <64 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <64 x i8> %shift
}

define <64 x i8> @constant_ashr_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: constant_ashr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; GFNISSE-NEXT:    psraw $8, %xmm6
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [2,4,8,16,32,64,128,256]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psraw $8, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [256,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm6, %xmm0
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm1[8],xmm6[9],xmm1[9],xmm6[10],xmm1[10],xmm6[11],xmm1[11],xmm6[12],xmm1[12],xmm6[13],xmm1[13],xmm6[14],xmm1[14],xmm6[15],xmm1[15]
; GFNISSE-NEXT:    psraw $8, %xmm6
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psraw $8, %xmm1
; GFNISSE-NEXT:    pmullw %xmm5, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm2[8],xmm6[9],xmm2[9],xmm6[10],xmm2[10],xmm6[11],xmm2[11],xmm6[12],xmm2[12],xmm6[13],xmm2[13],xmm6[14],xmm2[14],xmm6[15],xmm2[15]
; GFNISSE-NEXT:    psraw $8, %xmm6
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psraw $8, %xmm2
; GFNISSE-NEXT:    pmullw %xmm5, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm3[8],xmm6[9],xmm3[9],xmm6[10],xmm3[10],xmm6[11],xmm3[11],xmm6[12],xmm3[12],xmm6[13],xmm3[13],xmm6[14],xmm3[14],xmm6[15],xmm3[15]
; GFNISSE-NEXT:    psraw $8, %xmm6
; GFNISSE-NEXT:    pmullw %xmm4, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    psraw $8, %xmm3
; GFNISSE-NEXT:    pmullw %xmm5, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    packuswb %xmm6, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_ashr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm3[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [2,4,8,16,32,64,128,256]
; GFNIAVX1-NEXT:    vpmullw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm3, %xmm5
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [256,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpmullw %xmm2, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpmullw %xmm2, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpmullw %xmm2, %xmm5, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpsraw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_ashr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsraw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsraw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX2-NEXT:    vpsraw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX2-NEXT:    vpsraw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpmullw %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_ashr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsraw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; GFNIAVX512VL-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsraw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    # ymm4 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; GFNIAVX512VL-NEXT:    vpsraw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; GFNIAVX512VL-NEXT:    vpsraw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpmullw %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_ashr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm1 = zmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; GFNIAVX512BW-NEXT:    vpsraw $8, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; GFNIAVX512BW-NEXT:    vpsraw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %shift = ashr <64 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <64 x i8> %shift
}

define <64 x i8> @splatconstant_shl_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_shl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm4 = [66052,66052]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_shl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [4,2,1,0,0,0,0,0,4,2,1,0,0,0,0,0,4,2,1,0,0,0,0,0,4,2,1,0,0,0,0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_shl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4,2,1,0,0,0,0,0,4,2,1,0,0,0,0,0,4,2,1,0,0,0,0,0,4,2,1,0,0,0,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_shl_v64i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512-NEXT:    retq
  %shift = shl <64 x i8> %a, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  ret <64 x i8> %shift
}

define <64 x i8> @splatconstant_lshr_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_lshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_lshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_lshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_lshr_v64i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512-NEXT:    retq
  %shift = lshr <64 x i8> %a, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <64 x i8> %shift
}

define <64 x i8> @splatconstant_ashr_v64i8(<64 x i8> %a) nounwind {
; GFNISSE-LABEL: splatconstant_ashr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [128,128,64,32,16,8,4,2,128,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_ashr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [128,128,64,32,16,8,4,2,128,128,64,32,16,8,4,2,128,128,64,32,16,8,4,2,128,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_ashr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [128,128,64,32,16,8,4,2,128,128,64,32,16,8,4,2,128,128,64,32,16,8,4,2,128,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_ashr_v64i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512-NEXT:    retq
  %shift = ashr <64 x i8> %a, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <64 x i8> %shift
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFNIAVX: {{.*}}
