; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; shift left

define i32 @and_signbit_shl(i32 %x) {
; CHECK-LABEL: @and_signbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = and i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}
define i32 @and_nosignbit_shl(i32 %x) {
; CHECK-LABEL: @and_nosignbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = and i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}

define i32 @or_signbit_shl(i32 %x) {
; CHECK-LABEL: @or_signbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}
define i32 @or_nosignbit_shl(i32 %x) {
; CHECK-LABEL: @or_nosignbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}

define i32 @xor_signbit_shl(i32 %x) {
; CHECK-LABEL: @xor_signbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}
define i32 @xor_nosignbit_shl(i32 %x) {
; CHECK-LABEL: @xor_nosignbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}

define i32 @add_signbit_shl(i32 %x) {
; CHECK-LABEL: @add_signbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = add i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}
define i32 @add_nosignbit_shl(i32 %x) {
; CHECK-LABEL: @add_nosignbit_shl(
; CHECK-NEXT:    [[T0:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = add i32 [[T0]], -16777216
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  ret i32 %r
}

; logical shift right

define i32 @and_signbit_lshr(i32 %x) {
; CHECK-LABEL: @and_signbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = and i32 [[T0]], 16776960
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}
define i32 @and_nosignbit_lshr(i32 %x) {
; CHECK-LABEL: @and_nosignbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = and i32 [[T0]], 8388352
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}

define i32 @or_signbit_lshr(i32 %x) {
; CHECK-LABEL: @or_signbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[T0]], 16776960
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}
define i32 @or_nosignbit_lshr(i32 %x) {
; CHECK-LABEL: @or_nosignbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[T0]], 8388352
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}

define i32 @xor_signbit_lshr(i32 %x) {
; CHECK-LABEL: @xor_signbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[T0]], 16776960
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}
define i32 @xor_nosignbit_lshr(i32 %x) {
; CHECK-LABEL: @xor_nosignbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[T0]], 8388352
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}

define i32 @add_signbit_lshr(i32 %x) {
; CHECK-LABEL: @add_signbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], -65536
; CHECK-NEXT:    [[R:%.*]] = lshr i32 [[T0]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}
define i32 @add_nosignbit_lshr(i32 %x) {
; CHECK-LABEL: @add_nosignbit_lshr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], 2147418112
; CHECK-NEXT:    [[R:%.*]] = lshr i32 [[T0]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  ret i32 %r
}

; arithmetic shift right

define i32 @and_signbit_ashr(i32 %x) {
; CHECK-LABEL: @and_signbit_ashr(
; CHECK-NEXT:    [[T0:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = and i32 [[T0]], -256
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}
define i32 @and_nosignbit_ashr(i32 %x) {
; CHECK-LABEL: @and_nosignbit_ashr(
; CHECK-NEXT:    [[T0:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = and i32 [[T0]], 8388352
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}

define i32 @or_signbit_ashr(i32 %x) {
; CHECK-LABEL: @or_signbit_ashr(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[TMP1]], -256
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}
define i32 @or_nosignbit_ashr(i32 %x) {
; CHECK-LABEL: @or_nosignbit_ashr(
; CHECK-NEXT:    [[T0:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[T0]], 8388352
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}

define i32 @xor_signbit_ashr(i32 %x) {
; CHECK-LABEL: @xor_signbit_ashr(
; CHECK-NEXT:    [[T0:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[T0]], -256
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}
define i32 @xor_nosignbit_ashr(i32 %x) {
; CHECK-LABEL: @xor_nosignbit_ashr(
; CHECK-NEXT:    [[T0:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[T0]], 8388352
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}

define i32 @add_signbit_ashr(i32 %x) {
; CHECK-LABEL: @add_signbit_ashr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], -65536
; CHECK-NEXT:    [[R:%.*]] = ashr i32 [[T0]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}
define i32 @add_nosignbit_ashr(i32 %x) {
; CHECK-LABEL: @add_nosignbit_ashr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], 2147418112
; CHECK-NEXT:    [[R:%.*]] = ashr i32 [[T0]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  ret i32 %r
}
