; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; shift left

define i32 @and_signbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @and_signbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}
define i32 @and_nosignbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @and_nosignbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}

define i32 @or_signbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @or_signbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}
define i32 @or_nosignbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @or_nosignbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}

define i32 @xor_signbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @xor_signbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}
define i32 @xor_nosignbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @xor_nosignbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}

define i32 @add_signbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @add_signbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = add i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}
define i32 @add_nosignbit_select_shl(i32 %x, i1 %cond) {
; CHECK-LABEL: @add_nosignbit_select_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = add i32 [[TMP1]], -16777216
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  ret i32 %r
}

; logical shift right

define i32 @and_signbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @and_signbit_select_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 16776960
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}
define i32 @and_nosignbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @and_nosignbit_select_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 8388352
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}

define i32 @or_signbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @or_signbit_select_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP1]], 16776960
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}
define i32 @or_nosignbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @or_nosignbit_select_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP1]], 8388352
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}

define i32 @xor_signbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @xor_signbit_select_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], 16776960
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}
define i32 @xor_nosignbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @xor_nosignbit_select_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], 8388352
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}

define i32 @add_signbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @add_signbit_select_lshr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], -65536
; CHECK-NEXT:    [[T1:%.*]] = select i1 [[COND:%.*]], i32 [[T0]], i32 [[X]]
; CHECK-NEXT:    [[R:%.*]] = lshr i32 [[T1]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}
define i32 @add_nosignbit_select_lshr(i32 %x, i1 %cond) {
; CHECK-LABEL: @add_nosignbit_select_lshr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], 2147418112
; CHECK-NEXT:    [[T1:%.*]] = select i1 [[COND:%.*]], i32 [[T0]], i32 [[X]]
; CHECK-NEXT:    [[R:%.*]] = lshr i32 [[T1]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  ret i32 %r
}

; arithmetic shift right

define i32 @and_signbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @and_signbit_select_ashr(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], -256
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}
define i32 @and_nosignbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @and_nosignbit_select_ashr(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 8388352
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}

define i32 @or_signbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @or_signbit_select_ashr(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP1]], -256
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}
define i32 @or_nosignbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @or_nosignbit_select_ashr(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP1]], 8388352
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}

define i32 @xor_signbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @xor_signbit_select_ashr(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], -256
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}
define i32 @xor_nosignbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @xor_nosignbit_select_ashr(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], 8388352
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i32 [[TMP2]], i32 [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}

define i32 @add_signbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @add_signbit_select_ashr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], -65536
; CHECK-NEXT:    [[T1:%.*]] = select i1 [[COND:%.*]], i32 [[T0]], i32 [[X]]
; CHECK-NEXT:    [[R:%.*]] = ashr i32 [[T1]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}
define i32 @add_nosignbit_select_ashr(i32 %x, i1 %cond) {
; CHECK-LABEL: @add_nosignbit_select_ashr(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[X:%.*]], 2147418112
; CHECK-NEXT:    [[T1:%.*]] = select i1 [[COND:%.*]], i32 [[T0]], i32 [[X]]
; CHECK-NEXT:    [[R:%.*]] = ashr i32 [[T1]], 8
; CHECK-NEXT:    ret i32 [[R]]
;
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  ret i32 %r
}
