; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc -stop-after=prologepilog -simplify-mir -o - %s | FileCheck %s
target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"
target triple = "arm64e-apple-ios18.0"

declare void @spam()
; This test checks that the live-in flags for LR are correctly set when LR is reserved, but live for a call.
define i32 @check_lr_liveness(ptr %arg) #1 {
  ; CHECK-LABEL: name: check_lr_liveness
  ; CHECK: bb.0.bb:
  ; CHECK-NEXT:   successors: %bb.4(0x20000000), %bb.1(0x60000000)
  ; CHECK-NEXT:   liveins: $x0, $lr
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   renamable $x8 = COPY $x0
  ; CHECK-NEXT:   renamable $w0 = MOVi32imm -536870206
  ; CHECK-NEXT:   CBNZX killed renamable $x8, %bb.1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4:
  ; CHECK-NEXT:   liveins: $w0, $lr
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   B %bb.3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.1.bb:
  ; CHECK-NEXT:   successors: %bb.3(0x2aaaaaab), %bb.2(0x55555555)
  ; CHECK-NEXT:   liveins: $w0, $lr
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   CBNZW $wzr, %bb.3
  ; CHECK-NEXT:   B %bb.2
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.bb1:
  ; CHECK-NEXT:   liveins: $lr
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   early-clobber $sp = frame-setup STPXpre killed $fp, killed $lr, $sp, -2 :: (store (s64) into %stack.1), (store (s64) into %stack.0)
  ; CHECK-NEXT:   BL @spam, csr_darwin_aarch64_aapcs, implicit-def dead $lr, implicit $sp, implicit-def $sp
  ; CHECK-NEXT:   renamable $w0 = COPY $wzr
  ; CHECK-NEXT:   early-clobber $sp, $fp, $lr = frame-destroy LDPXpost $sp, 2 :: (load (s64) from %stack.1), (load (s64) from %stack.0)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.bb2:
  ; CHECK-NEXT:   liveins: $w0, $lr
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
bb:
  %icmp = icmp eq ptr %arg, null
  %or = or i1 %icmp, false
  br i1 %or, label %bb2, label %bb1

bb1:                                              ; preds = %bb
  call void @spam()
  br label %bb2

bb2:                                              ; preds = %bb1, %bb
  %phi = phi i32 [ -536870206, %bb ], [ 0, %bb1 ]
  ret i32 %phi
}

attributes #1 = { minsize nounwind "target-features"="+aes,+crc,+fp-armv8,+fullfp16,+lse,+neon,+ras,+rcpc,+rdm,+reserve-lr-for-ra,+sha2,+v8.1a,+v8.2a,+v8.3a,+v8a" }

