; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-tile -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -O0 -mtriple=x86_64-unknown-unknown -mattr=+amx-tile -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -O0 -mtriple=x86_64-unknown-unknown -mattr=+amx-tile,+egpr -verify-machineinstrs --show-mc-encoding | FileCheck %s --check-prefix=EGPR

define void @test_amx(ptr %pointer, ptr %base, i64 %stride) {
; CHECK-LABEL: test_amx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ldtilecfg (%rdi)
; CHECK-NEXT:    sttilecfg (%rdi)
; CHECK-NEXT:    tilerelease
; CHECK-NEXT:    tilezero %tmm3
; CHECK-NEXT:    tileloadd (%rsi,%rdx), %tmm3
; CHECK-NEXT:    tileloaddt1 (%rsi,%rdx), %tmm3
; CHECK-NEXT:    tilestored %tmm3, (%rsi,%rdx)
; CHECK-NEXT:    retq
;
; EGPR-LABEL: test_amx:
; EGPR:       # %bb.0:
; EGPR-NEXT:    ldtilecfg (%rdi) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x07]
; EGPR-NEXT:    sttilecfg (%rdi) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x79,0x49,0x07]
; EGPR-NEXT:    tilerelease # encoding: [0xc4,0xe2,0x78,0x49,0xc0]
; EGPR-NEXT:    tilezero %tmm3 # encoding: [0xc4,0xe2,0x7b,0x49,0xd8]
; EGPR-NEXT:    tileloadd (%rsi,%rdx), %tmm3 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7b,0x4b,0x1c,0x16]
; EGPR-NEXT:    tileloaddt1 (%rsi,%rdx), %tmm3 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x79,0x4b,0x1c,0x16]
; EGPR-NEXT:    tilestored %tmm3, (%rsi,%rdx) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0x1c,0x16]
; EGPR-NEXT:    retq # encoding: [0xc3]
  call void @llvm.x86.ldtilecfg(ptr %pointer)

  call void @llvm.x86.sttilecfg(ptr %pointer)

  call void @llvm.x86.tilerelease()

  call void @llvm.x86.tilezero(i8 3)

  call void @llvm.x86.tileloadd64(i8 3, ptr %base, i64 %stride)

  call void @llvm.x86.tileloaddt164(i8 3, ptr %base, i64 %stride)

  call void @llvm.x86.tilestored64(i8 3, ptr %base, i64 %stride)
  ret void
}

declare void @llvm.x86.tileloadd64(i8 %tile, ptr %base, i64 %stride)
declare void @llvm.x86.tileloaddt164(i8 %tile, ptr %base, i64 %stride)
declare void @llvm.x86.tilestored64(i8 %tile, ptr %base, i64 %stride)
declare void @llvm.x86.ldtilecfg(ptr %pointer)
declare void @llvm.x86.sttilecfg(ptr %pointer)
declare void @llvm.x86.tilerelease()
declare void @llvm.x86.tilezero(i8 %tile)
