; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=msan -S | FileCheck %s
;
; Suboptimally handled by visitInstruction: llvm.aarch64.neon.
; - vcvtfp2fxs, vcvtfp2fxu
; - vcvtfxs2fp, vcvtfxu2fp
;
; Forked from llvm/test/CodeGen/AArch64/arm64-vcvt.ll

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64--linux-android9001"

define <2 x i32> @fcvtas_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtas_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtas.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtas.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtas_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtas_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtas.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtas.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtas_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtas_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtas.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtas.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtas_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtas_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtas.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtas.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtas.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtas.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtas.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtas.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtau_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtau_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtau.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtau.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtau_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtau_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtau.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtau.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtau_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtau_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtau.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtau.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtau_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtau_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtau.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtau.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtau.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtau.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtau.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtau.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtms_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtms_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtms.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtms.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtms_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtms_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtms.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtms.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtms_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtms_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtms.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtms.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtms_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtms_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtms.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtms.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtms.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtms.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtms.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtms.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtmu_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtmu_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtmu.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtmu.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtmu_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtmu_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtmu.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtmu.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtmu_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtmu_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtmu.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtmu.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtmu_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtmu_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtmu.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtmu.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtmu.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtmu.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtmu.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtmu.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtps_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtps_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtps.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtps.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtps_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtps_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtps.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtps.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtps_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtps_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtps.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtps.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtps_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtps_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtps.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtps.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtps.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtps.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtps.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtps.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtpu_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtpu_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtpu.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtpu.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtpu_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtpu_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtpu.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtpu.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtpu_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtpu_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtpu.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtpu.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtpu_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtpu_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtpu.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtpu.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtpu.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtpu.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtpu.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtpu.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtns_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtns_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtns.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtns.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtns_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtns_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtns.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtns.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtns_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtns_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtns.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtns.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtns_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtns_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtns.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtns.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtns.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtns.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtns.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtns.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtnu_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtnu_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtnu.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtnu.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtnu_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtnu_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtnu.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtnu.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtnu_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtnu_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtnu.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtnu.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtnu_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtnu_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtnu.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtnu.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtnu.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtnu.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtnu.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtnu.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtzs_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtzs_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptosi <2 x float> [[A]] to <2 x i32>
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = fptosi <2 x float> %A to <2 x i32>
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtzs_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtzs_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptosi <4 x float> [[A]] to <4 x i32>
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = fptosi <4 x float> %A to <4 x i32>
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtzs_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtzs_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptosi <2 x double> [[A]] to <2 x i64>
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = fptosi <2 x double> %A to <2 x i64>
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtzs_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtzs_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptosi <1 x double> [[A]] to <1 x i64>
; CHECK-NEXT:    store <1 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = fptosi <1 x double> %A to <1 x i64>
  ret <1 x i64> %tmpvar3
}

define <2 x i32> @fcvtzs_2s_intrinsic(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtzs_2s_intrinsic(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtzs.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtzs.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtzs_4s_intrinsic(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtzs_4s_intrinsic(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtzs.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtzs.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtzs_2d_intrinsic(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtzs_2d_intrinsic(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtzs.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtzs.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtzs_1d_intrinsic(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtzs_1d_intrinsic(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtzs.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtzs.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtzs.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtzs.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtzs.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtzs.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x i32> @fcvtzu_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtzu_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptoui <2 x float> [[A]] to <2 x i32>
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = fptoui <2 x float> %A to <2 x i32>
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtzu_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtzu_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptoui <4 x float> [[A]] to <4 x i32>
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = fptoui <4 x float> %A to <4 x i32>
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtzu_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtzu_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptoui <2 x double> [[A]] to <2 x i64>
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = fptoui <2 x double> %A to <2 x i64>
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtzu_1d(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtzu_1d(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = fptoui <1 x double> [[A]] to <1 x i64>
; CHECK-NEXT:    store <1 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = fptoui <1 x double> %A to <1 x i64>
  ret <1 x i64> %tmpvar3
}

define <2 x i32> @fcvtzu_2s_intrinsic(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtzu_2s_intrinsic(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.fcvtzu.v2i32.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.fcvtzu.v2i32.v2f32(<2 x float> %A)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtzu_4s_intrinsic(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtzu_4s_intrinsic(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <4 x i32> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <4 x i1> [[TMP2]] to <4 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.fcvtzu.v4i32.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.fcvtzu.v4i32.v4f32(<4 x float> %A)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtzu_2d_intrinsic(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtzu_2d_intrinsic(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.fcvtzu.v2i64.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.fcvtzu.v2i64.v2f64(<2 x double> %A)
  ret <2 x i64> %tmpvar3
}

define <1 x i64> @fcvtzu_1d_intrinsic(<1 x double> %A) nounwind #0 {
; CHECK-LABEL: define <1 x i64> @fcvtzu_1d_intrinsic(
; CHECK-SAME: <1 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <1 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <1 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <1 x i1> [[TMP2]] to <1 x i64>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <1 x i64> @llvm.aarch64.neon.fcvtzu.v1i64.v1f64(<1 x double> [[A]])
; CHECK-NEXT:    store <1 x i64> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <1 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <1 x i64> @llvm.aarch64.neon.fcvtzu.v1i64.v1f64(<1 x double> %A)
  ret <1 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.fcvtzu.v2i32.v2f32(<2 x float>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.fcvtzu.v4i32.v4f32(<4 x float>) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.fcvtzu.v2i64.v2f64(<2 x double>) nounwind readnone
declare <1 x i64> @llvm.aarch64.neon.fcvtzu.v1i64.v1f64(<1 x double>) nounwind readnone

define <2 x float> @frinta_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @frinta_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.round.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.round.v2f32(<2 x float> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @frinta_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @frinta_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.round.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.round.v4f32(<4 x float> %A)
  ret <4 x float> %tmpvar3
}

define <2 x double> @frinta_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @frinta_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.round.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.round.v2f64(<2 x double> %A)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.round.v2f32(<2 x float>) nounwind readnone
declare <4 x float> @llvm.round.v4f32(<4 x float>) nounwind readnone
declare <2 x double> @llvm.round.v2f64(<2 x double>) nounwind readnone

define <2 x float> @frinti_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @frinti_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.nearbyint.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.nearbyint.v2f32(<2 x float> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @frinti_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @frinti_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> %A)
  ret <4 x float> %tmpvar3
}

define <2 x double> @frinti_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @frinti_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.nearbyint.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.nearbyint.v2f64(<2 x double> %A)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.nearbyint.v2f32(<2 x float>) nounwind readnone
declare <4 x float> @llvm.nearbyint.v4f32(<4 x float>) nounwind readnone
declare <2 x double> @llvm.nearbyint.v2f64(<2 x double>) nounwind readnone

define <2 x float> @frintm_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @frintm_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.floor.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.floor.v2f32(<2 x float> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @frintm_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @frintm_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.floor.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.floor.v4f32(<4 x float> %A)
  ret <4 x float> %tmpvar3
}

define <2 x double> @frintm_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @frintm_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.floor.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.floor.v2f64(<2 x double> %A)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.floor.v2f32(<2 x float>) nounwind readnone
declare <4 x float> @llvm.floor.v4f32(<4 x float>) nounwind readnone
declare <2 x double> @llvm.floor.v2f64(<2 x double>) nounwind readnone

define <2 x float> @frintn_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @frintn_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.roundeven.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.roundeven.v2f32(<2 x float> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @frintn_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @frintn_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.roundeven.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.roundeven.v4f32(<4 x float> %A)
  ret <4 x float> %tmpvar3
}

define <2 x double> @frintn_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @frintn_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.roundeven.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.roundeven.v2f64(<2 x double> %A)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.roundeven.v2f32(<2 x float>) nounwind readnone
declare <4 x float> @llvm.roundeven.v4f32(<4 x float>) nounwind readnone
declare <2 x double> @llvm.roundeven.v2f64(<2 x double>) nounwind readnone

define <2 x float> @frintp_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @frintp_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.ceil.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.ceil.v2f32(<2 x float> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @frintp_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @frintp_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.ceil.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.ceil.v4f32(<4 x float> %A)
  ret <4 x float> %tmpvar3
}

define <2 x double> @frintp_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @frintp_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.ceil.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.ceil.v2f64(<2 x double> %A)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.ceil.v2f32(<2 x float>) nounwind readnone
declare <4 x float> @llvm.ceil.v4f32(<4 x float>) nounwind readnone
declare <2 x double> @llvm.ceil.v2f64(<2 x double>) nounwind readnone

define <2 x float> @frintx_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @frintx_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.rint.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.rint.v2f32(<2 x float> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @frintx_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @frintx_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.rint.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.rint.v4f32(<4 x float> %A)
  ret <4 x float> %tmpvar3
}

define <2 x double> @frintx_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @frintx_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.rint.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.rint.v2f64(<2 x double> %A)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.rint.v2f32(<2 x float>) nounwind readnone
declare <4 x float> @llvm.rint.v4f32(<4 x float>) nounwind readnone
declare <2 x double> @llvm.rint.v2f64(<2 x double>) nounwind readnone

define <2 x float> @frintz_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @frintz_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.trunc.v2f32(<2 x float> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.trunc.v2f32(<2 x float> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @frintz_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @frintz_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.trunc.v4f32(<4 x float> [[A]])
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.trunc.v4f32(<4 x float> %A)
  ret <4 x float> %tmpvar3
}

define <2 x double> @frintz_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @frintz_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.trunc.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i64> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.trunc.v2f64(<2 x double> %A)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.trunc.v2f32(<2 x float>) nounwind readnone
declare <4 x float> @llvm.trunc.v4f32(<4 x float>) nounwind readnone
declare <2 x double> @llvm.trunc.v2f64(<2 x double>) nounwind readnone

define <2 x float> @fcvtxn_2s(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @fcvtxn_2s(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = sext <2 x i1> [[TMP2]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.aarch64.neon.fcvtxn.v2f32.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    store <2 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.aarch64.neon.fcvtxn.v2f32.v2f64(<2 x double> %A)
  ret <2 x float> %tmpvar3
}

define <4 x float> @fcvtxn_4s(<2 x float> %ret, <2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @fcvtxn_4s(
; CHECK-SAME: <2 x float> [[RET:%.*]], <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne <2 x i64> [[TMP1]], zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = sext <2 x i1> [[TMP3]] to <2 x i32>
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.aarch64.neon.fcvtxn.v2f32.v2f64(<2 x double> [[A]])
; CHECK-NEXT:    [[_MSPROP:%.*]] = shufflevector <2 x i32> [[TMP2]], <2 x i32> [[TMP4]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[RES:%.*]] = shufflevector <2 x float> [[RET]], <2 x float> [[TMPVAR3]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    store <4 x i32> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[RES]]
;
  %tmpvar3 = call <2 x float> @llvm.aarch64.neon.fcvtxn.v2f32.v2f64(<2 x double> %A)
  %res = shufflevector <2 x float> %ret, <2 x float> %tmpvar3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %res
}

declare <2 x float> @llvm.aarch64.neon.fcvtxn.v2f32.v2f64(<2 x double>) nounwind readnone

define <2 x i32> @fcvtzsc_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtzsc_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[TMP1]] to i64
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1:![0-9]+]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5:[0-9]+]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.vcvtfp2fxs.v2i32.v2f32(<2 x float> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.vcvtfp2fxs.v2i32.v2f32(<2 x float> %A, i32 1)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtzsc_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtzsc_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.vcvtfp2fxs.v4i32.v4f32(<4 x float> [[A]], i32 1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.vcvtfp2fxs.v4i32.v4f32(<4 x float> %A, i32 1)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtzsc_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtzsc_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i64> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.vcvtfp2fxs.v2i64.v2f64(<2 x double> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.vcvtfp2fxs.v2i64.v2f64(<2 x double> %A, i32 1)
  ret <2 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.vcvtfp2fxs.v2i32.v2f32(<2 x float>, i32) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.vcvtfp2fxs.v4i32.v4f32(<4 x float>, i32) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.vcvtfp2fxs.v2i64.v2f64(<2 x double>, i32) nounwind readnone

define <2 x i32> @fcvtzuc_2s(<2 x float> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i32> @fcvtzuc_2s(
; CHECK-SAME: <2 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[TMP1]] to i64
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i32> @llvm.aarch64.neon.vcvtfp2fxu.v2i32.v2f32(<2 x float> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i32> @llvm.aarch64.neon.vcvtfp2fxu.v2i32.v2f32(<2 x float> %A, i32 1)
  ret <2 x i32> %tmpvar3
}

define <4 x i32> @fcvtzuc_4s(<4 x float> %A) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @fcvtzuc_4s(
; CHECK-SAME: <4 x float> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x i32> @llvm.aarch64.neon.vcvtfp2fxu.v4i32.v4f32(<4 x float> [[A]], i32 1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x i32> @llvm.aarch64.neon.vcvtfp2fxu.v4i32.v4f32(<4 x float> %A, i32 1)
  ret <4 x i32> %tmpvar3
}

define <2 x i64> @fcvtzuc_2d(<2 x double> %A) nounwind #0 {
; CHECK-LABEL: define <2 x i64> @fcvtzuc_2d(
; CHECK-SAME: <2 x double> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i64> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x i64> @llvm.aarch64.neon.vcvtfp2fxu.v2i64.v2f64(<2 x double> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x i64> @llvm.aarch64.neon.vcvtfp2fxu.v2i64.v2f64(<2 x double> %A, i32 1)
  ret <2 x i64> %tmpvar3
}

declare <2 x i32> @llvm.aarch64.neon.vcvtfp2fxu.v2i32.v2f32(<2 x float>, i32) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.vcvtfp2fxu.v4i32.v4f32(<4 x float>, i32) nounwind readnone
declare <2 x i64> @llvm.aarch64.neon.vcvtfp2fxu.v2i64.v2f64(<2 x double>, i32) nounwind readnone

define <2 x float> @scvtf_2sc(<2 x i32> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @scvtf_2sc(
; CHECK-SAME: <2 x i32> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[TMP1]] to i64
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.aarch64.neon.vcvtfxs2fp.v2f32.v2i32(<2 x i32> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.aarch64.neon.vcvtfxs2fp.v2f32.v2i32(<2 x i32> %A, i32 1)
  ret <2 x float> %tmpvar3
}

define <4 x float> @scvtf_4sc(<4 x i32> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @scvtf_4sc(
; CHECK-SAME: <4 x i32> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.aarch64.neon.vcvtfxs2fp.v4f32.v4i32(<4 x i32> [[A]], i32 1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.aarch64.neon.vcvtfxs2fp.v4f32.v4i32(<4 x i32> %A, i32 1)
  ret <4 x float> %tmpvar3
}

define <2 x double> @scvtf_2dc(<2 x i64> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @scvtf_2dc(
; CHECK-SAME: <2 x i64> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i64> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.aarch64.neon.vcvtfxs2fp.v2f64.v2i64(<2 x i64> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.aarch64.neon.vcvtfxs2fp.v2f64.v2i64(<2 x i64> %A, i32 1)
  ret <2 x double> %tmpvar3
}

declare <2 x float> @llvm.aarch64.neon.vcvtfxs2fp.v2f32.v2i32(<2 x i32>, i32) nounwind readnone
declare <4 x float> @llvm.aarch64.neon.vcvtfxs2fp.v4f32.v4i32(<4 x i32>, i32) nounwind readnone
declare <2 x double> @llvm.aarch64.neon.vcvtfxs2fp.v2f64.v2i64(<2 x i64>, i32) nounwind readnone

define <2 x float> @ucvtf_2sc(<2 x i32> %A) nounwind #0 {
; CHECK-LABEL: define <2 x float> @ucvtf_2sc(
; CHECK-SAME: <2 x i32> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[TMP1]] to i64
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x float> @llvm.aarch64.neon.vcvtfxu2fp.v2f32.v2i32(<2 x i32> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x float> @llvm.aarch64.neon.vcvtfxu2fp.v2f32.v2i32(<2 x i32> %A, i32 1)
  ret <2 x float> %tmpvar3
}

define <4 x float> @ucvtf_4sc(<4 x i32> %A) nounwind #0 {
; CHECK-LABEL: define <4 x float> @ucvtf_4sc(
; CHECK-SAME: <4 x i32> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <4 x float> @llvm.aarch64.neon.vcvtfxu2fp.v4f32.v4i32(<4 x i32> [[A]], i32 1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[TMPVAR3]]
;
  %tmpvar3 = call <4 x float> @llvm.aarch64.neon.vcvtfxu2fp.v4f32.v4i32(<4 x i32> %A, i32 1)
  ret <4 x float> %tmpvar3
}

define <2 x double> @ucvtf_2dc(<2 x i64> %A) nounwind #0 {
; CHECK-LABEL: define <2 x double> @ucvtf_2dc(
; CHECK-SAME: <2 x i64> [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i64> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[TMPVAR3:%.*]] = call <2 x double> @llvm.aarch64.neon.vcvtfxu2fp.v2f64.v2i64(<2 x i64> [[A]], i32 1)
; CHECK-NEXT:    store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[TMPVAR3]]
;
  %tmpvar3 = call <2 x double> @llvm.aarch64.neon.vcvtfxu2fp.v2f64.v2i64(<2 x i64> %A, i32 1)
  ret <2 x double> %tmpvar3
}


define void @autogen_SD28458(<8 x double> %val.f64, ptr %addr.f32) #0 {
; CHECK-LABEL: define void @autogen_SD28458(
; CHECK-SAME: <8 x double> [[VAL_F64:%.*]], ptr [[ADDR_F32:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <8 x i64> [[TMP1]] to <8 x i32>
; CHECK-NEXT:    [[TR53:%.*]] = fptrunc <8 x double> [[VAL_F64]] to <8 x float>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP4:%.*]], label [[TMP5:%.*]], !prof [[PROF1]]
; CHECK:       4:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       5:
; CHECK-NEXT:    [[TMP6:%.*]] = ptrtoint ptr [[ADDR_F32]] to i64
; CHECK-NEXT:    [[TMP7:%.*]] = xor i64 [[TMP6]], 193514046488576
; CHECK-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; CHECK-NEXT:    store <8 x i32> [[TMP3]], ptr [[TMP8]], align 32
; CHECK-NEXT:    store <8 x float> [[TR53]], ptr [[ADDR_F32]], align 32
; CHECK-NEXT:    ret void
;
  %Tr53 = fptrunc <8 x double> %val.f64 to <8 x float>
  store <8 x float> %Tr53, ptr %addr.f32
  ret void
}

define void @autogen_SD19225(ptr %addr.f64, ptr %addr.f32) #0 {
; CHECK-LABEL: define void @autogen_SD19225(
; CHECK-SAME: ptr [[ADDR_F64:%.*]], ptr [[ADDR_F32:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label [[TMP3:%.*]], label [[TMP4:%.*]], !prof [[PROF1]]
; CHECK:       3:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       4:
; CHECK-NEXT:    [[A:%.*]] = load <8 x float>, ptr [[ADDR_F32]], align 32
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ADDR_F32]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i32>, ptr [[TMP7]], align 32
; CHECK-NEXT:    [[TMP8:%.*]] = zext <8 x i32> [[_MSLD]] to <8 x i64>
; CHECK-NEXT:    [[TR53:%.*]] = fpext <8 x float> [[A]] to <8 x double>
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label [[TMP9:%.*]], label [[TMP10:%.*]], !prof [[PROF1]]
; CHECK:       9:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR5]]
; CHECK-NEXT:    unreachable
; CHECK:       10:
; CHECK-NEXT:    [[TMP11:%.*]] = ptrtoint ptr [[ADDR_F64]] to i64
; CHECK-NEXT:    [[TMP12:%.*]] = xor i64 [[TMP11]], 193514046488576
; CHECK-NEXT:    [[TMP13:%.*]] = inttoptr i64 [[TMP12]] to ptr
; CHECK-NEXT:    store <8 x i64> [[TMP8]], ptr [[TMP13]], align 64
; CHECK-NEXT:    store <8 x double> [[TR53]], ptr [[ADDR_F64]], align 64
; CHECK-NEXT:    ret void
;
  %A = load <8 x float>, ptr %addr.f32
  %Tr53 = fpext <8 x float> %A to <8 x double>
  store <8 x double> %Tr53, ptr %addr.f64
  ret void
}

declare <2 x float> @llvm.aarch64.neon.vcvtfxu2fp.v2f32.v2i32(<2 x i32>, i32) nounwind readnone
declare <4 x float> @llvm.aarch64.neon.vcvtfxu2fp.v4f32.v4i32(<4 x i32>, i32) nounwind readnone
declare <2 x double> @llvm.aarch64.neon.vcvtfxu2fp.v2f64.v2i64(<2 x i64>, i32) nounwind readnone

attributes #0 = { sanitize_memory }
;.
; CHECK: [[PROF1]] = !{!"branch_weights", i32 1, i32 1048575}
;.
