; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu | FileCheck %s

define i32 @eq_i32(i32 %x) {
; CHECK-LABEL: eq_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @ne_i32(i32 %x) {
; CHECK-LABEL: ne_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, ne
; CHECK-NEXT:    ret
  %cmp = icmp ne i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @sgt_i32(i32 %x) {
; CHECK-LABEL: sgt_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, lt
; CHECK-NEXT:    ret
  %cmp = icmp sgt i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @sge_i32(i32 %x) {
; CHECK-LABEL: sge_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, le
; CHECK-NEXT:    ret
  %cmp = icmp sge i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @slt_i32(i32 %x) {
; CHECK-LABEL: slt_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, gt
; CHECK-NEXT:    ret
  %cmp = icmp slt i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @sle_i32(i32 %x) {
; CHECK-LABEL: sle_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, ge
; CHECK-NEXT:    ret
  %cmp = icmp sle i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @ugt_i32(i32 %x) {
; CHECK-LABEL: ugt_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, lo
; CHECK-NEXT:    ret
  %cmp = icmp ugt i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @uge_i32(i32 %x) {
; CHECK-LABEL: uge_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w9, w0, #21
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    sub w8, w8, w0
; CHECK-NEXT:    cmp w9, #2046
; CHECK-NEXT:    csel w0, w0, w8, hi
; CHECK-NEXT:    ret
  %cmp = icmp uge i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @ult_i32(i32 %x) {
; CHECK-LABEL: ult_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, hi
; CHECK-NEXT:    ret
  %cmp = icmp ult i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}

define i32 @ule_i32(i32 %x) {
; CHECK-LABEL: ule_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2097152 // =0xffe00000
; CHECK-NEXT:    subs w8, w8, w0
; CHECK-NEXT:    csel w0, w0, w8, hs
; CHECK-NEXT:    ret
  %cmp = icmp ule i32 %x, -2097152
  %sub = sub i32 -2097152, %x
  %retval.0 = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %retval.0
}


define i64 @eq_i64(i64 %x) {
; CHECK-LABEL: eq_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    subs x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @ne_i64(i64 %x) {
; CHECK-LABEL: ne_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    subs x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, ne
; CHECK-NEXT:    ret
  %cmp = icmp ne i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @sgt_i64(i64 %x) {
; CHECK-LABEL: sgt_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    subs x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, lt
; CHECK-NEXT:    ret
  %cmp = icmp sgt i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @sge_i64(i64 %x) {
; CHECK-LABEL: sge_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    cmp x0, #99
; CHECK-NEXT:    sub x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, gt
; CHECK-NEXT:    ret
  %cmp = icmp sge i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @slt_i64(i64 %x) {
; CHECK-LABEL: slt_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    subs x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, gt
; CHECK-NEXT:    ret
  %cmp = icmp slt i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @sle_i64(i64 %x) {
; CHECK-LABEL: sle_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    cmp x0, #101
; CHECK-NEXT:    sub x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, lt
; CHECK-NEXT:    ret
  %cmp = icmp sle i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @ugt_i64(i64 %x) {
; CHECK-LABEL: ugt_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    subs x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, lo
; CHECK-NEXT:    ret
  %cmp = icmp ugt i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @uge_i64(i64 %x) {
; CHECK-LABEL: uge_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    cmp x0, #99
; CHECK-NEXT:    sub x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, hi
; CHECK-NEXT:    ret
  %cmp = icmp uge i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @ult_i64(i64 %x) {
; CHECK-LABEL: ult_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    subs x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, hi
; CHECK-NEXT:    ret
  %cmp = icmp ult i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}

define i64 @ule_i64(i64 %x) {
; CHECK-LABEL: ule_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    cmp x0, #101
; CHECK-NEXT:    sub x8, x8, x0
; CHECK-NEXT:    csel x0, x0, x8, lo
; CHECK-NEXT:    ret
  %cmp = icmp ule i64 %x, 100
  %sub = sub i64 100, %x
  %retval.0 = select i1 %cmp, i64 %x, i64 %sub
  ret i64 %retval.0
}


define i64 @both(i64 %x) {
; CHECK-LABEL: both:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #100 // =0x64
; CHECK-NEXT:    sub x9, x0, #100
; CHECK-NEXT:    cmp x0, #101
; CHECK-NEXT:    sub x8, x8, x0
; CHECK-NEXT:    csel x0, x8, x9, lo
; CHECK-NEXT:    ret
  %cmp = icmp ule i64 %x, 100
  %sub1 = sub i64 100, %x
  %sub2 = sub i64 %x, 100
  %retval.0 = select i1 %cmp, i64 %sub1, i64 %sub2
  ret i64 %retval.0
}

define i32 @qabs(i32 %0) {
; CHECK-LABEL: qabs:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2147483648 // =0x80000000
; CHECK-NEXT:    cmp w0, w8
; CHECK-NEXT:    mov w8, #2147483647 // =0x7fffffff
; CHECK-NEXT:    csneg w8, w8, w0, eq
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w0, w0, w8, gt
; CHECK-NEXT:    ret
  %cmp1 = icmp sgt i32 %0, 0
  %cmp2 = icmp eq i32 %0, -2147483648
  %sub = sub nsw i32 0, %0
  %cond = select i1 %cmp2, i32 2147483647, i32 %sub
  %cond6 = select i1 %cmp1, i32 %0, i32 %cond
  ret i32 %cond6
}
