; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=riscv32 -mattr=+xcvbitmanip -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-O0
; RUN: llc -O3 -mtriple=riscv32 -mattr=+xcvbitmanip -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-O3

declare i32 @llvm.riscv.cv.bitmanip.extract(i32, i32)

define i32 @test.cv.extractr(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.extractr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.extractr a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.extract(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @test.cv.extract(i32 %a) {
; CHECK-LABEL: test.cv.extract:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.extract a0, a0, 2, 1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.extract(i32 %a, i32 65)
  ret i32 %1
}

define i32 @test.cv.extract1023(i32 %a) {
; CHECK-LABEL: test.cv.extract1023:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.extract a0, a0, 31, 31
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.extract(i32 %a, i32 1023)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.bitmanip.extractu(i32, i32)

define i32 @test.cv.extractur(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.extractur:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.extractur a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.extractu(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @test.cv.extractu(i32 %a) {
; CHECK-LABEL: test.cv.extractu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.extractu a0, a0, 2, 1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.extractu(i32 %a, i32 65)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.bitmanip.insert(i32, i32, i32)

define i32 @test.cv.insert(i32 %c, i32 %a) {
; CHECK-LABEL: test.cv.insert:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.insert a0, a1, 2, 1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.insert(i32 %a, i32 65, i32 %c)
  ret i32 %1
}

define i32 @test.cv.insertr(i32 %c, i32 %b, i32 %a) {
; CHECK-LABEL: test.cv.insertr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.insertr a0, a2, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.insert(i32 %a, i32 %b, i32 %c)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.bitmanip.bclr(i32, i32)

define i32 @test.cv.bclrr(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.bclrr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.bclrr a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.bclr(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @test.cv.bclr(i32 %a) {
; CHECK-LABEL: test.cv.bclr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.bclr a0, a0, 2, 1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.bclr(i32 %a, i32 65)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.bitmanip.bset(i32, i32)

define i32 @test.cv.bsetr(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.bsetr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.bsetr a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.bset(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @test.cv.bset(i32 %a) {
; CHECK-LABEL: test.cv.bset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.bset a0, a0, 2, 1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.bset(i32 %a, i32 65)
  ret i32 %1
}

declare i32 @llvm.cttz.i32(i32, i1)

define i32 @test.cv.ff1(i32 %a) {
; CHECK-LABEL: test.cv.ff1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.ff1 a0, a0
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.cttz.i32(i32 %a, i1 0)
  ret i32 %1
}

declare i32 @llvm.ctlz.i32(i32, i1)

define i32 @test.cv.fl1(i32 %a) {
; CHECK-LABEL: test.cv.fl1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.fl1 a0, a0
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.ctlz.i32(i32 %a, i1 0)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.bitmanip.clb(i32)

define i32 @test.cv.clb(i32 %a) {
; CHECK-LABEL: test.cv.clb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.clb a0, a0
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.clb(i32 %a)
  ret i32 %1
}

declare i32 @llvm.ctpop(i32)

define i32 @test.cv.cnt(i32 %a) {
; CHECK-LABEL: test.cv.cnt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.cnt a0, a0
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.ctpop(i32 %a)
  ret i32 %1
}

declare i32 @llvm.fshl.i32(i32, i32, i32)

define i32 @test.llvm.fshl.imm(i32 %a) {
; CHECK-LABEL: test.llvm.fshl.imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 30
; CHECK-NEXT:    cv.ror a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 2)
  ret i32 %1
}

define i32 @test.llvm.fshl.reg(i32 %a, i32 %b) {
; CHECK-O0-LABEL: test.llvm.fshl.reg:
; CHECK-O0:       # %bb.0:
; CHECK-O0-NEXT:    mv a2, a1
; CHECK-O0-NEXT:    li a1, 0
; CHECK-O0-NEXT:    sub a1, a1, a2
; CHECK-O0-NEXT:    cv.ror a0, a0, a1
; CHECK-O0-NEXT:    ret
;
; CHECK-O3-LABEL: test.llvm.fshl.reg:
; CHECK-O3:       # %bb.0:
; CHECK-O3-NEXT:    neg a1, a1
; CHECK-O3-NEXT:    cv.ror a0, a0, a1
; CHECK-O3-NEXT:    ret
  %1 = call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 %b)
  ret i32 %1
}

declare i32 @llvm.fshr.i32(i32, i32, i32)

define i32 @test.llvm.fshr.imm(i32 %a) {
; CHECK-LABEL: test.llvm.fshr.imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 2
; CHECK-NEXT:    cv.ror a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 2)
  ret i32 %1
}

define i32 @test.llvm.fshr.reg(i32 %a, i32 %b) {
; CHECK-LABEL: test.llvm.fshr.reg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.ror a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 %b)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.bitmanip.bitrev(i32, i32, i32)

define i32 @test.cv.bitrev(i32 %a) {
; CHECK-LABEL: test.cv.bitrev:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.bitrev a0, a0, 2, 1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.bitmanip.bitrev(i32 %a, i32 1, i32 2)
  ret i32 %1
}

declare i32 @llvm.bitreverse(i32)

define i32 @test.llvm.bitrev(i32 %a) {
; CHECK-LABEL: test.llvm.bitrev:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.bitrev a0, a0, 0, 0
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.bitreverse(i32 %a)
  ret i32 %1
}
