;; Test to make sure we don't fail when cloning in a case where we end up with
;; a clone that has fewer edges than the node it was initially cloned from.
;; This test was reduced and simplified from xalancbmk with some random hotness
;; applied to the profile that reproduced the issue.

; RUN: opt -passes=memprof-context-disambiguation -supports-hot-cold-new \
; RUN:		-memprof-verify-ccg -memprof-verify-nodes \
; RUN: 		-pass-remarks=memprof-context-disambiguation %s -S 2>&1 | FileCheck %s

;; Make sure we successfully created at least one clone
; CHECK: created clone {{.*}}.memprof.1

; ModuleID = '<stdin>'
source_filename = "reduced.ll"
target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-f80:128-n8:16:32:64-S128"
target triple = "x86_64-grtev4-linux-gnu"

define void @A() {
  call void @B(), !callsite !0
  ret void
}

define void @C() {
  call void @D(), !callsite !1
  ret void
}

define void @D() {
  call void @A(), !callsite !2
  ret void
}

define void @E() {
  %1 = call ptr @_Znwm(i64 0), !memprof !3, !callsite !20
  ret void
}

define void @B() {
  call void @F(), !callsite !21
  ret void
}

define void @F() {
  call void @E(), !callsite !22
  call void @G(), !callsite !23
  ret void
}

define void @G() {
  %1 = call ptr @_Znwm(i64 0), !memprof !24, !callsite !37
  ret void
}

declare ptr @_Znwm(i64)

!0 = !{i64 1995602625719775354}
!1 = !{i64 4312698517630782220}
!2 = !{i64 5516454029445989383}
!3 = !{!4, !6, !8, !10, !12, !14, !16, !18}
!4 = !{!5, !"notcold"}
!5 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 1995602625719775354}
!6 = !{!7, !"cold"}
!7 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 2077908580042347045, i64 4312698517630782220, i64 5379466077518675850}
!8 = !{!9, !"cold"}
!9 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 2077908580042347045, i64 4312698517630782220, i64 -7632894069000375689}
!10 = !{!11, !"cold"}
!11 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 2939944783060497247}
!12 = !{!13, !"notcold"}
!13 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 5642549674080861567, i64 5516454029445989383, i64 4312698517630782220, i64 -7632894069000375689}
!14 = !{!15, !"cold"}
!15 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 5642549674080861567, i64 5516454029445989383, i64 4312698517630782220, i64 -1805555115991223293}
!16 = !{!17, !"notcold"}
!17 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 -4746997736434041076, i64 5516454029445989383, i64 4312698517630782220, i64 -1805555115991223293}
!18 = !{!19, !"notcold"}
!19 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862, i64 7147584705143805656, i64 -6456074186195384663, i64 -4637272929643682959}
!20 = !{i64 -2282665745786859978, i64 -6758300505622211768, i64 2938340307832638862}
!21 = !{i64 -6456074186195384663}
!22 = !{i64 7147584705143805656}
!23 = !{i64 3938822378769440754}
!24 = !{!25, !27, !29, !31, !33, !35}
!25 = !{!26, !"cold"}
!26 = !{i64 -2282665745786859978, i64 -3548918226713766361, i64 4077289288013931196, i64 3938822378769440754, i64 -6456074186195384663, i64 1995602625719775354, i64 5516454029445989383, i64 4312698517630782220, i64 -1805555115991223293}
!27 = !{!28, !"notcold"}
!28 = !{i64 -2282665745786859978, i64 -3548918226713766361, i64 4077289288013931196, i64 3938822378769440754, i64 -6456074186195384663, i64 2077908580042347045, i64 4312698517630782220, i64 -7632894069000375689}
!29 = !{!30, !"cold"}
!30 = !{i64 -2282665745786859978, i64 -3548918226713766361, i64 4077289288013931196, i64 3938822378769440754, i64 -6456074186195384663, i64 -4746997736434041076, i64 5516454029445989383, i64 4312698517630782220, i64 -7632894069000375689}
!31 = !{!32, !"notcold"}
!32 = !{i64 -2282665745786859978, i64 -3548918226713766361, i64 4077289288013931196, i64 3938822378769440754, i64 -6456074186195384663, i64 -4746997736434041076, i64 5516454029445989383, i64 4312698517630782220, i64 -1805555115991223293}
!33 = !{!34, !"cold"}
!34 = !{i64 -2282665745786859978, i64 -3548918226713766361, i64 4077289288013931196, i64 3938822378769440754, i64 -6456074186195384663, i64 -4637272929643682959}
!35 = !{!36, !"notcold"}
!36 = !{i64 -2282665745786859978, i64 -3548918226713766361, i64 4077289288013931196, i64 3938822378769440754, i64 -6456074186195384663, i64 -4409412896859835674}
!37 = !{i64 -2282665745786859978, i64 -3548918226713766361, i64 4077289288013931196}
