; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -S -p vector-combine | FileCheck %s

define <4 x i32> @umax_fixed(i32 %x, i32 %y) {
; CHECK-LABEL: define <4 x i32> @umax_fixed(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <4 x i32> poison, i32 [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <4 x i32> [[V]]
;
  %x.insert = insertelement <4 x i32> poison, i32 %x, i32 0
  %y.insert = insertelement <4 x i32> poison, i32 %y, i32 0
  %v = call <4 x i32> @llvm.umax(<4 x i32> %x.insert, <4 x i32> %y.insert)
  ret <4 x i32> %v
}

define <vscale x 4 x i32> @umax_scalable(i32 %x, i32 %y) {
; CHECK-LABEL: define <vscale x 4 x i32> @umax_scalable(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <vscale x 4 x i32> [[V]]
;
  %x.insert = insertelement <vscale x 4 x i32> poison, i32 %x, i32 0
  %y.insert = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %v = call <vscale x 4 x i32> @llvm.umax(<vscale x 4 x i32> %x.insert, <vscale x 4 x i32> %y.insert)
  ret <vscale x 4 x i32> %v
}

define <4 x i32> @umax_fixed_lhs_const(i32 %x) {
; CHECK-LABEL: define <4 x i32> @umax_fixed_lhs_const(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call i32 @llvm.umax.i32(i32 1, i32 [[X]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <4 x i32> poison, i32 [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <4 x i32> [[V]]
;
  %x.insert = insertelement <4 x i32> poison, i32 %x, i32 0
  %v = call <4 x i32> @llvm.umax(<4 x i32> <i32 1, i32 2, i32 3, i32 4>, <4 x i32> %x.insert)
  ret <4 x i32> %v
}

define <4 x i32> @umax_fixed_rhs_const(i32 %x) {
; CHECK-LABEL: define <4 x i32> @umax_fixed_rhs_const(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[V:%.*]] = insertelement <4 x i32> poison, i32 [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <4 x i32> [[V]]
;
  %x.insert = insertelement <4 x i32> poison, i32 %x, i32 0
  %v = call <4 x i32> @llvm.umax(<4 x i32> %x.insert, <4 x i32> <i32 1, i32 2, i32 3, i32 4>)
  ret <4 x i32> %v
}

define <vscale x 4 x i32> @umax_scalable_lhs_const(i32 %x) {
; CHECK-LABEL: define <vscale x 4 x i32> @umax_scalable_lhs_const(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call i32 @llvm.umax.i32(i32 42, i32 [[X]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <vscale x 4 x i32> [[V]]
;
  %x.insert = insertelement <vscale x 4 x i32> poison, i32 %x, i32 0
  %v = call <vscale x 4 x i32> @llvm.umax(<vscale x 4 x i32> splat (i32 42), <vscale x 4 x i32> %x.insert)
  ret <vscale x 4 x i32> %v
}

define <vscale x 4 x i32> @umax_scalable_rhs_const(i32 %x) {
; CHECK-LABEL: define <vscale x 4 x i32> @umax_scalable_rhs_const(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 42)
; CHECK-NEXT:    [[V:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <vscale x 4 x i32> [[V]]
;
  %x.insert = insertelement <vscale x 4 x i32> poison, i32 %x, i32 0
  %v = call <vscale x 4 x i32> @llvm.umax(<vscale x 4 x i32> %x.insert, <vscale x 4 x i32> splat (i32 42))
  ret <vscale x 4 x i32> %v
}

; Shouldn't be scalarized, not a "trivially vectorizable" intrinsic.
define <4 x i32> @non_trivially_vectorizable(i32 %x, i32 %y) {
; CHECK-LABEL: define <4 x i32> @non_trivially_vectorizable(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[X_INSERT:%.*]] = insertelement <4 x i32> poison, i32 [[X]], i32 0
; CHECK-NEXT:    [[Y_INSERT:%.*]] = insertelement <8 x i32> poison, i32 [[Y]], i32 0
; CHECK-NEXT:    [[V:%.*]] = call <4 x i32> @llvm.experimental.vector.partial.reduce.add.v4i32.v8i32(<4 x i32> [[X_INSERT]], <8 x i32> [[Y_INSERT]])
; CHECK-NEXT:    ret <4 x i32> [[V]]
;
  %x.insert = insertelement <4 x i32> poison, i32 %x, i32 0
  %y.insert = insertelement <8 x i32> poison, i32 %y, i32 0
  %v = call <4 x i32> @llvm.experimental.vector.partial.reduce.add(<4 x i32> %x.insert, <8 x i32> %y.insert)
  ret <4 x i32> %v
}

define <4 x float> @fabs_fixed(float %x) {
; CHECK-LABEL: define <4 x float> @fabs_fixed(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <4 x float> poison, float [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <4 x float> [[V]]
;
  %x.insert = insertelement <4 x float> poison, float %x, i32 0
  %v = call <4 x float> @llvm.fabs(<4 x float> %x.insert)
  ret <4 x float> %v
}

define <vscale x 4 x float> @fabs_scalable(float %x) {
; CHECK-LABEL: define <vscale x 4 x float> @fabs_scalable(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <vscale x 4 x float> poison, float [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <vscale x 4 x float> [[V]]
;
  %x.insert = insertelement <vscale x 4 x float> poison, float %x, i32 0
  %v = call <vscale x 4 x float> @llvm.fabs(<vscale x 4 x float> %x.insert)
  ret <vscale x 4 x float> %v
}

define <4 x float> @fma_fixed(float %x, float %y, float %z) {
; CHECK-LABEL: define <4 x float> @fma_fixed(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call float @llvm.fma.f32(float [[X]], float [[Y]], float [[Z]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <4 x float> poison, float [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <4 x float> [[V]]
;
  %x.insert = insertelement <4 x float> poison, float %x, i32 0
  %y.insert = insertelement <4 x float> poison, float %y, i32 0
  %z.insert = insertelement <4 x float> poison, float %z, i32 0
  %v = call <4 x float> @llvm.fma(<4 x float> %x.insert, <4 x float> %y.insert, <4 x float> %z.insert)
  ret <4 x float> %v
}

define <vscale x 4 x float> @fma_scalable(float %x, float %y, float %z) {
; CHECK-LABEL: define <vscale x 4 x float> @fma_scalable(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call float @llvm.fma.f32(float [[X]], float [[Y]], float [[Z]])
; CHECK-NEXT:    [[V:%.*]] = insertelement <vscale x 4 x float> poison, float [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <vscale x 4 x float> [[V]]
;
  %x.insert = insertelement <vscale x 4 x float> poison, float %x, i32 0
  %y.insert = insertelement <vscale x 4 x float> poison, float %y, i32 0
  %z.insert = insertelement <vscale x 4 x float> poison, float %z, i32 0
  %v = call <vscale x 4 x float> @llvm.fma(<vscale x 4 x float> %x.insert, <vscale x 4 x float> %y.insert, <vscale x 4 x float> %z.insert)
  ret <vscale x 4 x float> %v
}

define <4 x float> @scalar_argument(float %x) {
; CHECK-LABEL: define <4 x float> @scalar_argument(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = call float @llvm.powi.f32.i32(float [[X]], i32 42)
; CHECK-NEXT:    [[V:%.*]] = insertelement <4 x float> poison, float [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <4 x float> [[V]]
;
  %x.insert = insertelement <4 x float> poison, float %x, i32 0
  %v = call <4 x float> @llvm.powi(<4 x float> %x.insert, i32 42)
  ret <4 x float> %v
}

define <4 x i2> @scmp(i32 %x) {
; CHECK-LABEL: define <4 x i2> @scmp(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[X_INSERT:%.*]] = insertelement <4 x i32> poison, i32 [[X]], i32 0
; CHECK-NEXT:    [[V:%.*]] = call <4 x i2> @llvm.scmp.v4i2.v4i32(<4 x i32> [[X_INSERT]], <4 x i32> zeroinitializer)
; CHECK-NEXT:    ret <4 x i2> [[V]]
;
  %x.insert = insertelement <4 x i32> poison, i32 %x, i32 0
  %v = call <4 x i2> @llvm.scmp(<4 x i32> %x.insert, <4 x i32> splat (i32 0))
  ret <4 x i2> %v
}
