/* Copyright © Triad National Security, LLC, and others.

   Environment variable handling. */

#define _GNU_SOURCE
#pragma once

#include "core.h"
#include "misc.h"


/** Types **/

struct env_file {
   char *path;
   char delim;
   bool expand;
};

struct env_var {
   char *name;
   char *value;
};

/** Disallowed functions **/


/** Function prototypes **/

char *cenv_get(struct container *c, const char *name);
void cenv_set(struct container *c, const char *name, const char *value);
void cenv_unset(struct container *c, const char *name);
void cenvs_set(struct container *c, const struct env_var *envs);
void cenvs_unset(struct container *c, const char *glob);
struct env_var *env_file_read(const char *path, int delim);
char *environ_serialize(char **env, size_t *byte_ct);
char **environ_unserialize(char *buf, size_t byte_ct);
struct env_var env_parse(const char *line, const char *path, size_t lineno);
void envs_hook_set_file(struct container *c, void *d);
void envs_hook_set(struct container *c, void *d);
void envs_hook_unset(struct container *c, void *d);
char *getenv_df(const char *name, char *df);
bool getenv_first(char **names, char **name, char **value);
