// SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause
/* Copyright(c) 2024  Realtek Corporation
 */

#include "main.h"
#include "phy.h"
#include "rtw8821a_table.h"

static const u32 rtw8821a_mac[] = {
	0x421, 0x0000000F,
	0x428, 0x0000000A,
	0x429, 0x00000010,
	0x430, 0x00000000,
	0x431, 0x00000000,
	0x432, 0x00000000,
	0x433, 0x00000001,
	0x434, 0x00000004,
	0x435, 0x00000005,
	0x436, 0x00000007,
	0x437, 0x00000008,
	0x43C, 0x00000004,
	0x43D, 0x00000005,
	0x43E, 0x00000007,
	0x43F, 0x00000008,
	0x440, 0x0000005D,
	0x441, 0x00000001,
	0x442, 0x00000000,
	0x444, 0x00000010,
	0x445, 0x00000000,
	0x446, 0x00000000,
	0x447, 0x00000000,
	0x448, 0x00000000,
	0x449, 0x000000F0,
	0x44A, 0x0000000F,
	0x44B, 0x0000003E,
	0x44C, 0x00000010,
	0x44D, 0x00000000,
	0x44E, 0x00000000,
	0x44F, 0x00000000,
	0x450, 0x00000000,
	0x451, 0x000000F0,
	0x452, 0x0000000F,
	0x453, 0x00000000,
	0x456, 0x0000005E,
	0x460, 0x00000066,
	0x461, 0x00000066,
	0x4C8, 0x0000003F,
	0x4C9, 0x000000FF,
	0x4CC, 0x000000FF,
	0x4CD, 0x000000FF,
	0x4CE, 0x00000001,
	0x500, 0x00000026,
	0x501, 0x000000A2,
	0x502, 0x0000002F,
	0x503, 0x00000000,
	0x504, 0x00000028,
	0x505, 0x000000A3,
	0x506, 0x0000005E,
	0x507, 0x00000000,
	0x508, 0x0000002B,
	0x509, 0x000000A4,
	0x50A, 0x0000005E,
	0x50B, 0x00000000,
	0x50C, 0x0000004F,
	0x50D, 0x000000A4,
	0x50E, 0x00000000,
	0x50F, 0x00000000,
	0x512, 0x0000001C,
	0x514, 0x0000000A,
	0x516, 0x0000000A,
	0x525, 0x0000004F,
	0x550, 0x00000010,
	0x551, 0x00000010,
	0x559, 0x00000002,
	0x55C, 0x00000050,
	0x55D, 0x000000FF,
	0x605, 0x00000030,
	0x607, 0x00000007,
	0x608, 0x0000000E,
	0x609, 0x0000002A,
	0x620, 0x000000FF,
	0x621, 0x000000FF,
	0x622, 0x000000FF,
	0x623, 0x000000FF,
	0x624, 0x000000FF,
	0x625, 0x000000FF,
	0x626, 0x000000FF,
	0x627, 0x000000FF,
	0x638, 0x00000050,
	0x63C, 0x0000000A,
	0x63D, 0x0000000A,
	0x63E, 0x0000000E,
	0x63F, 0x0000000E,
	0x640, 0x00000040,
	0x642, 0x00000040,
	0x643, 0x00000000,
	0x652, 0x000000C8,
	0x66E, 0x00000005,
	0x700, 0x00000021,
	0x701, 0x00000043,
	0x702, 0x00000065,
	0x703, 0x00000087,
	0x708, 0x00000021,
	0x709, 0x00000043,
	0x70A, 0x00000065,
	0x70B, 0x00000087,
	0x718, 0x00000040,
};

RTW_DECL_TABLE_PHY_COND(rtw8821a_mac, rtw_phy_cfg_mac);

static const u32 rtw8821a_agc[] = {
	0x81C, 0xBF000001,
	0x81C, 0xBF020001,
	0x81C, 0xBF040001,
	0x81C, 0xBF060001,
	0x81C, 0xBE080001,
	0x81C, 0xBD0A0001,
	0x81C, 0xBC0C0001,
	0x81C, 0xBA0E0001,
	0x81C, 0xB9100001,
	0x81C, 0xB8120001,
	0x81C, 0xB7140001,
	0x81C, 0xB6160001,
	0x81C, 0xB5180001,
	0x81C, 0xB41A0001,
	0x81C, 0xB31C0001,
	0x81C, 0xB21E0001,
	0x81C, 0xB1200001,
	0x81C, 0xB0220001,
	0x81C, 0xAF240001,
	0x81C, 0xAE260001,
	0x81C, 0xAD280001,
	0x81C, 0xAC2A0001,
	0x81C, 0xAB2C0001,
	0x81C, 0xAA2E0001,
	0x81C, 0xA9300001,
	0x81C, 0xA8320001,
	0x81C, 0xA7340001,
	0x81C, 0xA6360001,
	0x81C, 0xA5380001,
	0x81C, 0xA43A0001,
	0x81C, 0x683C0001,
	0x81C, 0x673E0001,
	0x81C, 0x66400001,
	0x81C, 0x65420001,
	0x81C, 0x64440001,
	0x81C, 0x63460001,
	0x81C, 0x62480001,
	0x81C, 0x614A0001,
	0x81C, 0x474C0001,
	0x81C, 0x464E0001,
	0x81C, 0x45500001,
	0x81C, 0x44520001,
	0x81C, 0x43540001,
	0x81C, 0x42560001,
	0x81C, 0x41580001,
	0x81C, 0x285A0001,
	0x81C, 0x275C0001,
	0x81C, 0x265E0001,
	0x81C, 0x25600001,
	0x81C, 0x24620001,
	0x81C, 0x0A640001,
	0x81C, 0x09660001,
	0x81C, 0x08680001,
	0x81C, 0x076A0001,
	0x81C, 0x066C0001,
	0x81C, 0x056E0001,
	0x81C, 0x04700001,
	0x81C, 0x03720001,
	0x81C, 0x02740001,
	0x81C, 0x01760001,
	0x81C, 0x01780001,
	0x81C, 0x017A0001,
	0x81C, 0x017C0001,
	0x81C, 0x017E0001,
	0x8000020c,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFB000101,
	0x81C, 0xFA020101,
	0x81C, 0xF9040101,
	0x81C, 0xF8060101,
	0x81C, 0xF7080101,
	0x81C, 0xF60A0101,
	0x81C, 0xF50C0101,
	0x81C, 0xF40E0101,
	0x81C, 0xF3100101,
	0x81C, 0xF2120101,
	0x81C, 0xF1140101,
	0x81C, 0xF0160101,
	0x81C, 0xEF180101,
	0x81C, 0xEE1A0101,
	0x81C, 0xED1C0101,
	0x81C, 0xEC1E0101,
	0x81C, 0xEB200101,
	0x81C, 0xEA220101,
	0x81C, 0xE9240101,
	0x81C, 0xE8260101,
	0x81C, 0xE7280101,
	0x81C, 0xE62A0101,
	0x81C, 0xE52C0101,
	0x81C, 0xE42E0101,
	0x81C, 0xE3300101,
	0x81C, 0xA5320101,
	0x81C, 0xA4340101,
	0x81C, 0xA3360101,
	0x81C, 0x87380101,
	0x81C, 0x863A0101,
	0x81C, 0x853C0101,
	0x81C, 0x843E0101,
	0x81C, 0x69400101,
	0x81C, 0x68420101,
	0x81C, 0x67440101,
	0x81C, 0x66460101,
	0x81C, 0x49480101,
	0x81C, 0x484A0101,
	0x81C, 0x474C0101,
	0x81C, 0x2A4E0101,
	0x81C, 0x29500101,
	0x81C, 0x28520101,
	0x81C, 0x27540101,
	0x81C, 0x26560101,
	0x81C, 0x25580101,
	0x81C, 0x245A0101,
	0x81C, 0x235C0101,
	0x81C, 0x055E0101,
	0x81C, 0x04600101,
	0x81C, 0x03620101,
	0x81C, 0x02640101,
	0x81C, 0x01660101,
	0x81C, 0x01680101,
	0x81C, 0x016A0101,
	0x81C, 0x016C0101,
	0x81C, 0x016E0101,
	0x81C, 0x01700101,
	0x81C, 0x01720101,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFB000101,
	0x81C, 0xFA020101,
	0x81C, 0xF9040101,
	0x81C, 0xF8060101,
	0x81C, 0xF7080101,
	0x81C, 0xF60A0101,
	0x81C, 0xF50C0101,
	0x81C, 0xF40E0101,
	0x81C, 0xF3100101,
	0x81C, 0xF2120101,
	0x81C, 0xF1140101,
	0x81C, 0xF0160101,
	0x81C, 0xEF180101,
	0x81C, 0xEE1A0101,
	0x81C, 0xED1C0101,
	0x81C, 0xEC1E0101,
	0x81C, 0xEB200101,
	0x81C, 0xEA220101,
	0x81C, 0xE9240101,
	0x81C, 0xE8260101,
	0x81C, 0xE7280101,
	0x81C, 0xE62A0101,
	0x81C, 0xE52C0101,
	0x81C, 0xE42E0101,
	0x81C, 0xE3300101,
	0x81C, 0xA5320101,
	0x81C, 0xA4340101,
	0x81C, 0xA3360101,
	0x81C, 0x87380101,
	0x81C, 0x863A0101,
	0x81C, 0x853C0101,
	0x81C, 0x843E0101,
	0x81C, 0x69400101,
	0x81C, 0x68420101,
	0x81C, 0x67440101,
	0x81C, 0x66460101,
	0x81C, 0x49480101,
	0x81C, 0x484A0101,
	0x81C, 0x474C0101,
	0x81C, 0x2A4E0101,
	0x81C, 0x29500101,
	0x81C, 0x28520101,
	0x81C, 0x27540101,
	0x81C, 0x26560101,
	0x81C, 0x25580101,
	0x81C, 0x245A0101,
	0x81C, 0x235C0101,
	0x81C, 0x055E0101,
	0x81C, 0x04600101,
	0x81C, 0x03620101,
	0x81C, 0x02640101,
	0x81C, 0x01660101,
	0x81C, 0x01680101,
	0x81C, 0x016A0101,
	0x81C, 0x016C0101,
	0x81C, 0x016E0101,
	0x81C, 0x01700101,
	0x81C, 0x01720101,
	0xA0000000,	0x00000000,
	0x81C, 0xFF000101,
	0x81C, 0xFF020101,
	0x81C, 0xFE040101,
	0x81C, 0xFD060101,
	0x81C, 0xFC080101,
	0x81C, 0xFD0A0101,
	0x81C, 0xFC0C0101,
	0x81C, 0xFB0E0101,
	0x81C, 0xFA100101,
	0x81C, 0xF9120101,
	0x81C, 0xF8140101,
	0x81C, 0xF7160101,
	0x81C, 0xF6180101,
	0x81C, 0xF51A0101,
	0x81C, 0xF41C0101,
	0x81C, 0xF31E0101,
	0x81C, 0xF2200101,
	0x81C, 0xF1220101,
	0x81C, 0xF0240101,
	0x81C, 0xEF260101,
	0x81C, 0xEE280101,
	0x81C, 0xED2A0101,
	0x81C, 0xEC2C0101,
	0x81C, 0xEB2E0101,
	0x81C, 0xEA300101,
	0x81C, 0xE9320101,
	0x81C, 0xE8340101,
	0x81C, 0xE7360101,
	0x81C, 0xE6380101,
	0x81C, 0xE53A0101,
	0x81C, 0xE43C0101,
	0x81C, 0xE33E0101,
	0x81C, 0xA5400101,
	0x81C, 0xA4420101,
	0x81C, 0xA3440101,
	0x81C, 0x87460101,
	0x81C, 0x86480101,
	0x81C, 0x854A0101,
	0x81C, 0x844C0101,
	0x81C, 0x694E0101,
	0x81C, 0x68500101,
	0x81C, 0x67520101,
	0x81C, 0x66540101,
	0x81C, 0x49560101,
	0x81C, 0x48580101,
	0x81C, 0x475A0101,
	0x81C, 0x2A5C0101,
	0x81C, 0x295E0101,
	0x81C, 0x28600101,
	0x81C, 0x27620101,
	0x81C, 0x26640101,
	0x81C, 0x25660101,
	0x81C, 0x24680101,
	0x81C, 0x236A0101,
	0x81C, 0x056C0101,
	0x81C, 0x046E0101,
	0x81C, 0x03700101,
	0x81C, 0x02720101,
	0xB0000000,	0x00000000,
	0x81C, 0x01740101,
	0x81C, 0x01760101,
	0x81C, 0x01780101,
	0x81C, 0x017A0101,
	0x81C, 0x017C0101,
	0x81C, 0x017E0101,
	0xC50, 0x00000022,
	0xC50, 0x00000020,
};

RTW_DECL_TABLE_PHY_COND(rtw8821a_agc, rtw_phy_cfg_agc);

static const u32 rtw8821a_bb[] = {
	0x800, 0x0020D090,
	0x804, 0x080112E0,
	0x808, 0x0E028211,
	0x80C, 0x92131111,
	0x810, 0x20101261,
	0x814, 0x020C3D10,
	0x818, 0x03A00385,
	0x820, 0x00000000,
	0x824, 0x00030FE0,
	0x828, 0x00000000,
	0x82C, 0x002081DD,
	0x830, 0x2AAAEEC8,
	0x834, 0x0037A706,
	0x838, 0x06489B44,
	0x83C, 0x0000095B,
	0x840, 0xC0000001,
	0x844, 0x40003CDE,
	0x848, 0x62103F8B,
	0x84C, 0x6CFDFFB8,
	0x850, 0x28874706,
	0x854, 0x0001520C,
	0x858, 0x8060E000,
	0x85C, 0x74210168,
	0x860, 0x6929C321,
	0x864, 0x79727432,
	0x868, 0x8CA7A314,
	0x86C, 0x888C2878,
	0x870, 0x08888888,
	0x874, 0x31612C2E,
	0x878, 0x00000152,
	0x87C, 0x000FD000,
	0x8A0, 0x00000013,
	0x8A4, 0x7F7F7F7F,
	0x8A8, 0xA2000338,
	0x8AC, 0x0FF0FA0A,
	0x8B4, 0x000FC080,
	0x8B8, 0x6C10D7FF,
	0x8BC, 0x0CA52090,
	0x8C0, 0x1BF00020,
	0x8C4, 0x00000000,
	0x8C8, 0x00013169,
	0x8CC, 0x08248492,
	0x8D4, 0x940008A0,
	0x8D8, 0x290B5612,
	0x8F8, 0x400002C0,
	0x8FC, 0x00000000,
	0x900, 0x00000700,
	0x90C, 0x00000000,
	0x910, 0x0000FC00,
	0x914, 0x00000404,
	0x918, 0x1C1028C0,
	0x91C, 0x64B11A1C,
	0x920, 0xE0767233,
	0x924, 0x055AA500,
	0x928, 0x00000004,
	0x92C, 0xFFFE0000,
	0x930, 0xFFFFFFFE,
	0x934, 0x001FFFFF,
	0x960, 0x00000000,
	0x964, 0x00000000,
	0x968, 0x00000000,
	0x96C, 0x00000000,
	0x970, 0x801FFFFF,
	0x974, 0x000003FF,
	0x978, 0x00000000,
	0x97C, 0x00000000,
	0x980, 0x00000000,
	0x984, 0x00000000,
	0x988, 0x00000000,
	0x990, 0x27100000,
	0x994, 0xFFFF0100,
	0x998, 0xFFFFFF5C,
	0x99C, 0xFFFFFFFF,
	0x9A0, 0x000000FF,
	0x9A4, 0x00480080,
	0x9A8, 0x00000000,
	0x9AC, 0x00000000,
	0x9B0, 0x81081008,
	0x9B4, 0x01081008,
	0x9B8, 0x01081008,
	0x9BC, 0x01081008,
	0x9D0, 0x00000000,
	0x9D4, 0x00000000,
	0x9D8, 0x00000000,
	0x9DC, 0x00000000,
	0x9E0, 0x00005D00,
	0x9E4, 0x00000003,
	0x9E8, 0x00000001,
	0xA00, 0x00D047C8,
	0xA04, 0x01FF800C,
	0xA08, 0x8C8A8300,
	0xA0C, 0x2E68000F,
	0xA10, 0x9500BB78,
	0xA14, 0x11144028,
	0xA18, 0x00881117,
	0xA1C, 0x89140F00,
	0xA20, 0x1A1B0000,
	0xA24, 0x090E1317,
	0xA28, 0x00000204,
	0xA2C, 0x00900000,
	0xA70, 0x101FFF00,
	0xA74, 0x00000008,
	0xA78, 0x00000900,
	0xA7C, 0x225B0606,
	0xA80, 0x21805490,
	0xA84, 0x001F0000,
	0XB00, 0x03100040,
	0XB04, 0x0000B000,
	0XB08, 0xAE0201EB,
	0XB0C, 0x01003207,
	0XB10, 0x00009807,
	0XB14, 0x01000000,
	0XB18, 0x00000002,
	0XB1C, 0x00000002,
	0XB20, 0x0000001F,
	0XB24, 0x03020100,
	0XB28, 0x07060504,
	0XB2C, 0x0B0A0908,
	0XB30, 0x0F0E0D0C,
	0XB34, 0x13121110,
	0XB38, 0x17161514,
	0XB3C, 0x0000003A,
	0XB40, 0x00000000,
	0XB44, 0x00000000,
	0XB48, 0x13000032,
	0XB4C, 0x48080000,
	0XB50, 0x00000000,
	0XB54, 0x00000000,
	0XB58, 0x00000000,
	0XB5C, 0x00000000,
	0xC00, 0x00000007,
	0xC04, 0x00042020,
	0xC08, 0x80410231,
	0xC0C, 0x00000000,
	0xC10, 0x00000100,
	0xC14, 0x01000000,
	0xC1C, 0x40000003,
	0xC20, 0x2C2C2C2C,
	0xC24, 0x30303030,
	0xC28, 0x30303030,
	0xC2C, 0x2C2C2C2C,
	0xC30, 0x2C2C2C2C,
	0xC34, 0x2C2C2C2C,
	0xC38, 0x2C2C2C2C,
	0xC3C, 0x2A2A2A2A,
	0xC40, 0x2A2A2A2A,
	0xC44, 0x2A2A2A2A,
	0xC48, 0x2A2A2A2A,
	0xC4C, 0x2A2A2A2A,
	0xC50, 0x00000020,
	0xC54, 0x001C1208,
	0xC58, 0x30000C1C,
	0xC5C, 0x00000058,
	0xC60, 0x34344443,
	0xC64, 0x07003333,
	0xC68, 0x19791979,
	0xC6C, 0x19791979,
	0xC70, 0x19791979,
	0xC74, 0x19791979,
	0xC78, 0x19791979,
	0xC7C, 0x19791979,
	0xC80, 0x19791979,
	0xC84, 0x19791979,
	0xC94, 0x0100005C,
	0xC98, 0x00000000,
	0xC9C, 0x00000000,
	0xCA0, 0x00000029,
	0xCA4, 0x08040201,
	0xCA8, 0x80402010,
	0xCB0, 0x77775747,
	0xCB4, 0x10000077,
	0xCB8, 0x00508240,
};

RTW_DECL_TABLE_PHY_COND(rtw8821a_bb, rtw_phy_cfg_bb);

static const struct rtw_phy_pg_cfg_pair rtw8821a_bb_pg[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x36363838, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363838, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x32343636, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x24262830, },
	{ 0, 0, 0, 0x00000c44, 0x0000ffff, 0x00002022, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x34343636, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343636, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343636, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830, },
	{ 1, 0, 0, 0x00000c44, 0x0000ffff, 0x00002022, },
};

RTW_DECL_TABLE_BB_PG(rtw8821a_bb_pg);

static const u32 rtw8821a_rf_a[] = {
	0x018, 0x0001712A,
	0x056, 0x00051CF2,
	0x066, 0x00040000,
	0x000, 0x00010000,
	0x01E, 0x00080000,
	0x082, 0x00000830,
	0x083, 0x00021800,
	0x084, 0x00028000,
	0x085, 0x00048000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x086, 0x0009483A,
	0xA0000000,	0x00000000,
	0x086, 0x00094838,
	0xB0000000,	0x00000000,
	0x087, 0x00044980,
	0x088, 0x00048000,
	0x089, 0x0000D480,
	0x08A, 0x00042240,
	0x08B, 0x000F0380,
	0x08C, 0x00090000,
	0x08D, 0x00022852,
	0x08E, 0x00065540,
	0x08F, 0x00088001,
	0x0EF, 0x00020000,
	0x03E, 0x00000380,
	0x03F, 0x00090018,
	0x03E, 0x00020380,
	0x03F, 0x000A0018,
	0x03E, 0x00040308,
	0x03F, 0x000A0018,
	0x03E, 0x00060018,
	0x03F, 0x000A0018,
	0x0EF, 0x00000000,
	0x018, 0x0001712A,
	0x089, 0x00000080,
	0x08B, 0x00080180,
	0x0EF, 0x00001000,
	0x03A, 0x00000244,
	0x03B, 0x00038027,
	0x03C, 0x00082000,
	0x03A, 0x00000244,
	0x03B, 0x00030113,
	0x03C, 0x00082000,
	0x03A, 0x0000014C,
	0x03B, 0x00028027,
	0x03C, 0x00082000,
	0x03A, 0x000000CC,
	0x03B, 0x00027027,
	0x03C, 0x00042000,
	0x03A, 0x0000014C,
	0x03B, 0x0001F913,
	0x03C, 0x00042000,
	0x03A, 0x0000010C,
	0x03B, 0x00017F10,
	0x03C, 0x00012000,
	0x03A, 0x000000D0,
	0x03B, 0x00008027,
	0x03C, 0x000CA000,
	0x03A, 0x00000244,
	0x03B, 0x00078027,
	0x03C, 0x00082000,
	0x03A, 0x00000244,
	0x03B, 0x00070113,
	0x03C, 0x00082000,
	0x03A, 0x0000014C,
	0x03B, 0x00068027,
	0x03C, 0x00082000,
	0x03A, 0x000000CC,
	0x03B, 0x00067027,
	0x03C, 0x00042000,
	0x03A, 0x0000014C,
	0x03B, 0x0005F913,
	0x03C, 0x00042000,
	0x03A, 0x0000010C,
	0x03B, 0x00057F10,
	0x03C, 0x00012000,
	0x03A, 0x000000D0,
	0x03B, 0x00048027,
	0x03C, 0x000CA000,
	0x03A, 0x00000244,
	0x03B, 0x000B8027,
	0x03C, 0x00082000,
	0x03A, 0x00000244,
	0x03B, 0x000B0113,
	0x03C, 0x00082000,
	0x03A, 0x0000014C,
	0x03B, 0x000A8027,
	0x03C, 0x00082000,
	0x03A, 0x000000CC,
	0x03B, 0x000A7027,
	0x03C, 0x00042000,
	0x03A, 0x0000014C,
	0x03B, 0x0009F913,
	0x03C, 0x00042000,
	0x03A, 0x0000010C,
	0x03B, 0x00097F10,
	0x03C, 0x00012000,
	0x03A, 0x000000D0,
	0x03B, 0x00088027,
	0x03C, 0x000CA000,
	0x0EF, 0x00000000,
	0x0EF, 0x00001100,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004ADF3,
	0x034, 0x00049DF0,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004ADF3,
	0x034, 0x00049DF0,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004ADF5,
	0x034, 0x00049DF2,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004A0F3,
	0x034, 0x000490B1,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004A0F3,
	0x034, 0x000490B1,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004ADF5,
	0x034, 0x00049DF2,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004ADF3,
	0x034, 0x00049DF0,
	0xA0000000,	0x00000000,
	0x034, 0x0004ADF7,
	0x034, 0x00049DF3,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00048DED,
	0x034, 0x00047DEA,
	0x034, 0x00046DE7,
	0x034, 0x00045CE9,
	0x034, 0x00044CE6,
	0x034, 0x000438C6,
	0x034, 0x00042886,
	0x034, 0x00041486,
	0x034, 0x00040447,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00048DED,
	0x034, 0x00047DEA,
	0x034, 0x00046DE7,
	0x034, 0x00045CE9,
	0x034, 0x00044CE6,
	0x034, 0x000438C6,
	0x034, 0x00042886,
	0x034, 0x00041486,
	0x034, 0x00040447,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x000480AE,
	0x034, 0x000470AB,
	0x034, 0x0004608B,
	0x034, 0x00045069,
	0x034, 0x00044048,
	0x034, 0x00043045,
	0x034, 0x00042026,
	0x034, 0x00041023,
	0x034, 0x00040002,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x000480AE,
	0x034, 0x000470AB,
	0x034, 0x0004608B,
	0x034, 0x00045069,
	0x034, 0x00044048,
	0x034, 0x00043045,
	0x034, 0x00042026,
	0x034, 0x00041023,
	0x034, 0x00040002,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00048DED,
	0x034, 0x00047DEA,
	0x034, 0x00046DE7,
	0x034, 0x00045CE9,
	0x034, 0x00044CE6,
	0x034, 0x000438C6,
	0x034, 0x00042886,
	0x034, 0x00041486,
	0x034, 0x00040447,
	0xA0000000,	0x00000000,
	0x034, 0x00048DEF,
	0x034, 0x00047DEC,
	0x034, 0x00046DE9,
	0x034, 0x00045CCB,
	0x034, 0x0004488D,
	0x034, 0x0004348D,
	0x034, 0x0004248A,
	0x034, 0x0004108D,
	0x034, 0x0004008A,
	0xB0000000,	0x00000000,
	0x80000210,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0002ADF4,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0002A0F3,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0002A0F3,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0002ADF4,
	0xA0000000,	0x00000000,
	0x034, 0x0002ADF7,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00029DF4,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00029DF4,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00029DF1,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x000290F0,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x000290F0,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00029DF1,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00029DF4,
	0xA0000000,	0x00000000,
	0x034, 0x00029DF2,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00028DF1,
	0x034, 0x00027DEE,
	0x034, 0x00026DEB,
	0x034, 0x00025CEC,
	0x034, 0x00024CE9,
	0x034, 0x000238CA,
	0x034, 0x00022889,
	0x034, 0x00021489,
	0x034, 0x0002044A,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00028DF1,
	0x034, 0x00027DEE,
	0x034, 0x00026DEB,
	0x034, 0x00025CEC,
	0x034, 0x00024CE9,
	0x034, 0x000238CA,
	0x034, 0x00022889,
	0x034, 0x00021489,
	0x034, 0x0002044A,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x000280AF,
	0x034, 0x000270AC,
	0x034, 0x0002608B,
	0x034, 0x00025069,
	0x034, 0x00024048,
	0x034, 0x00023045,
	0x034, 0x00022026,
	0x034, 0x00021023,
	0x034, 0x00020002,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x000280AF,
	0x034, 0x000270AC,
	0x034, 0x0002608B,
	0x034, 0x00025069,
	0x034, 0x00024048,
	0x034, 0x00023045,
	0x034, 0x00022026,
	0x034, 0x00021023,
	0x034, 0x00020002,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00028DF1,
	0x034, 0x00027DEE,
	0x034, 0x00026DEB,
	0x034, 0x00025CEC,
	0x034, 0x00024CE9,
	0x034, 0x000238CA,
	0x034, 0x00022889,
	0x034, 0x00021489,
	0x034, 0x0002044A,
	0xA0000000,	0x00000000,
	0x034, 0x00028DEE,
	0x034, 0x00027DEB,
	0x034, 0x00026CCD,
	0x034, 0x00025CCA,
	0x034, 0x0002488C,
	0x034, 0x0002384C,
	0x034, 0x00022849,
	0x034, 0x00021449,
	0x034, 0x0002004D,
	0xB0000000,	0x00000000,
	0x8000020c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000A0D7,
	0x034, 0x000090D3,
	0x034, 0x000080B1,
	0x034, 0x000070AE,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000A0D7,
	0x034, 0x000090D3,
	0x034, 0x000080B1,
	0x034, 0x000070AE,
	0xA0000000,	0x00000000,
	0x034, 0x0000ADF7,
	0x034, 0x00009DF4,
	0x034, 0x00008DF1,
	0x034, 0x00007DEE,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00006DEB,
	0x034, 0x00005CEC,
	0x034, 0x00004CE9,
	0x034, 0x000038CA,
	0x034, 0x00002889,
	0x034, 0x00001489,
	0x034, 0x0000044A,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00006DEB,
	0x034, 0x00005CEC,
	0x034, 0x00004CE9,
	0x034, 0x000038CA,
	0x034, 0x00002889,
	0x034, 0x00001489,
	0x034, 0x0000044A,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000608D,
	0x034, 0x0000506B,
	0x034, 0x0000404A,
	0x034, 0x00003047,
	0x034, 0x00002044,
	0x034, 0x00001025,
	0x034, 0x00000004,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000608D,
	0x034, 0x0000506B,
	0x034, 0x0000404A,
	0x034, 0x00003047,
	0x034, 0x00002044,
	0x034, 0x00001025,
	0x034, 0x00000004,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x00006DEB,
	0x034, 0x00005CEC,
	0x034, 0x00004CE9,
	0x034, 0x000038CA,
	0x034, 0x00002889,
	0x034, 0x00001489,
	0x034, 0x0000044A,
	0xA0000000,	0x00000000,
	0x034, 0x00006DCD,
	0x034, 0x00005CCD,
	0x034, 0x00004CCA,
	0x034, 0x0000388C,
	0x034, 0x00002888,
	0x034, 0x00001488,
	0x034, 0x00000486,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000040,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x035, 0x00000187,
	0x035, 0x00008187,
	0x035, 0x00010187,
	0x035, 0x00020188,
	0x035, 0x00028188,
	0x035, 0x00030188,
	0x035, 0x00040188,
	0x035, 0x00048188,
	0x035, 0x00050188,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x035, 0x00000187,
	0x035, 0x00008187,
	0x035, 0x00010187,
	0x035, 0x00020188,
	0x035, 0x00028188,
	0x035, 0x00030188,
	0x035, 0x00040188,
	0x035, 0x00048188,
	0x035, 0x00050188,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x035, 0x00000128,
	0x035, 0x00008128,
	0x035, 0x00010128,
	0x035, 0x000201C8,
	0x035, 0x000281C8,
	0x035, 0x000301C8,
	0x035, 0x000401C8,
	0x035, 0x000481C8,
	0x035, 0x000501C8,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x035, 0x00000145,
	0x035, 0x00008145,
	0x035, 0x00010145,
	0x035, 0x00020196,
	0x035, 0x00028196,
	0x035, 0x00030196,
	0x035, 0x000401C7,
	0x035, 0x000481C7,
	0x035, 0x000501C7,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x035, 0x00000128,
	0x035, 0x00008128,
	0x035, 0x00010128,
	0x035, 0x000201C8,
	0x035, 0x000281C8,
	0x035, 0x000301C8,
	0x035, 0x000401C8,
	0x035, 0x000481C8,
	0x035, 0x000501C8,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x035, 0x00000187,
	0x035, 0x00008187,
	0x035, 0x00010187,
	0x035, 0x00020188,
	0x035, 0x00028188,
	0x035, 0x00030188,
	0x035, 0x00040188,
	0x035, 0x00048188,
	0x035, 0x00050188,
	0xA0000000,	0x00000000,
	0x035, 0x00000145,
	0x035, 0x00008145,
	0x035, 0x00010145,
	0x035, 0x00020196,
	0x035, 0x00028196,
	0x035, 0x00030196,
	0x035, 0x000401C7,
	0x035, 0x000481C7,
	0x035, 0x000501C7,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000010,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x036, 0x00085733,
	0x036, 0x0008D733,
	0x036, 0x00095733,
	0x036, 0x0009D733,
	0x036, 0x000A64B4,
	0x036, 0x000AE4B4,
	0x036, 0x000B64B4,
	0x036, 0x000BE4B4,
	0x036, 0x000C64B4,
	0x036, 0x000CE4B4,
	0x036, 0x000D64B4,
	0x036, 0x000DE4B4,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x036, 0x00085733,
	0x036, 0x0008D733,
	0x036, 0x00095733,
	0x036, 0x0009D733,
	0x036, 0x000A64B4,
	0x036, 0x000AE4B4,
	0x036, 0x000B64B4,
	0x036, 0x000BE4B4,
	0x036, 0x000C64B4,
	0x036, 0x000CE4B4,
	0x036, 0x000D64B4,
	0x036, 0x000DE4B4,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x036, 0x000063B5,
	0x036, 0x0000E3B5,
	0x036, 0x000163B5,
	0x036, 0x0001E3B5,
	0x036, 0x000263B5,
	0x036, 0x0002E3B5,
	0x036, 0x000363B5,
	0x036, 0x0003E3B5,
	0x036, 0x000463B5,
	0x036, 0x0004E3B5,
	0x036, 0x000563B5,
	0x036, 0x0005E3B5,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x036, 0x000056B3,
	0x036, 0x0000D6B3,
	0x036, 0x000156B3,
	0x036, 0x0001D6B3,
	0x036, 0x00026634,
	0x036, 0x0002E634,
	0x036, 0x00036634,
	0x036, 0x0003E634,
	0x036, 0x000467B4,
	0x036, 0x0004E7B4,
	0x036, 0x000567B4,
	0x036, 0x0005E7B4,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x036, 0x000063B5,
	0x036, 0x0000E3B5,
	0x036, 0x000163B5,
	0x036, 0x0001E3B5,
	0x036, 0x000263B5,
	0x036, 0x0002E3B5,
	0x036, 0x000363B5,
	0x036, 0x0003E3B5,
	0x036, 0x000463B5,
	0x036, 0x0004E3B5,
	0x036, 0x000563B5,
	0x036, 0x0005E3B5,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x036, 0x00085733,
	0x036, 0x0008D733,
	0x036, 0x00095733,
	0x036, 0x0009D733,
	0x036, 0x000A64B4,
	0x036, 0x000AE4B4,
	0x036, 0x000B64B4,
	0x036, 0x000BE4B4,
	0x036, 0x000C64B4,
	0x036, 0x000CE4B4,
	0x036, 0x000D64B4,
	0x036, 0x000DE4B4,
	0xA0000000,	0x00000000,
	0x036, 0x000056B3,
	0x036, 0x0000D6B3,
	0x036, 0x000156B3,
	0x036, 0x0001D6B3,
	0x036, 0x00026634,
	0x036, 0x0002E634,
	0x036, 0x00036634,
	0x036, 0x0003E634,
	0x036, 0x000467B4,
	0x036, 0x0004E7B4,
	0x036, 0x000567B4,
	0x036, 0x0005E7B4,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x0EF, 0x00000008,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x000001C8,
	0x03C, 0x00000492,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x000001C8,
	0x03C, 0x00000492,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x000001B6,
	0x03C, 0x00000492,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x0000022A,
	0x03C, 0x00000594,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x000001B6,
	0x03C, 0x00000492,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x000001C8,
	0x03C, 0x00000492,
	0xA0000000,	0x00000000,
	0x03C, 0x0000022A,
	0x03C, 0x00000594,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x00000800,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x00000800,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x00000800,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x00000820,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x00000820,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x00000800,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x00000800,
	0xA0000000,	0x00000000,
	0x03C, 0x00000900,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000002,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x008, 0x0004E400,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x008, 0x0004E400,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x008, 0x00002000,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x008, 0x00002000,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x008, 0x00002000,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x008, 0x00002000,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x008, 0x0004E400,
	0xA0000000,	0x00000000,
	0x008, 0x00002000,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x0DF, 0x000000C0,
	0x01F, 0x00000064,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x058, 0x000A7284,
	0x059, 0x000600EC,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x058, 0x000A7284,
	0x059, 0x000600EC,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x058, 0x00081184,
	0x059, 0x0006016C,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x058, 0x00081184,
	0x059, 0x0006016C,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x058, 0x00081184,
	0x059, 0x0006016C,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x058, 0x000A7284,
	0x059, 0x000600EC,
	0xA0000000,	0x00000000,
	0x058, 0x00081184,
	0x059, 0x0006016C,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000E8D73,
	0x062, 0x00093FC5,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000E8D73,
	0x062, 0x00093FC5,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000EFD83,
	0x062, 0x00093FCC,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000EAD53,
	0x062, 0x00093BC4,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000EFD83,
	0x062, 0x00093FCC,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000E8D73,
	0x062, 0x00093FC5,
	0xA0000000,	0x00000000,
	0x061, 0x000EAD53,
	0x062, 0x00093BC4,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x063, 0x000110E9,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x063, 0x000110E9,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x063, 0x000110EB,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x063, 0x000110E9,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x063, 0x000110E9,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x063, 0x000110EB,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x063, 0x000110E9,
	0xA0000000,	0x00000000,
	0x063, 0x000714E9,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x064, 0x0001C27C,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x064, 0x0001C27C,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x064, 0x0001C27C,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x064, 0x0001C67C,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x064, 0x0001C27C,
	0x90000410,	0x00000000,	0x40000000,	0x00000000,
	0x064, 0x0001C27C,
	0xA0000000,	0x00000000,
	0x064, 0x0001C67C,
	0xB0000000,	0x00000000,
	0x80000111,	0x00000000,	0x40000000,	0x00000000,
	0x065, 0x00091016,
	0x90000110,	0x00000000,	0x40000000,	0x00000000,
	0x065, 0x00091016,
	0x90000210,	0x00000000,	0x40000000,	0x00000000,
	0x065, 0x00093016,
	0x9000020c,	0x00000000,	0x40000000,	0x00000000,
	0x065, 0x00093015,
	0x9000040c,	0x00000000,	0x40000000,	0x00000000,
	0x065, 0x00093015,
	0x90000200,	0x00000000,	0x40000000,	0x00000000,
	0x065, 0x00093016,
	0xA0000000,	0x00000000,
	0x065, 0x00091016,
	0xB0000000,	0x00000000,
	0x018, 0x00000006,
	0x0EF, 0x00002000,
	0x03B, 0x0003824B,
	0x03B, 0x0003024B,
	0x03B, 0x0002844B,
	0x03B, 0x00020F4B,
	0x03B, 0x00018F4B,
	0x03B, 0x000104B2,
	0x03B, 0x00008049,
	0x03B, 0x00000148,
	0x03B, 0x0007824B,
	0x03B, 0x0007024B,
	0x03B, 0x0006824B,
	0x03B, 0x00060F4B,
	0x03B, 0x00058F4B,
	0x03B, 0x000504B2,
	0x03B, 0x00048049,
	0x03B, 0x00040148,
	0x0EF, 0x00000000,
	0x0EF, 0x00000100,
	0x034, 0x0000ADF3,
	0x034, 0x00009DF0,
	0x034, 0x00008D70,
	0x034, 0x00007D6D,
	0x034, 0x00006CEE,
	0x034, 0x00005CCC,
	0x034, 0x000044EC,
	0x034, 0x000034AC,
	0x034, 0x0000246D,
	0x034, 0x0000106F,
	0x034, 0x0000006C,
	0x0EF, 0x00000000,
	0x0ED, 0x00000010,
	0x044, 0x0000ADF2,
	0x044, 0x00009DEF,
	0x044, 0x00008DEC,
	0x044, 0x00007DE9,
	0x044, 0x00006CEC,
	0x044, 0x00005CE9,
	0x044, 0x000044EC,
	0x044, 0x000034E9,
	0x044, 0x0000246C,
	0x044, 0x00001469,
	0x044, 0x0000006C,
	0x0ED, 0x00000000,
	0x0ED, 0x00000001,
	0x040, 0x00038DA7,
	0x040, 0x000300C2,
	0x040, 0x000288E2,
	0x040, 0x000200B8,
	0x040, 0x000188A5,
	0x040, 0x00010FBC,
	0x040, 0x00008F71,
	0x040, 0x00000240,
	0x0ED, 0x00000000,
	0x0EF, 0x000020A2,
	0x0DF, 0x00000080,
	0x035, 0x00000120,
	0x035, 0x00008120,
	0x035, 0x00010120,
	0x036, 0x00000085,
	0x036, 0x00008085,
	0x036, 0x00010085,
	0x036, 0x00018085,
	0x0EF, 0x00000000,
	0x051, 0x00000C31,
	0x052, 0x00000622,
	0x053, 0x000FC70B,
	0x054, 0x0000017E,
	0x056, 0x00051DF3,
	0x051, 0x00000C01,
	0x052, 0x000006D6,
	0x053, 0x000FC649,
	0x070, 0x00049661,
	0x071, 0x0007843E,
	0x072, 0x00000382,
	0x074, 0x00051400,
	0x035, 0x00000160,
	0x035, 0x00008160,
	0x035, 0x00010160,
	0x036, 0x00000124,
	0x036, 0x00008124,
	0x036, 0x00010124,
	0x036, 0x00018124,
	0x0ED, 0x0000000C,
	0x045, 0x00000140,
	0x045, 0x00008140,
	0x045, 0x00010140,
	0x046, 0x00000124,
	0x046, 0x00008124,
	0x046, 0x00010124,
	0x046, 0x00018124,
	0x0DF, 0x00000088,
	0x0B3, 0x000F0E18,
	0x0B4, 0x0001214C,
	0x0B7, 0x0003000C,
	0x01C, 0x000539D2,
	0x0C4, 0x000AFE00,
	0x018, 0x0001F12A,
	0xFFE, 0x00000000,
	0xFFE, 0x00000000,
	0x018, 0x0001712A,
};

RTW_DECL_TABLE_RF_RADIO(rtw8821a_rf_a, A);

static const struct rtw_txpwr_lmt_cfg_pair rtw8821a_txpwr_lmt[] = {
	{ 0, 0, 0, 0, 1, 32, },
	{ 2, 0, 0, 0, 1, 28, },
	{ 1, 0, 0, 0, 1, 32, },
	{ 0, 0, 0, 0, 2, 32, },
	{ 2, 0, 0, 0, 2, 28, },
	{ 1, 0, 0, 0, 2, 32, },
	{ 0, 0, 0, 0, 3, 36, },
	{ 2, 0, 0, 0, 3, 28, },
	{ 1, 0, 0, 0, 3, 32, },
	{ 0, 0, 0, 0, 4, 36, },
	{ 2, 0, 0, 0, 4, 28, },
	{ 1, 0, 0, 0, 4, 32, },
	{ 0, 0, 0, 0, 5, 36, },
	{ 2, 0, 0, 0, 5, 28, },
	{ 1, 0, 0, 0, 5, 32, },
	{ 0, 0, 0, 0, 6, 36, },
	{ 2, 0, 0, 0, 6, 28, },
	{ 1, 0, 0, 0, 6, 32, },
	{ 0, 0, 0, 0, 7, 36, },
	{ 2, 0, 0, 0, 7, 28, },
	{ 1, 0, 0, 0, 7, 32, },
	{ 0, 0, 0, 0, 8, 36, },
	{ 2, 0, 0, 0, 8, 28, },
	{ 1, 0, 0, 0, 8, 32, },
	{ 0, 0, 0, 0, 9, 32, },
	{ 2, 0, 0, 0, 9, 28, },
	{ 1, 0, 0, 0, 9, 32, },
	{ 0, 0, 0, 0, 10, 32, },
	{ 2, 0, 0, 0, 10, 28, },
	{ 1, 0, 0, 0, 10, 32, },
	{ 0, 0, 0, 0, 11, 32, },
	{ 2, 0, 0, 0, 11, 28, },
	{ 1, 0, 0, 0, 11, 32, },
	{ 0, 0, 0, 0, 12, 28, },
	{ 2, 0, 0, 0, 12, 28, },
	{ 1, 0, 0, 0, 12, 32, },
	{ 0, 0, 0, 0, 13, 26, },
	{ 2, 0, 0, 0, 13, 28, },
	{ 1, 0, 0, 0, 13, 32, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 32, },
	{ 0, 0, 0, 1, 1, 30, },
	{ 2, 0, 0, 1, 1, 30, },
	{ 1, 0, 0, 1, 1, 32, },
	{ 0, 0, 0, 1, 2, 30, },
	{ 2, 0, 0, 1, 2, 32, },
	{ 1, 0, 0, 1, 2, 32, },
	{ 0, 0, 0, 1, 3, 32, },
	{ 2, 0, 0, 1, 3, 32, },
	{ 1, 0, 0, 1, 3, 32, },
	{ 0, 0, 0, 1, 4, 32, },
	{ 2, 0, 0, 1, 4, 32, },
	{ 1, 0, 0, 1, 4, 32, },
	{ 0, 0, 0, 1, 5, 32, },
	{ 2, 0, 0, 1, 5, 32, },
	{ 1, 0, 0, 1, 5, 32, },
	{ 0, 0, 0, 1, 6, 32, },
	{ 2, 0, 0, 1, 6, 32, },
	{ 1, 0, 0, 1, 6, 32, },
	{ 0, 0, 0, 1, 7, 32, },
	{ 2, 0, 0, 1, 7, 32, },
	{ 1, 0, 0, 1, 7, 32, },
	{ 0, 0, 0, 1, 8, 32, },
	{ 2, 0, 0, 1, 8, 32, },
	{ 1, 0, 0, 1, 8, 32, },
	{ 0, 0, 0, 1, 9, 30, },
	{ 2, 0, 0, 1, 9, 32, },
	{ 1, 0, 0, 1, 9, 32, },
	{ 0, 0, 0, 1, 10, 30, },
	{ 2, 0, 0, 1, 10, 32, },
	{ 1, 0, 0, 1, 10, 32, },
	{ 0, 0, 0, 1, 11, 30, },
	{ 2, 0, 0, 1, 11, 32, },
	{ 1, 0, 0, 1, 11, 32, },
	{ 0, 0, 0, 1, 12, 26, },
	{ 2, 0, 0, 1, 12, 32, },
	{ 1, 0, 0, 1, 12, 32, },
	{ 0, 0, 0, 1, 13, 24, },
	{ 2, 0, 0, 1, 13, 30, },
	{ 1, 0, 0, 1, 13, 32, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 26, },
	{ 2, 0, 0, 2, 1, 26, },
	{ 1, 0, 0, 2, 1, 32, },
	{ 0, 0, 0, 2, 2, 26, },
	{ 2, 0, 0, 2, 2, 32, },
	{ 1, 0, 0, 2, 2, 32, },
	{ 0, 0, 0, 2, 3, 32, },
	{ 2, 0, 0, 2, 3, 32, },
	{ 1, 0, 0, 2, 3, 32, },
	{ 0, 0, 0, 2, 4, 32, },
	{ 2, 0, 0, 2, 4, 32, },
	{ 1, 0, 0, 2, 4, 32, },
	{ 0, 0, 0, 2, 5, 32, },
	{ 2, 0, 0, 2, 5, 32, },
	{ 1, 0, 0, 2, 5, 32, },
	{ 0, 0, 0, 2, 6, 32, },
	{ 2, 0, 0, 2, 6, 32, },
	{ 1, 0, 0, 2, 6, 32, },
	{ 0, 0, 0, 2, 7, 32, },
	{ 2, 0, 0, 2, 7, 32, },
	{ 1, 0, 0, 2, 7, 32, },
	{ 0, 0, 0, 2, 8, 32, },
	{ 2, 0, 0, 2, 8, 32, },
	{ 1, 0, 0, 2, 8, 32, },
	{ 0, 0, 0, 2, 9, 26, },
	{ 2, 0, 0, 2, 9, 32, },
	{ 1, 0, 0, 2, 9, 32, },
	{ 0, 0, 0, 2, 10, 26, },
	{ 2, 0, 0, 2, 10, 32, },
	{ 1, 0, 0, 2, 10, 32, },
	{ 0, 0, 0, 2, 11, 26, },
	{ 2, 0, 0, 2, 11, 32, },
	{ 1, 0, 0, 2, 11, 32, },
	{ 0, 0, 0, 2, 12, 26, },
	{ 2, 0, 0, 2, 12, 32, },
	{ 1, 0, 0, 2, 12, 32, },
	{ 0, 0, 0, 2, 13, 24, },
	{ 2, 0, 0, 2, 13, 26, },
	{ 1, 0, 0, 2, 13, 32, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 30, },
	{ 2, 0, 0, 3, 1, 32, },
	{ 1, 0, 0, 3, 1, 32, },
	{ 0, 0, 0, 3, 2, 32, },
	{ 2, 0, 0, 3, 2, 32, },
	{ 1, 0, 0, 3, 2, 32, },
	{ 0, 0, 0, 3, 3, 32, },
	{ 2, 0, 0, 3, 3, 32, },
	{ 1, 0, 0, 3, 3, 32, },
	{ 0, 0, 0, 3, 4, 32, },
	{ 2, 0, 0, 3, 4, 32, },
	{ 1, 0, 0, 3, 4, 32, },
	{ 0, 0, 0, 3, 5, 32, },
	{ 2, 0, 0, 3, 5, 32, },
	{ 1, 0, 0, 3, 5, 32, },
	{ 0, 0, 0, 3, 6, 32, },
	{ 2, 0, 0, 3, 6, 32, },
	{ 1, 0, 0, 3, 6, 32, },
	{ 0, 0, 0, 3, 7, 32, },
	{ 2, 0, 0, 3, 7, 32, },
	{ 1, 0, 0, 3, 7, 32, },
	{ 0, 0, 0, 3, 8, 32, },
	{ 2, 0, 0, 3, 8, 32, },
	{ 1, 0, 0, 3, 8, 32, },
	{ 0, 0, 0, 3, 9, 32, },
	{ 2, 0, 0, 3, 9, 32, },
	{ 1, 0, 0, 3, 9, 32, },
	{ 0, 0, 0, 3, 10, 32, },
	{ 2, 0, 0, 3, 10, 32, },
	{ 1, 0, 0, 3, 10, 32, },
	{ 0, 0, 0, 3, 11, 30, },
	{ 2, 0, 0, 3, 11, 32, },
	{ 1, 0, 0, 3, 11, 32, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 32, },
	{ 1, 0, 0, 3, 12, 32, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 32, },
	{ 1, 0, 0, 3, 13, 32, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 26, },
	{ 2, 0, 1, 2, 3, 26, },
	{ 1, 0, 1, 2, 3, 32, },
	{ 0, 0, 1, 2, 4, 26, },
	{ 2, 0, 1, 2, 4, 32, },
	{ 1, 0, 1, 2, 4, 32, },
	{ 0, 0, 1, 2, 5, 26, },
	{ 2, 0, 1, 2, 5, 32, },
	{ 1, 0, 1, 2, 5, 32, },
	{ 0, 0, 1, 2, 6, 32, },
	{ 2, 0, 1, 2, 6, 32, },
	{ 1, 0, 1, 2, 6, 32, },
	{ 0, 0, 1, 2, 7, 32, },
	{ 2, 0, 1, 2, 7, 32, },
	{ 1, 0, 1, 2, 7, 32, },
	{ 0, 0, 1, 2, 8, 32, },
	{ 2, 0, 1, 2, 8, 32, },
	{ 1, 0, 1, 2, 8, 32, },
	{ 0, 0, 1, 2, 9, 26, },
	{ 2, 0, 1, 2, 9, 32, },
	{ 1, 0, 1, 2, 9, 32, },
	{ 0, 0, 1, 2, 10, 24, },
	{ 2, 0, 1, 2, 10, 32, },
	{ 1, 0, 1, 2, 10, 32, },
	{ 0, 0, 1, 2, 11, 22, },
	{ 2, 0, 1, 2, 11, 26, },
	{ 1, 0, 1, 2, 11, 32, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 63, },
	{ 1, 0, 1, 2, 12, 63, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 63, },
	{ 1, 0, 1, 2, 13, 63, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 30, },
	{ 2, 0, 1, 3, 3, 30, },
	{ 1, 0, 1, 3, 3, 30, },
	{ 0, 0, 1, 3, 4, 32, },
	{ 2, 0, 1, 3, 4, 30, },
	{ 1, 0, 1, 3, 4, 30, },
	{ 0, 0, 1, 3, 5, 32, },
	{ 2, 0, 1, 3, 5, 30, },
	{ 1, 0, 1, 3, 5, 30, },
	{ 0, 0, 1, 3, 6, 32, },
	{ 2, 0, 1, 3, 6, 30, },
	{ 1, 0, 1, 3, 6, 30, },
	{ 0, 0, 1, 3, 7, 32, },
	{ 2, 0, 1, 3, 7, 30, },
	{ 1, 0, 1, 3, 7, 30, },
	{ 0, 0, 1, 3, 8, 32, },
	{ 2, 0, 1, 3, 8, 30, },
	{ 1, 0, 1, 3, 8, 30, },
	{ 0, 0, 1, 3, 9, 32, },
	{ 2, 0, 1, 3, 9, 30, },
	{ 1, 0, 1, 3, 9, 30, },
	{ 0, 0, 1, 3, 10, 32, },
	{ 2, 0, 1, 3, 10, 30, },
	{ 1, 0, 1, 3, 10, 30, },
	{ 0, 0, 1, 3, 11, 30, },
	{ 2, 0, 1, 3, 11, 30, },
	{ 1, 0, 1, 3, 11, 30, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 32, },
	{ 1, 0, 1, 3, 12, 32, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 32, },
	{ 1, 0, 1, 3, 13, 32, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 1, 0, 1, 36, 32, },
	{ 2, 1, 0, 1, 36, 30, },
	{ 1, 1, 0, 1, 36, 30, },
	{ 0, 1, 0, 1, 40, 32, },
	{ 2, 1, 0, 1, 40, 30, },
	{ 1, 1, 0, 1, 40, 30, },
	{ 0, 1, 0, 1, 44, 32, },
	{ 2, 1, 0, 1, 44, 30, },
	{ 1, 1, 0, 1, 44, 30, },
	{ 0, 1, 0, 1, 48, 32, },
	{ 2, 1, 0, 1, 48, 30, },
	{ 1, 1, 0, 1, 48, 30, },
	{ 0, 1, 0, 1, 52, 32, },
	{ 2, 1, 0, 1, 52, 30, },
	{ 1, 1, 0, 1, 52, 30, },
	{ 0, 1, 0, 1, 56, 32, },
	{ 2, 1, 0, 1, 56, 30, },
	{ 1, 1, 0, 1, 56, 30, },
	{ 0, 1, 0, 1, 60, 32, },
	{ 2, 1, 0, 1, 60, 30, },
	{ 1, 1, 0, 1, 60, 30, },
	{ 0, 1, 0, 1, 64, 32, },
	{ 2, 1, 0, 1, 64, 30, },
	{ 1, 1, 0, 1, 64, 30, },
	{ 0, 1, 0, 1, 100, 32, },
	{ 2, 1, 0, 1, 100, 30, },
	{ 1, 1, 0, 1, 100, 30, },
	{ 0, 1, 0, 1, 104, 32, },
	{ 2, 1, 0, 1, 104, 30, },
	{ 1, 1, 0, 1, 104, 30, },
	{ 0, 1, 0, 1, 108, 32, },
	{ 2, 1, 0, 1, 108, 30, },
	{ 1, 1, 0, 1, 108, 30, },
	{ 0, 1, 0, 1, 112, 32, },
	{ 2, 1, 0, 1, 112, 30, },
	{ 1, 1, 0, 1, 112, 30, },
	{ 0, 1, 0, 1, 116, 32, },
	{ 2, 1, 0, 1, 116, 30, },
	{ 1, 1, 0, 1, 116, 30, },
	{ 0, 1, 0, 1, 120, 32, },
	{ 2, 1, 0, 1, 120, 30, },
	{ 1, 1, 0, 1, 120, 30, },
	{ 0, 1, 0, 1, 124, 32, },
	{ 2, 1, 0, 1, 124, 30, },
	{ 1, 1, 0, 1, 124, 30, },
	{ 0, 1, 0, 1, 128, 32, },
	{ 2, 1, 0, 1, 128, 30, },
	{ 1, 1, 0, 1, 128, 30, },
	{ 0, 1, 0, 1, 132, 32, },
	{ 2, 1, 0, 1, 132, 30, },
	{ 1, 1, 0, 1, 132, 30, },
	{ 0, 1, 0, 1, 136, 32, },
	{ 2, 1, 0, 1, 136, 30, },
	{ 1, 1, 0, 1, 136, 30, },
	{ 0, 1, 0, 1, 140, 32, },
	{ 2, 1, 0, 1, 140, 30, },
	{ 1, 1, 0, 1, 140, 30, },
	{ 0, 1, 0, 1, 149, 32, },
	{ 2, 1, 0, 1, 149, 30, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 32, },
	{ 2, 1, 0, 1, 153, 30, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 32, },
	{ 2, 1, 0, 1, 157, 30, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 32, },
	{ 2, 1, 0, 1, 161, 30, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 32, },
	{ 2, 1, 0, 1, 165, 30, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 32, },
	{ 2, 1, 0, 2, 36, 30, },
	{ 1, 1, 0, 2, 36, 30, },
	{ 0, 1, 0, 2, 40, 32, },
	{ 2, 1, 0, 2, 40, 30, },
	{ 1, 1, 0, 2, 40, 30, },
	{ 0, 1, 0, 2, 44, 32, },
	{ 2, 1, 0, 2, 44, 30, },
	{ 1, 1, 0, 2, 44, 30, },
	{ 0, 1, 0, 2, 48, 32, },
	{ 2, 1, 0, 2, 48, 30, },
	{ 1, 1, 0, 2, 48, 30, },
	{ 0, 1, 0, 2, 52, 32, },
	{ 2, 1, 0, 2, 52, 30, },
	{ 1, 1, 0, 2, 52, 30, },
	{ 0, 1, 0, 2, 56, 32, },
	{ 2, 1, 0, 2, 56, 30, },
	{ 1, 1, 0, 2, 56, 30, },
	{ 0, 1, 0, 2, 60, 32, },
	{ 2, 1, 0, 2, 60, 30, },
	{ 1, 1, 0, 2, 60, 30, },
	{ 0, 1, 0, 2, 64, 32, },
	{ 2, 1, 0, 2, 64, 30, },
	{ 1, 1, 0, 2, 64, 30, },
	{ 0, 1, 0, 2, 100, 32, },
	{ 2, 1, 0, 2, 100, 30, },
	{ 1, 1, 0, 2, 100, 30, },
	{ 0, 1, 0, 2, 104, 32, },
	{ 2, 1, 0, 2, 104, 30, },
	{ 1, 1, 0, 2, 104, 30, },
	{ 0, 1, 0, 2, 108, 32, },
	{ 2, 1, 0, 2, 108, 30, },
	{ 1, 1, 0, 2, 108, 30, },
	{ 0, 1, 0, 2, 112, 32, },
	{ 2, 1, 0, 2, 112, 30, },
	{ 1, 1, 0, 2, 112, 30, },
	{ 0, 1, 0, 2, 116, 32, },
	{ 2, 1, 0, 2, 116, 30, },
	{ 1, 1, 0, 2, 116, 30, },
	{ 0, 1, 0, 2, 120, 32, },
	{ 2, 1, 0, 2, 120, 30, },
	{ 1, 1, 0, 2, 120, 30, },
	{ 0, 1, 0, 2, 124, 32, },
	{ 2, 1, 0, 2, 124, 30, },
	{ 1, 1, 0, 2, 124, 30, },
	{ 0, 1, 0, 2, 128, 32, },
	{ 2, 1, 0, 2, 128, 30, },
	{ 1, 1, 0, 2, 128, 30, },
	{ 0, 1, 0, 2, 132, 32, },
	{ 2, 1, 0, 2, 132, 30, },
	{ 1, 1, 0, 2, 132, 30, },
	{ 0, 1, 0, 2, 136, 32, },
	{ 2, 1, 0, 2, 136, 30, },
	{ 1, 1, 0, 2, 136, 30, },
	{ 0, 1, 0, 2, 140, 32, },
	{ 2, 1, 0, 2, 140, 30, },
	{ 1, 1, 0, 2, 140, 30, },
	{ 0, 1, 0, 2, 149, 32, },
	{ 2, 1, 0, 2, 149, 30, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 32, },
	{ 2, 1, 0, 2, 153, 30, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 32, },
	{ 2, 1, 0, 2, 157, 30, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 32, },
	{ 2, 1, 0, 2, 161, 30, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 32, },
	{ 2, 1, 0, 2, 165, 30, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 28, },
	{ 2, 1, 0, 3, 36, 30, },
	{ 1, 1, 0, 3, 36, 30, },
	{ 0, 1, 0, 3, 40, 28, },
	{ 2, 1, 0, 3, 40, 30, },
	{ 1, 1, 0, 3, 40, 30, },
	{ 0, 1, 0, 3, 44, 28, },
	{ 2, 1, 0, 3, 44, 30, },
	{ 1, 1, 0, 3, 44, 30, },
	{ 0, 1, 0, 3, 48, 28, },
	{ 2, 1, 0, 3, 48, 30, },
	{ 1, 1, 0, 3, 48, 30, },
	{ 0, 1, 0, 3, 52, 34, },
	{ 2, 1, 0, 3, 52, 30, },
	{ 1, 1, 0, 3, 52, 30, },
	{ 0, 1, 0, 3, 56, 32, },
	{ 2, 1, 0, 3, 56, 30, },
	{ 1, 1, 0, 3, 56, 30, },
	{ 0, 1, 0, 3, 60, 30, },
	{ 2, 1, 0, 3, 60, 30, },
	{ 1, 1, 0, 3, 60, 30, },
	{ 0, 1, 0, 3, 64, 26, },
	{ 2, 1, 0, 3, 64, 30, },
	{ 1, 1, 0, 3, 64, 30, },
	{ 0, 1, 0, 3, 100, 28, },
	{ 2, 1, 0, 3, 100, 30, },
	{ 1, 1, 0, 3, 100, 30, },
	{ 0, 1, 0, 3, 104, 28, },
	{ 2, 1, 0, 3, 104, 30, },
	{ 1, 1, 0, 3, 104, 30, },
	{ 0, 1, 0, 3, 108, 30, },
	{ 2, 1, 0, 3, 108, 30, },
	{ 1, 1, 0, 3, 108, 30, },
	{ 0, 1, 0, 3, 112, 32, },
	{ 2, 1, 0, 3, 112, 30, },
	{ 1, 1, 0, 3, 112, 30, },
	{ 0, 1, 0, 3, 116, 32, },
	{ 2, 1, 0, 3, 116, 30, },
	{ 1, 1, 0, 3, 116, 30, },
	{ 0, 1, 0, 3, 120, 34, },
	{ 2, 1, 0, 3, 120, 30, },
	{ 1, 1, 0, 3, 120, 30, },
	{ 0, 1, 0, 3, 124, 32, },
	{ 2, 1, 0, 3, 124, 30, },
	{ 1, 1, 0, 3, 124, 30, },
	{ 0, 1, 0, 3, 128, 30, },
	{ 2, 1, 0, 3, 128, 30, },
	{ 1, 1, 0, 3, 128, 30, },
	{ 0, 1, 0, 3, 132, 28, },
	{ 2, 1, 0, 3, 132, 30, },
	{ 1, 1, 0, 3, 132, 30, },
	{ 0, 1, 0, 3, 136, 28, },
	{ 2, 1, 0, 3, 136, 30, },
	{ 1, 1, 0, 3, 136, 30, },
	{ 0, 1, 0, 3, 140, 26, },
	{ 2, 1, 0, 3, 140, 30, },
	{ 1, 1, 0, 3, 140, 30, },
	{ 0, 1, 0, 3, 149, 34, },
	{ 2, 1, 0, 3, 149, 30, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 34, },
	{ 2, 1, 0, 3, 153, 30, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 34, },
	{ 2, 1, 0, 3, 157, 30, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 34, },
	{ 2, 1, 0, 3, 161, 30, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 34, },
	{ 2, 1, 0, 3, 165, 30, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 1, 2, 38, 26, },
	{ 2, 1, 1, 2, 38, 30, },
	{ 1, 1, 1, 2, 38, 30, },
	{ 0, 1, 1, 2, 46, 32, },
	{ 2, 1, 1, 2, 46, 30, },
	{ 1, 1, 1, 2, 46, 30, },
	{ 0, 1, 1, 2, 54, 32, },
	{ 2, 1, 1, 2, 54, 30, },
	{ 1, 1, 1, 2, 54, 30, },
	{ 0, 1, 1, 2, 62, 24, },
	{ 2, 1, 1, 2, 62, 30, },
	{ 1, 1, 1, 2, 62, 30, },
	{ 0, 1, 1, 2, 102, 24, },
	{ 2, 1, 1, 2, 102, 30, },
	{ 1, 1, 1, 2, 102, 30, },
	{ 0, 1, 1, 2, 110, 32, },
	{ 2, 1, 1, 2, 110, 30, },
	{ 1, 1, 1, 2, 110, 30, },
	{ 0, 1, 1, 2, 118, 32, },
	{ 2, 1, 1, 2, 118, 30, },
	{ 1, 1, 1, 2, 118, 30, },
	{ 0, 1, 1, 2, 126, 32, },
	{ 2, 1, 1, 2, 126, 30, },
	{ 1, 1, 1, 2, 126, 30, },
	{ 0, 1, 1, 2, 134, 32, },
	{ 2, 1, 1, 2, 134, 30, },
	{ 1, 1, 1, 2, 134, 30, },
	{ 0, 1, 1, 2, 151, 30, },
	{ 2, 1, 1, 2, 151, 30, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 32, },
	{ 2, 1, 1, 2, 159, 30, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 28, },
	{ 2, 1, 1, 3, 38, 30, },
	{ 1, 1, 1, 3, 38, 30, },
	{ 0, 1, 1, 3, 46, 28, },
	{ 2, 1, 1, 3, 46, 30, },
	{ 1, 1, 1, 3, 46, 30, },
	{ 0, 1, 1, 3, 54, 30, },
	{ 2, 1, 1, 3, 54, 30, },
	{ 1, 1, 1, 3, 54, 30, },
	{ 0, 1, 1, 3, 62, 30, },
	{ 2, 1, 1, 3, 62, 30, },
	{ 1, 1, 1, 3, 62, 30, },
	{ 0, 1, 1, 3, 102, 26, },
	{ 2, 1, 1, 3, 102, 30, },
	{ 1, 1, 1, 3, 102, 30, },
	{ 0, 1, 1, 3, 110, 30, },
	{ 2, 1, 1, 3, 110, 30, },
	{ 1, 1, 1, 3, 110, 30, },
	{ 0, 1, 1, 3, 118, 34, },
	{ 2, 1, 1, 3, 118, 30, },
	{ 1, 1, 1, 3, 118, 30, },
	{ 0, 1, 1, 3, 126, 32, },
	{ 2, 1, 1, 3, 126, 30, },
	{ 1, 1, 1, 3, 126, 30, },
	{ 0, 1, 1, 3, 134, 30, },
	{ 2, 1, 1, 3, 134, 30, },
	{ 1, 1, 1, 3, 134, 30, },
	{ 0, 1, 1, 3, 151, 34, },
	{ 2, 1, 1, 3, 151, 30, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 34, },
	{ 2, 1, 1, 3, 159, 30, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 2, 4, 42, 22, },
	{ 2, 1, 2, 4, 42, 30, },
	{ 1, 1, 2, 4, 42, 30, },
	{ 0, 1, 2, 4, 58, 20, },
	{ 2, 1, 2, 4, 58, 30, },
	{ 1, 1, 2, 4, 58, 30, },
	{ 0, 1, 2, 4, 106, 20, },
	{ 2, 1, 2, 4, 106, 30, },
	{ 1, 1, 2, 4, 106, 30, },
	{ 0, 1, 2, 4, 122, 20, },
	{ 2, 1, 2, 4, 122, 30, },
	{ 1, 1, 2, 4, 122, 30, },
	{ 0, 1, 2, 4, 155, 28, },
	{ 2, 1, 2, 4, 155, 30, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 28, },
	{ 2, 1, 2, 5, 42, 30, },
	{ 1, 1, 2, 5, 42, 30, },
	{ 0, 1, 2, 5, 58, 26, },
	{ 2, 1, 2, 5, 58, 30, },
	{ 1, 1, 2, 5, 58, 30, },
	{ 0, 1, 2, 5, 106, 28, },
	{ 2, 1, 2, 5, 106, 30, },
	{ 1, 1, 2, 5, 106, 30, },
	{ 0, 1, 2, 5, 122, 32, },
	{ 2, 1, 2, 5, 122, 30, },
	{ 1, 1, 2, 5, 122, 30, },
	{ 0, 1, 2, 5, 155, 34, },
	{ 2, 1, 2, 5, 155, 30, },
	{ 1, 1, 2, 5, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8821a_txpwr_lmt);

static const struct rtw_pwr_seq_cmd trans_carddis_to_cardemu_8821a[] = {
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3) | BIT(7), 0},
	{0x0086,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_SDIO,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0086,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_SDIO,
	 RTW_PWR_CMD_POLLING, BIT(1), BIT(1)},
	{0x004A,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3) | BIT(4), 0},
	{0x0023,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4), 0},
	{0x0301,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_cardemu_to_act_8821a[] = {
	{0x0020,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK | RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0067,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK | RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4), 0},
	{0x0001,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK | RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_DELAY, 1, RTW_PWR_DELAY_MS},
	{0x0000,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK | RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4) | BIT(3) | BIT(2), 0},
	{0x0075,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0006,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(1), BIT(1)},
	{0x0075,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0006,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(7), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4) | BIT(3), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(0), 0},
	{0x004F,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0067,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5) | BIT(4), BIT(5) | BIT(4)},
	{0x0025,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(6), 0},
	{0x0049,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0063,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0062,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0058,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x005A,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x002E,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x82},
	{0x0010,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(6), BIT(6)},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_act_to_lps_8821a[] = {
	{0x0301,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0522,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x05F8,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x05F9,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FA,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FB,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_DELAY, 0, RTW_PWR_DELAY_US},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0100,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x03},
	{0x0101,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0093,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0553,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_act_to_cardemu_8821a[] = {
	{0x001F,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0},
	{0x004F,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0049,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0006,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(1), 0},
	{0x0000,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK | RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0x0020,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK | RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_cardemu_to_carddis_8821a[] = {
	{0x0007,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK | RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3) | BIT(4), BIT(3)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), BIT(2)},
	{0x004A,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 1},
	{0x0023,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0086,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_SDIO,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0086,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_SDIO_MSK,
	 RTW_PWR_ADDR_SDIO,
	 RTW_PWR_CMD_POLLING, BIT(1), 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

const struct rtw_pwr_seq_cmd * const card_enable_flow_8821a[] = {
	trans_carddis_to_cardemu_8821a,
	trans_cardemu_to_act_8821a,
	NULL
};

const struct rtw_pwr_seq_cmd * const enter_lps_flow_8821a[] = {
	trans_act_to_lps_8821a,
	NULL
};

const struct rtw_pwr_seq_cmd * const card_disable_flow_8821a[] = {
	trans_act_to_cardemu_8821a,
	trans_cardemu_to_carddis_8821a,
	NULL
};

static const u8 rtw8821a_pwrtrk_5gb_n[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
};

static const u8 rtw8821a_pwrtrk_5gb_p[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
};

static const u8 rtw8821a_pwrtrk_5ga_n[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
};

static const u8 rtw8821a_pwrtrk_5ga_p[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 16, 16, 16, 16, 16, 16},
};

static const u8 rtw8821a_pwrtrk_2gb_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10
};

static const u8 rtw8821a_pwrtrk_2gb_p[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8821a_pwrtrk_2ga_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10
};

static const u8 rtw8821a_pwrtrk_2ga_p[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8821a_pwrtrk_2g_cck_b_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10
};

static const u8 rtw8821a_pwrtrk_2g_cck_b_p[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8821a_pwrtrk_2g_cck_a_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10
};

static const u8 rtw8821a_pwrtrk_2g_cck_a_p[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12
};

const struct rtw_pwr_track_tbl rtw8821a_rtw_pwr_track_tbl = {
	.pwrtrk_5gb_n[0] = rtw8821a_pwrtrk_5gb_n[0],
	.pwrtrk_5gb_n[1] = rtw8821a_pwrtrk_5gb_n[1],
	.pwrtrk_5gb_n[2] = rtw8821a_pwrtrk_5gb_n[2],
	.pwrtrk_5gb_p[0] = rtw8821a_pwrtrk_5gb_p[0],
	.pwrtrk_5gb_p[1] = rtw8821a_pwrtrk_5gb_p[1],
	.pwrtrk_5gb_p[2] = rtw8821a_pwrtrk_5gb_p[2],
	.pwrtrk_5ga_n[0] = rtw8821a_pwrtrk_5ga_n[0],
	.pwrtrk_5ga_n[1] = rtw8821a_pwrtrk_5ga_n[1],
	.pwrtrk_5ga_n[2] = rtw8821a_pwrtrk_5ga_n[2],
	.pwrtrk_5ga_p[0] = rtw8821a_pwrtrk_5ga_p[0],
	.pwrtrk_5ga_p[1] = rtw8821a_pwrtrk_5ga_p[1],
	.pwrtrk_5ga_p[2] = rtw8821a_pwrtrk_5ga_p[2],
	.pwrtrk_2gb_n = rtw8821a_pwrtrk_2gb_n,
	.pwrtrk_2gb_p = rtw8821a_pwrtrk_2gb_p,
	.pwrtrk_2ga_n = rtw8821a_pwrtrk_2ga_n,
	.pwrtrk_2ga_p = rtw8821a_pwrtrk_2ga_p,
	.pwrtrk_2g_cckb_n = rtw8821a_pwrtrk_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8821a_pwrtrk_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8821a_pwrtrk_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8821a_pwrtrk_2g_cck_a_p,
};
