## TFSA-2020-031: Write to immutable memory region

### CVE Number
CVE-2020-26268

### Impact
The `tf.raw_ops.ImmutableConst` operation returns a constant tensor created from
a memory mapped file which is assumed immutable. However, if the type of the
tensor is not an integral type, the operation crashes the Python interpreter as
it tries to write to the memory area:

```python
>>> import tensorflow as tf
>>> with open('/tmp/test.txt','w') as f: f.write('a'*128)
>>> tf.raw_ops.ImmutableConst(dtype=tf.string,shape=2,
                              memory_region_name='/tmp/test.txt')
```

If the file is too small, TensorFlow properly returns an error as the memory
area has fewer bytes than what is needed for the tensor it creates. However, as
soon as there are enough bytes, the above snippet causes a segmentation fault.

This is because the alocator used to return the buffer data is not marked as
returning an opaque handle since the [needed virtual
method](https://github.com/tensorflow/tensorflow/blob/c1e1fc899ad5f8c725dcbb6470069890b5060bc7/tensorflow/core/framework/typed_allocator.h#L78-L85)
is [not
overriden](https://github.com/tensorflow/tensorflow/blob/acdf3c04fcfa767ae8d109b9e1f727ef050dba4d/tensorflow/core/kernels/immutable_constant_op.cc).

### Patches

We have patched the issue in GitHub commit
[c1e1fc899ad5f8c725dcbb6470069890b5060bc7](https://github.com/tensorflow/tensorflow/commit/c1e1fc899ad5f8c725dcbb6470069890b5060bc7)
and will release TensorFlow 2.4.0 containing the patch. TensorFlow nightly
packages after this commit will also have the issue resolved.

Since this issue also impacts TF versions before 2.4, we will patch all releases
between 1.15 and 2.3 inclusive.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
