/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateWithRNG
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _dtd_compatibility = new QName("", "dtd-compatibility");
    private static final String language = "http://relaxng.org/ns/structure/1.0";
    private ReadablePipe source = null;
    private ReadablePipe schema = null;
    private WritablePipe result = null;
    private URI docBaseURI = null;

    public ValidateWithRNG(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("schema".equals(string)) {
            this.schema = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode xdmNode = null;
        try {
            TheFactoryImpl theFactoryImpl = new TheFactoryImpl();
            Verifier verifier = null;
            XdmNode xdmNode2 = this.schema.read();
            InputSource inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode2);
            inputSource.setSystemId(xdmNode2.getBaseURI().toASCIIString());
            Schema schema = theFactoryImpl.compileSchema(inputSource);
            verifier = schema.newVerifier();
            verifier.setErrorHandler((ErrorHandler)new RNGErrorHandler());
            xdmNode = this.source.read();
            this.docBaseURI = xdmNode.getBaseURI();
            if (verifier != null && !verifier.verify(S9apiUtils.xdmToInputSource(this.runtime, xdmNode))) {
                throw new XProcException(XProcException.err_E0001, "Document is not valid");
            }
            this.result.write(xdmNode);
        }
        catch (VerifierConfigurationException verifierConfigurationException) {
            if (this.runtime.getDebug()) {
                verifierConfigurationException.printStackTrace();
            }
            throw new XProcException(verifierConfigurationException);
        }
        catch (SAXException sAXException) {
            if (this.getOption(_assert_valid, false)) {
                throw XProcException.stepError(53);
            }
            this.result.write(xdmNode);
        }
        catch (IOException iOException) {
            if (this.runtime.getDebug()) {
                iOException.printStackTrace();
            }
            throw new XProcException(iOException);
        }
    }

    class RNGErrorHandler
    implements ErrorHandler {
        RNGErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.error(sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            TreeWriter treeWriter = new TreeWriter(ValidateWithRNG.this.runtime);
            treeWriter.startDocument(ValidateWithRNG.this.docBaseURI);
            treeWriter.addStartElement(XProcConstants.c_error);
            treeWriter.startContent();
            treeWriter.addText(sAXParseException.toString());
            treeWriter.addEndElement();
            treeWriter.endDocument();
            ValidateWithRNG.this.step.reportError(treeWriter.getResult());
            throw sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
        }
    }
}

