/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NameTest;

class AttributeReference
extends SingletonExpression {
    private int fingerprint;
    private NodeInfo boundParentNode = null;

    private AttributeReference() {
    }

    public AttributeReference(int n) {
        this.fingerprint = n;
    }

    public void bindParentNode(NodeInfo nodeInfo) {
        this.boundParentNode = nodeInfo;
    }

    private NodeInfo getParentNode(Context context) {
        if (this.boundParentNode == null) {
            return context.getContextNodeInfo();
        }
        return this.boundParentNode;
    }

    public NodeInfo getNode(Context context) throws XPathException {
        NodeInfo nodeInfo = this.getParentNode(context);
        if (nodeInfo.getNodeType() == 1) {
            NameTest nameTest = new NameTest(2, this.fingerprint);
            AxisEnumeration axisEnumeration = nodeInfo.getEnumeration((byte)2, nameTest);
            if (axisEnumeration.hasMoreElements()) {
                return axisEnumeration.nextElement();
            }
            return null;
        }
        return null;
    }

    public boolean evaluateAsBoolean(Context context) throws XPathException {
        NodeInfo nodeInfo = this.getParentNode(context);
        if (nodeInfo.getNodeType() == 1) {
            return nodeInfo.getAttributeValue(this.fingerprint) != null;
        }
        return false;
    }

    public String evaluateAsString(Context context) throws XPathException {
        NodeInfo nodeInfo = this.getParentNode(context);
        if (nodeInfo.getNodeType() == 1) {
            String string = nodeInfo.getAttributeValue(this.fingerprint);
            if (string == null) {
                return "";
            }
            return string;
        }
        return "";
    }

    public int getDependencies() {
        if (this.boundParentNode == null) {
            return 8;
        }
        return 0;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if (this.boundParentNode == null && (n & 8) != 0) {
            AttributeReference attributeReference = new AttributeReference();
            attributeReference.fingerprint = this.fingerprint;
            attributeReference.bindParentNode(context.getContextNodeInfo());
            attributeReference.setStaticContext(this.getStaticContext());
            return attributeReference;
        }
        return this;
    }

    public void display(int n) {
        System.err.println(Expression.indent(n) + "@" + this.fingerprint);
    }
}

