# Copyright 2022-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.6.2

EAPI=8

CRATES="
"

LLVM_COMPAT=( {17..20} )
inherit cargo llvm-r1

DESCRIPTION="GNU findutils rewritten in Rust"
HOMEPAGE="https://uutils.github.io/findutils/ https://github.com/uutils/findutils"

if [[ ${PV} == 9999 ]] ; then
	EGIT_REPO_URI="https://github.com/uutils/findutils"
	inherit git-r3
elif [[ ${PV} == *_p* ]] ; then
	FINDUTILS_COMMIT="59301c788aa610bd9b35d8715af72d87528d07dc"
	SRC_URI="https://github.com/uutils/findutils/archive/${FINDUTILS_COMMIT}.tar.gz -> ${P}.tar.gz"
	SRC_URI+=" ${CARGO_CRATE_URIS}"
	S="${WORKDIR}"/findutils-${FINDUTILS_COMMIT}
else
	SRC_URI="https://github.com/uutils/findutils/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz"
	SRC_URI+=" ${CARGO_CRATE_URIS}"
	S="${WORKDIR}"/findutils-${PV}
fi

SRC_URI+="
	https://github.com/gentoo-crate-dist/findutils/releases/download/${PV}/findutils-${PV}-crates.tar.xz
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 MIT Unicode-DFS-2016"
SLOT="0"
if [[ ${PV} != 9999 ]] ; then
	KEYWORDS="~amd64 ~arm64"
fi

RDEPEND=">=dev-libs/oniguruma-6.9.9:="
DEPEND="${RDEPEND}"
BDEPEND="
	$(llvm_gen_dep '
		llvm-core/clang:${LLVM_SLOT}
	')
"

QA_FLAGS_IGNORED=".*"

pkg_setup() {
	llvm-r1_pkg_setup
	rust_pkg_setup
}

src_unpack() {
	if [[ ${PV} == 9999 ]] ; then
		git-r3_src_unpack
		cargo_live_src_unpack
	else
		cargo_src_unpack
	fi
}

src_configure() {
	export RUSTONIG_SYSTEM_LIBONIG=1
	export PKG_CONFIG_ALLOW_CROSS=1

	cargo_src_configure
}

src_install() {
	cargo_src_install

	rm "${ED}"/usr/bin/testing-commandline || die

	local binary
	for binary in find xargs ; do
		mv "${ED}"/usr/bin/${binary} "${ED}"/usr/bin/uutils-${binary} || die
	done
}
