/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;

class ProgressEventConsumer {
    private final Set<Object> startedIds = ConcurrentHashMap.newKeySet();
    private final BuildEventConsumer delegate;
    private final BuildOperationAncestryTracker ancestryTracker;

    ProgressEventConsumer(BuildEventConsumer delegate, BuildOperationAncestryTracker ancestryTracker) {
        this.delegate = delegate;
        this.ancestryTracker = ancestryTracker;
    }

    @Nullable
    OperationIdentifier findStartedParentId(BuildOperationDescriptor operation) {
        return this.ancestryTracker.findClosestMatchingAncestor(operation.getParentId(), this.startedIds::contains).orElse(null);
    }

    void started(InternalOperationStartedProgressEvent event) {
        this.delegate.dispatch((Object)event);
        this.startedIds.add(event.getDescriptor().getId());
    }

    void finished(InternalOperationFinishedProgressEvent event) {
        this.startedIds.remove(event.getDescriptor().getId());
        this.delegate.dispatch((Object)event);
    }

    void progress(InternalProgressEvent event) {
        this.delegate.dispatch((Object)event);
    }
}

