/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntField;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataStruct;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationUtilsKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.DisjointUnions;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.wasm.ir.TypesKt;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0002J0\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020\u00122\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0002J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001f2\u0006\u0010/\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u0010/\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00109\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020<H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "allowIncompleteImplementations", "", "hierarchyDisjointUnions", "Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;ZLorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "jsCodeCounter", "", "", "", "unitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstanceFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstanceFunction$delegate", "Lkotlin/Lazy;", "binaryDataStruct", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataStruct;", "classMetadata", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "createClassITable", "", "metadata", "createDeclarationByInterface", "iFace", "createVTable", "createVirtualTableStruct", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "methods", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/VirtualMethodMetadata;", "name", "superType", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "interfaceTable", "jsCodeName", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunction", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDeclarationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 WasmIrExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilderKt\n*L\n1#1,535:1\n372#2,7:536\n1#3:543\n1549#4:544\n1620#4,3:545\n1559#4:548\n1590#4,4:549\n1855#4,2:553\n1549#4:555\n1620#4,3:556\n1864#4,3:561\n1620#4,3:568\n1549#4:571\n1620#4,3:572\n104#5,2:559\n106#5:564\n104#5,3:565\n*S KotlinDebug\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n*L\n62#1:536,7\n112#1:544\n112#1:545,3\n204#1:548\n204#1:549,4\n219#1:553,2\n229#1:555\n229#1:556,3\n262#1:561,3\n373#1:568,3\n438#1:571\n438#1:572,3\n260#1:559,2\n260#1:564\n292#1:565,3\n*E\n"})
public final class DeclarationGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmModuleCodegenContext context;
    private final boolean allowIncompleteImplementations;
    @NotNull
    private final DisjointUnions<IrClassSymbol> hierarchyDisjointUnions;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstanceFunction$delegate;
    @NotNull
    private final Map<String, Integer> jsCodeCounter;

    public DeclarationGenerator(@NotNull WasmModuleCodegenContext context, boolean allowIncompleteImplementations, @NotNull DisjointUnions<IrClassSymbol> hierarchyDisjointUnions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(hierarchyDisjointUnions, (String)"hierarchyDisjointUnions");
        this.context = context;
        this.allowIncompleteImplementations = allowIncompleteImplementations;
        this.hierarchyDisjointUnions = hierarchyDisjointUnions;
        this.backendContext = this.context.getBackendContext();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstanceFunction$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrSimpleFunction>(this){
            final /* synthetic */ DeclarationGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return MiscKt.findUnitGetInstanceFunction(DeclarationGenerator.access$getBackendContext$p(this.this$0));
            }
        }));
        this.jsCodeCounter = new LinkedHashMap();
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction getUnitGetInstanceFunction() {
        Lazy lazy = this.unitGetInstanceFunction$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isExternal()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    /*
     * Unable to fully structure code
     */
    private final String jsCodeName(IrFunction declaration) {
        if (!(declaration instanceof IrSimpleFunction)) {
            var3_2 = "Failed requirement.";
            throw new IllegalArgumentException(var3_2.toString());
        }
        key = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration));
        $this$getOrPut$iv = this.jsCodeCounter;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            $i$a$-getOrPut-DeclarationGenerator$jsCodeName$counterValue$1 = false;
            answer$iv = 0;
            $this$getOrPut$iv.put(key, answer$iv);
            v0 = answer$iv;
        } else {
            v0 = value$iv;
        }
        counterValue = ((Number)v0).intValue();
        this.jsCodeCounter.put(key, counterValue + 1);
        if (counterValue != 0) ** GOTO lbl-1000
        v1 = StringsKt.lastOrNull((CharSequence)key);
        v2 = v1 != null ? !Character.isDigit(v1.charValue()) : false;
        if (v2) {
            v3 = "";
        } else lbl-1000:
        // 2 sources

        {
            v3 = "" + '_' + counterValue;
        }
        counterSuffix = v3;
        return key + counterSuffix;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        String initPriority;
        void $this$mapTo$iv$iv;
        WasmImportDescriptor importedName;
        WasmImportDescriptor wasmImportDescriptor;
        boolean isIntrinsic;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrConstructor && this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(declaration))) {
            return;
        }
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation(declaration) || AnnotationsKt.getWasmOpAnnotation(declaration) != null;
        if (isIntrinsic) {
            return;
        }
        WasmImportDescriptor wasmImportModule = AnnotationsKt.getWasmImportDescriptor(declaration);
        String jsCode = AnnotationsKt.getJsFunAnnotation(declaration);
        if (wasmImportModule != null) {
            if (!declaration.isExternal()) {
                boolean $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = false;
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = "Non-external fun with @WasmImport " + IrUtilsKt.getFqNameWhenAvailable(declaration);
                throw new IllegalStateException($i$a$-check-DeclarationGenerator$visitFunction$importedName$22.toString());
            }
            this.context.addJsModuleImport(wasmImportModule.getModuleName());
            wasmImportDescriptor = wasmImportModule;
        } else if (jsCode != null) {
            String jsCodeName = this.jsCodeName(declaration);
            this.context.addJsFun(jsCodeName, jsCode);
            wasmImportDescriptor = new WasmImportDescriptor("js_code", jsCodeName);
        } else {
            wasmImportDescriptor = importedName = null;
        }
        if (IrFakeOverrideUtilsKt.isFakeOverride(declaration)) {
            return;
        }
        String watName = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration));
        List<IrValueParameter> irParameters = DeclarationGeneratorKt.getEffectiveValueParameters(declaration);
        WasmType resultType = Intrinsics.areEqual((Object)declaration, (Object)this.getUnitGetInstanceFunction()) ? this.context.transformType(declaration.getReturnType()) : this.context.transformResultType(declaration.getReturnType());
        Iterable $this$map$iv22 = irParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.context.transformValueParameterType((IrValueParameter)it));
        }
        List list2 = CollectionsKt.listOfNotNull((Object)resultType);
        List list3 = (List)destination$iv$iv;
        WasmFunctionType wasmFunctionType = new WasmFunctionType(list3, list2);
        this.context.defineFunctionType(declaration.getSymbol(), wasmFunctionType);
        if (declaration instanceof IrSimpleFunction && ((IrSimpleFunction)declaration).getModality() == Modality.ABSTRACT) {
            return;
        }
        boolean $this$map$iv22 = Intrinsics.areEqual((Object)declaration, (Object)IrResolveUtilsKt.getRealOverrideTarget(declaration));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-DeclarationGenerator$visitFunction$22 = false;
            String $i$a$-assert-DeclarationGenerator$visitFunction$22 = "Sanity check that " + declaration + " is a real function that can be used in calls";
            throw new AssertionError((Object)$i$a$-assert-DeclarationGenerator$visitFunction$22);
        }
        WasmSymbol<WasmFunctionType> functionTypeSymbol = this.context.referenceFunctionType(declaration.getSymbol());
        if (importedName != null) {
            this.context.defineFunction(declaration.getSymbol(), new WasmFunction.Imported(watName, (WasmSymbolReadOnly<WasmFunctionType>)functionTypeSymbol, importedName));
            return;
        }
        WasmFunction.Defined function2 = new WasmFunction.Defined(watName, functionTypeSymbol, null, null, 12, null);
        WasmFunctionCodegenContext functionCodegenContext = new WasmFunctionCodegenContext(declaration, function2, this.backendContext, this.context);
        for (IrValueParameter irParameter2 : irParameters) {
            functionCodegenContext.defineLocal(irParameter2.getSymbol());
        }
        WasmExpressionBuilder exprGen = functionCodegenContext.getBodyGen();
        BodyGenerator bodyBuilder = new BodyGenerator(this.context, functionCodegenContext, this.hierarchyDisjointUnions, Intrinsics.areEqual((Object)declaration, (Object)this.getUnitGetInstanceFunction()));
        if (declaration instanceof IrConstructor) {
            bodyBuilder.generateObjectCreationPrefixIfNeeded((IrConstructor)declaration);
        }
        if (!(declaration.getBody() instanceof IrBlockBody)) {
            boolean bl3 = false;
            String string2 = "Only IrBlockBody is supported";
            throw new IllegalArgumentException(string2.toString());
        }
        IrBody irBody = declaration.getBody();
        if (irBody != null) {
            IrVisitorsKt.acceptVoid(irBody, bodyBuilder);
        }
        if (declaration instanceof IrConstructor) {
            exprGen.buildGetLocal(function2.getLocals().get(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
            exprGen.buildInstr(WasmOp.RETURN, SourceLocation.Companion.NoLocation("Implicit return from constructor"), new WasmImmediate[0]);
        }
        if (!((Collection)wasmFunctionType.getResultTypes()).isEmpty()) {
            LocationUtilsKt.buildUnreachableForVerifier(exprGen);
        }
        this.context.defineFunction(declaration.getSymbol(), function2);
        Object object = declaration;
        String string3 = Intrinsics.areEqual((Object)object, (Object)this.backendContext.getFieldInitFunction()) ? "0" : (initPriority = Intrinsics.areEqual((Object)object, (Object)this.backendContext.getMainCallsWrapperFunction()) ? "1" : null);
        if (initPriority != null) {
            this.context.registerInitFunction(function2, initPriority);
        }
        if (DeclarationGeneratorKt.isExported(declaration)) {
            object = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier");
            this.context.addExport(new WasmExport.Function((String)object, function2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createDeclarationByInterface(IrClassSymbol iFace) {
        void $this$mapIndexedTo$iv$iv;
        if (this.context.isAlreadyDefinedClassITableGcType(iFace)) {
            return;
        }
        if (!this.hierarchyDisjointUnions.contains(iFace)) {
            return;
        }
        List<IrClassSymbol> iFacesUnion = this.hierarchyDisjointUnions.get(iFace);
        Iterable $this$mapIndexed$iv = iFacesUnion;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void unionIFace;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.context.defineClassITableInterfaceSlot((IrClassSymbol)unionIFace, (int)index2);
            collection.add(new WasmStructFieldDeclaration(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)unionIFace.getOwner()) + ".itable", new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceVTableGcType((IrClassSymbol)unionIFace))), false));
        }
        List fields2 = (List)destination$iv$iv;
        WasmStructDeclaration struct = new WasmStructDeclaration("classITable", fields2, null);
        Iterable $this$forEach$iv = iFacesUnion;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrClassSymbol it = (IrClassSymbol)element$iv;
            boolean bl = false;
            this.context.defineClassITableGcType(it, struct);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WasmStructDeclaration createVirtualTableStruct(List<VirtualMethodMetadata> methods2, String name2, WasmSymbolReadOnly<? extends WasmTypeDeclaration> superType2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = methods2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getSignature().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.signature.name.asString()");
            collection.add(new WasmStructFieldDeclaration(string2, new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceFunctionType(it.getFunction().getSymbol()))), false));
        }
        List tableFields = (List)destination$iv$iv;
        return new WasmStructDeclaration(name2, tableFields, superType2);
    }

    static /* synthetic */ WasmStructDeclaration createVirtualTableStruct$default(DeclarationGenerator declarationGenerator, List list2, String string2, WasmSymbolReadOnly wasmSymbolReadOnly, int n, Object object) {
        if ((n & 4) != 0) {
            wasmSymbolReadOnly = null;
        }
        return declarationGenerator.createVirtualTableStruct(list2, string2, wasmSymbolReadOnly);
    }

    /*
     * WARNING - void declaration
     */
    private final void createVTable(ClassMetadata metadata) {
        WasmSymbol<WasmTypeDeclaration> wasmSymbol;
        IrClass klass = metadata.getKlass();
        IrClassSymbol symbol2 = klass.getSymbol();
        String vtableName = IrUtilsKt.getFqNameWhenAvailable(klass) + ".vtable";
        DeclarationGenerator declarationGenerator = this;
        List<VirtualMethodMetadata> list2 = metadata.getVirtualMethods();
        String string2 = vtableName;
        Object object = metadata.getSuperClass();
        if (object != null && (object = ((ClassMetadata)object).getKlass()) != null && (object = ((IrClass)object).getSymbol()) != null) {
            void p0;
            Object object2 = object;
            WasmModuleCodegenContext wasmModuleCodegenContext = this.context;
            Object object3 = object2;
            String string3 = string2;
            List<VirtualMethodMetadata> list3 = list2;
            DeclarationGenerator declarationGenerator2 = declarationGenerator;
            boolean bl = false;
            WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = wasmModuleCodegenContext.referenceVTableGcType((IrClassSymbol)p0);
            declarationGenerator = declarationGenerator2;
            list2 = list3;
            string2 = string3;
            wasmSymbol = wasmSymbol2;
        } else {
            wasmSymbol = null;
        }
        WasmStructDeclaration vtableStruct = declarationGenerator.createVirtualTableStruct(list2, string2, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)wasmSymbol);
        this.context.defineVTableGcType(metadata.getKlass().getSymbol(), vtableStruct);
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        WasmSymbol<WasmTypeDeclaration> vTableTypeReference = this.context.referenceVTableGcType(symbol2);
        WasmRefType vTableRefGcType = new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)vTableTypeReference));
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createVTable_u24lambda_u2410 = new WasmIrExpressionBuilder(res$iv);
        boolean bl = false;
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of vtable struct");
        Iterable $this$forEachIndexed$iv = metadata.getVirtualMethods();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void method;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv;
            int i = n;
            boolean bl2 = false;
            if (method.getFunction().getModality() != Modality.ABSTRACT) {
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(this.context.referenceFunction(method.getFunction().getSymbol()))};
                $this$createVTable_u24lambda_u2410.buildInstr(WasmOp.REF_FUNC, location, wasmImmediateArray);
                continue;
            }
            if (!this.allowIncompleteImplementations) {
                boolean bl3 = false;
                String string4 = "Cannot find class implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable(klass);
                throw new IllegalStateException(string4.toString());
            }
            $this$createVTable_u24lambda_u2410.buildRefNull(TypesKt.getHeapType(vtableStruct.getFields().get(i).getType()), location);
        }
        $this$createVTable_u24lambda_u2410.buildStructNew(vTableTypeReference, location);
        List initVTableGlobal = res$iv;
        this.context.defineGlobalVTable(symbol2, new WasmGlobal(vtableName, vTableRefGcType, false, initVTableGlobal, null, 16, null));
    }

    private final void createClassITable(ClassMetadata metadata) {
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of itable struct");
        IrClass klass = metadata.getKlass();
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        Object object = (IrClass)CollectionsKt.firstOrNull(metadata.getInterfaces());
        if (object == null || (object = ((IrClass)object).getSymbol()) == null) {
            return;
        }
        Object supportedInterface = object;
        this.createDeclarationByInterface((IrClassSymbol)supportedInterface);
        WasmSymbol<WasmTypeDeclaration> classInterfaceType = this.context.referenceClassITableGcType((IrClassSymbol)supportedInterface);
        List<IrClassSymbol> interfaceList = this.hierarchyDisjointUnions.get((IrClassSymbol)supportedInterface);
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createClassITable_u24lambda_u2412 = new WasmIrExpressionBuilder(res$iv);
        boolean bl = false;
        for (IrClassSymbol iFace : interfaceList) {
            WasmSymbol<WasmTypeDeclaration> iFaceVTableGcType = this.context.referenceVTableGcType(iFace);
            WasmHeapType.Type iFaceVTableGcNullHeapType = new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)iFaceVTableGcType);
            if (!metadata.getInterfaces().contains(iFace.getOwner())) {
                $this$createClassITable_u24lambda_u2412.buildRefNull(iFaceVTableGcNullHeapType, location);
                continue;
            }
            for (VirtualMethodMetadata method : this.context.getInterfaceMetadata(iFace).getMethods()) {
                Object v1;
                WasmImmediate[] wasmImmediateArray;
                block8: {
                    wasmImmediateArray = (WasmImmediate[])metadata.getVirtualMethods();
                    for (Object t : wasmImmediateArray) {
                        VirtualMethodMetadata it = (VirtualMethodMetadata)t;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getSignature(), (Object)method.getSignature()) && it.getFunction().getModality() != Modality.ABSTRACT)) continue;
                        v1 = t;
                        break block8;
                    }
                    v1 = null;
                }
                VirtualMethodMetadata classMethod = v1;
                if (classMethod == null && !this.allowIncompleteImplementations) {
                    throw new IllegalStateException(("Cannot find interface implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable(klass)).toString());
                }
                if (classMethod != null) {
                    WasmSymbol<WasmFunction> functionTypeReference = this.context.referenceFunction(classMethod.getFunction().getSymbol());
                    wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(functionTypeReference)};
                    $this$createClassITable_u24lambda_u2412.buildInstr(WasmOp.REF_FUNC, location, wasmImmediateArray);
                    continue;
                }
                $this$createClassITable_u24lambda_u2412.buildRefNull(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceFunctionType(method.getFunction().getSymbol())), location);
            }
            $this$createClassITable_u24lambda_u2412.buildStructNew(iFaceVTableGcType, location);
        }
        $this$createClassITable_u24lambda_u2412.buildStructNew(classInterfaceType, location);
        List initITableGlobal = res$iv;
        WasmGlobal wasmClassIFaceGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable(klass) + ".classITable", new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)classInterfaceType)), false, initITableGlobal, null, 16, null);
        this.context.defineGlobalClassITable(klass.getSymbol(), wasmClassIFaceGlobal);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isExternal()) {
            return;
        }
        IrClassSymbol symbol2 = declaration.getSymbol();
        WasmArrayInfo wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation(declaration);
        if (wasmArrayInfo != null) {
            WasmArrayInfo wasmArrayAnnotation = wasmArrayInfo;
            boolean bl = false;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration));
            WasmArrayDeclaration wasmArrayDeclaration = new WasmArrayDeclaration(nameStr, new WasmStructFieldDeclaration("field", this.context.transformFieldType(wasmArrayAnnotation.getType()), true));
            this.context.defineGcType(symbol2, wasmArrayDeclaration);
            return;
        }
        String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration));
        if (IrUtilsKt.isInterface(declaration)) {
            if (this.hierarchyDisjointUnions.contains(symbol2)) {
                WasmStructDeclaration vtableStruct = DeclarationGenerator.createVirtualTableStruct$default(this, this.context.getInterfaceMetadata(symbol2).getMethods(), nameStr + ".itable", null, 4, null);
                this.context.defineVTableGcType(symbol2, vtableStruct);
            }
        } else {
            WasmSymbol<WasmTypeDeclaration> wasmSymbol;
            ClassMetadata metadata = this.context.getClassMetadata(symbol2);
            this.createVTable(metadata);
            this.createClassITable(metadata);
            WasmRefType vtableRefGcType = new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceVTableGcType(symbol2)));
            WasmRefNullType classITableRefGcType = new WasmRefNullType(WasmHeapType.Simple.Data.INSTANCE);
            List fields2 = new ArrayList();
            fields2.add(new WasmStructFieldDeclaration("vtable", vtableRefGcType, false));
            fields2.add(new WasmStructFieldDeclaration("itable", classITableRefGcType, false));
            Iterable $this$mapTo$iv = ClassInfoKt.allFields(declaration, this.irBuiltIns);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                IrField irField = (IrField)item$iv;
                Collection collection = fields2;
                boolean bl = false;
                String string2 = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name.toString()");
                collection.add(new WasmStructFieldDeclaration(string2, this.context.transformFieldType(it.getType()), true));
            }
            ClassMetadata superClass = metadata.getSuperClass();
            String string3 = nameStr;
            List list2 = fields2;
            ClassMetadata classMetadata = superClass;
            if (classMetadata != null) {
                Object item$iv;
                item$iv = classMetadata;
                List list3 = list2;
                String string4 = string3;
                boolean bl = false;
                WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = this.context.referenceGcType(superClass.getKlass().getSymbol());
                string3 = string4;
                list2 = list3;
                wasmSymbol = wasmSymbol2;
            } else {
                wasmSymbol = null;
            }
            WasmSymbolReadOnly wasmSymbolReadOnly = wasmSymbol;
            List list4 = list2;
            String string5 = string3;
            WasmStructDeclaration structType = new WasmStructDeclaration(string5, list4, wasmSymbolReadOnly);
            this.context.defineGcType(symbol2, structType);
            this.context.generateTypeInfo(symbol2, this.binaryDataStruct(metadata));
        }
        for (IrDeclaration member2 : declaration.getDeclarations()) {
            IrVisitorsKt.acceptVoid(member2, this);
        }
    }

    private final ConstantDataStruct binaryDataStruct(ClassMetadata classMetadata) {
        ConstantDataIntField constantDataIntField;
        IrClass superClass;
        Object object;
        boolean fqnShouldBeEmitted = CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getBackendContext().getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        if (fqnShouldBeEmitted) {
            object = FqNamesUtilKt.parentOrNull(AdditionalIrUtilsKt.getKotlinFqName(classMetadata.getKlass()));
            if (object == null || (object = ((FqName)object).asString()) == null) {
                object = "";
            }
        } else {
            object = "";
        }
        String packageName2 = object;
        String string2 = AdditionalIrUtilsKt.getKotlinFqName(classMetadata.getKlass()).shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classMetadata.klass.kotl\u2026me.shortName().asString()");
        String simpleName = string2;
        Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair = this.context.referenceStringLiteralAddressAndId(packageName2);
        WasmSymbol packageNameAddress = (WasmSymbol)pair.component1();
        WasmSymbol packageNamePoolId = (WasmSymbol)pair.component2();
        Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair2 = this.context.referenceStringLiteralAddressAndId(simpleName);
        WasmSymbol simpleNameAddress = (WasmSymbol)pair2.component1();
        WasmSymbol simpleNamePoolId = (WasmSymbol)pair2.component2();
        Object[] objectArray = new ConstantDataIntField[]{new ConstantDataIntField("TypePackageNameLength", packageName2.length()), new ConstantDataIntField("TypePackageNameId", packageNamePoolId), new ConstantDataIntField("TypePackageNamePtr", packageNameAddress), new ConstantDataIntField("TypeNameLength", simpleName.length()), new ConstantDataIntField("TypeNameId", simpleNamePoolId), new ConstantDataIntField("TypeNamePtr", simpleNameAddress)};
        ConstantDataStruct typeInfo = new ConstantDataStruct("TypeInfo", CollectionsKt.listOf((Object[])objectArray));
        IrClass irClass2 = superClass = ClassInfoKt.getSuperClass(classMetadata.getKlass(), this.context.getBackendContext().getIrBuiltIns());
        if (irClass2 != null) {
            IrClass it = irClass2;
            boolean bl = false;
            constantDataIntField = new ConstantDataIntField("SuperTypeId", this.context.referenceTypeId(it.getSymbol()));
        } else {
            constantDataIntField = new ConstantDataIntField("SuperTypeId", -1);
        }
        ConstantDataIntField superTypeId = constantDataIntField;
        Object[] objectArray2 = new ConstantDataElement[]{typeInfo, superTypeId};
        List typeInfoContent = CollectionsKt.mutableListOf((Object[])objectArray2);
        if (!UtilsKt.isAbstractOrSealed(classMetadata.getKlass())) {
            typeInfoContent.add(this.interfaceTable(classMetadata));
        }
        return new ConstantDataStruct("Class TypeInfo: " + IrUtilsKt.getFqNameWhenAvailable(classMetadata.getKlass()) + ' ', typeInfoContent);
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantDataStruct interfaceTable(ClassMetadata classMetadata) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<IrClass> interfaces = classMetadata.getInterfaces();
        ConstantDataIntField size = new ConstantDataIntField("size", interfaces.size());
        Object[] objectArray = (Object[])interfaces;
        String string2 = "interfaceIds";
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrClass irClass2 = (IrClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.context.referenceTypeId(it.getSymbol()));
        }
        List list2 = (List)destination$iv$iv;
        String string3 = string2;
        ConstantDataIntArray interfaceIds = new ConstantDataIntArray(string3, list2);
        objectArray = new ConstantDataElement[]{size, interfaceIds};
        return new ConstantDataStruct("Class interface table: " + IrUtilsKt.getFqNameWhenAvailable(classMetadata.getKlass()) + ' ', CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        IrExpression initValue;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isStatic()) {
            return;
        }
        WasmType wasmType = this.context.transformType(declaration.getType());
        List initBody = new ArrayList();
        WasmIrExpressionBuilder wasmExpressionGenerator = new WasmIrExpressionBuilder(initBody);
        IrExpressionBody irExpressionBody = declaration.getInitializer();
        IrExpression irExpression = initValue = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (initValue != null) {
            if (!(initValue instanceof IrConst && !(((IrConst)initValue).getKind() instanceof IrConstKind.String))) {
                boolean bl = false;
                String string2 = "Static field initializer should be string or const";
                throw new IllegalStateException(string2.toString());
            }
            IrFile irFile = IrUtilsKt.getFileOrNull(declaration);
            DeclarationGeneratorKt.generateConstExpression((IrConst)initValue, wasmExpressionGenerator, this.context, LocationUtilsKt.getSourceLocation(declaration, irFile != null ? irFile.getFileEntry() : null));
        } else {
            DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
        }
        WasmGlobal global = new WasmGlobal(String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration)), wasmType, true, initBody, null, 16, null);
        this.context.defineGlobalField(declaration.getSymbol(), global);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    public static final /* synthetic */ WasmBackendContext access$getBackendContext$p(DeclarationGenerator $this) {
        return $this.backendContext;
    }
}

