/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Access;
import com.intellij.util.lang.ByteArrayAccess;
import com.intellij.util.lang.InputStreamAccess;
import com.intellij.util.lang.Xxh3Impl;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class Xxh3 {
    public static long hash(byte @NotNull [] input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(0);
        }
        return Xxh3Impl.hash(input, ByteArrayAccess.INSTANCE, 0, input.length, 0L);
    }

    public static long hash(@NotNull InputStream inputStream, int length) {
        if (inputStream == null) {
            Xxh3.$$$reportNull$$$0(1);
        }
        return Xxh3Impl.hash(inputStream, new InputStreamAccess(length), 0, length, 0L);
    }

    public static long hash(byte @NotNull [] input, int offset, int length) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(2);
        }
        return Xxh3Impl.hash(input, ByteArrayAccess.INSTANCE, offset, length, 0L);
    }

    public static long hash(@NotNull ByteBuffer input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(3);
        }
        return Xxh3.hash(input, input.position(), input.remaining());
    }

    public static long hash(@NotNull ByteBuffer input, int offset, int length) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(4);
        }
        if (input.hasArray()) {
            return Xxh3Impl.hash(input.array(), ByteArrayAccess.INSTANCE, input.arrayOffset() + offset, length, 0L);
        }
        return Xxh3Impl.hash(input, ByteBufferAccess.INSTANCE, offset, length, 0L);
    }

    public static long hash(@NotNull String input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(5);
        }
        byte[] data = input.getBytes(StandardCharsets.UTF_8);
        return Xxh3Impl.hash(data, ByteArrayAccess.INSTANCE, 0, data.length, 0L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "input";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inputStream";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/lang/Xxh3";
        objectArray[2] = "hash";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ByteBufferAccess
    implements Access<ByteBuffer> {
        private static final VarHandle LONG_HANDLE = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
        private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
        @NotNull
        private static final Access<ByteBuffer> INSTANCE = new ByteBufferAccess();

        private ByteBufferAccess() {
        }

        @Override
        public long i64(ByteBuffer input, int offset) {
            return LONG_HANDLE.get(input, offset);
        }

        @Override
        public int i32(ByteBuffer input, int offset) {
            return INT_HANDLE.get(input, offset);
        }

        @Override
        public int i8(ByteBuffer input, int offset) {
            return input.get(offset);
        }
    }
}

