/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.pipenv;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.packaging.pipenv.PyPipEnvPackageManagementService;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PyInterpreterInspectionQuickFixData;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.pipenv.PipEnvAssociationQuickFix;
import com.jetbrains.python.sdk.pipenv.PipEnvInstallQuickFix;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.pipenv.PyAddPipEnvPanel;
import com.jetbrains.python.sdk.pipenv.PyPipEnvSdkAdditionalData;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J<\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020!H\u0016\u00a8\u0006\""}, d2={"Lcom/jetbrains/python/sdk/pipenv/PyPipEnvSdkProvider;", "Lcom/jetbrains/python/sdk/PySdkProvider;", "<init>", "()V", "getSdkAdditionalText", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdkIcon", "Ljavax/swing/Icon;", "loadAdditionalDataForSdk", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "element", "Lorg/jdom/Element;", "tryCreatePackageManagementServiceForSdk", "Lcom/jetbrains/python/packaging/ui/PyPackageManagementService;", "project", "Lcom/intellij/openapi/project/Project;", "createEnvironmentAssociationFix", "Lcom/jetbrains/python/sdk/PyInterpreterInspectionQuickFixData;", "module", "Lcom/intellij/openapi/module/Module;", "isPyCharm", "", "associatedModulePath", "createInstallPackagesQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "createNewEnvironmentPanel", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "existingSdks", "", "newProjectPath", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "intellij.python.community.impl"})
public final class PyPipEnvSdkProvider
implements PySdkProvider {
    @Override
    @Nullable
    public String getSdkAdditionalText(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return PipenvKt.isPipEnv(sdk2) ? sdk2.getVersionString() : null;
    }

    @Override
    @Nullable
    public Icon getSdkIcon(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return PipenvKt.isPipEnv(sdk2) ? PipenvKt.getPIPENV_ICON() : null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalDataForSdk(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PyPipEnvSdkAdditionalData.Companion.load(element);
    }

    @Override
    @Nullable
    public PyPackageManagementService tryCreatePackageManagementServiceForSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return PipenvKt.isPipEnv(sdk2) ? (PyPackageManagementService)new PyPipEnvPackageManagementService(project, sdk2) : null;
    }

    @Override
    @Nullable
    public PyInterpreterInspectionQuickFixData createEnvironmentAssociationFix(@NotNull Module module, @NotNull Sdk sdk2, boolean isPyCharm, @Nullable String associatedModulePath) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (PipenvKt.isPipEnv(sdk2)) {
            String string;
            if (associatedModulePath != null) {
                if (isPyCharm) {
                    var7_5 = new Object[]{associatedModulePath};
                    string = PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.associated.with.another.project", var7_5);
                } else {
                    var7_5 = new Object[]{associatedModulePath};
                    string = PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.associated.with.another.module", var7_5);
                }
            } else {
                string = isPyCharm ? PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.not.associated.with.any.project", new Object[0]) : PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.not.associated.with.any.module", new Object[0]);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String message = string2;
            return new PyInterpreterInspectionQuickFixData(new PipEnvAssociationQuickFix(), message);
        }
        return null;
    }

    @Override
    @Nullable
    public LocalQuickFix createInstallPackagesQuickFix(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
        if (sdk2 == null) {
            return null;
        }
        Sdk sdk3 = sdk2;
        return PipenvKt.isPipEnv(sdk3) ? (LocalQuickFix)new PipEnvInstallQuickFix() : null;
    }

    @Override
    @NotNull
    public PyAddNewEnvPanel createNewEnvironmentPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @NotNull UserDataHolder context) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new PyAddPipEnvPanel(null, null, existingSdks, newProjectPath, context);
    }
}

