/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.newmatch;

import com.openhtmltopdf.css.constants.MarginBoxName;
import com.openhtmltopdf.css.extend.AttributeResolver;
import com.openhtmltopdf.css.extend.StylesheetFactory;
import com.openhtmltopdf.css.extend.TreeResolver;
import com.openhtmltopdf.css.newmatch.CascadedStyle;
import com.openhtmltopdf.css.newmatch.PageInfo;
import com.openhtmltopdf.css.newmatch.Selector;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.sheet.MediaRule;
import com.openhtmltopdf.css.sheet.PageRule;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import com.openhtmltopdf.css.sheet.Ruleset;
import com.openhtmltopdf.css.sheet.Stylesheet;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;

public class Matcher {
    private final Mapper docMapper;
    private final AttributeResolver _attRes;
    private final TreeResolver _treeRes;
    private final StylesheetFactory _styleFactory;
    private final Map<Object, Mapper> _map = new HashMap<Object, Mapper>();
    private final Set<Object> _hoverElements = new HashSet<Object>();
    private final Set<Object> _activeElements = new HashSet<Object>();
    private final Set<Object> _focusElements = new HashSet<Object>();
    private final Set<Object> _visitElements = new HashSet<Object>();
    private final List<PageRule> _pageRules = new ArrayList<PageRule>();
    private final List<FontFaceRule> _fontFaceRules = new ArrayList<FontFaceRule>();

    public Matcher(TreeResolver tr, AttributeResolver ar, StylesheetFactory factory, List<Stylesheet> stylesheets, String medium) {
        this._treeRes = tr;
        this._attRes = ar;
        this._styleFactory = factory;
        this.docMapper = this.createDocumentMapper(stylesheets, medium);
    }

    public CascadedStyle getCascadedStyle(Object e, boolean restyle) {
        Mapper em = !restyle ? this.getMapper(e) : this.matchElement(e);
        return em.getCascadedStyle(e);
    }

    public String getCSSForAllDescendants(Object e) {
        Object parent = this._treeRes.getParentElement(e);
        Mapper child = parent != null ? this.getMapper(parent) : this.docMapper;
        AllDescendantMapper descendants = new AllDescendantMapper(child.axes, this._attRes, this._treeRes);
        descendants.map(e);
        return descendants.toCSS();
    }

    public CascadedStyle getPECascadedStyle(Object e, String pseudoElement) {
        Mapper em = this.getMapper(e);
        return em.getPECascadedStyle(e, pseudoElement);
    }

    public PageInfo getPageCascadedStyle(String pageName, String pseudoPage) {
        ArrayList<PropertyDeclaration> props = new ArrayList<PropertyDeclaration>();
        HashMap<MarginBoxName, List<PropertyDeclaration>> marginBoxes = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
        ArrayList<PropertyDeclaration> footnote = new ArrayList<PropertyDeclaration>();
        for (PageRule pageRule : this._pageRules) {
            if (!pageRule.applies(pageName, pseudoPage)) continue;
            props.addAll(pageRule.getRuleset().getPropertyDeclarations());
            marginBoxes.putAll(pageRule.getMarginBoxes());
            if (pageRule.getFootnoteAreaProperties() == null) continue;
            footnote.addAll(pageRule.getFootnoteAreaProperties());
        }
        CascadedStyle style = props.isEmpty() ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(props.iterator());
        return new PageInfo(props, style, marginBoxes, footnote);
    }

    public List<FontFaceRule> getFontFaceRules() {
        return this._fontFaceRules;
    }

    public boolean isVisitedStyled(Object e) {
        return this._visitElements.contains(e);
    }

    public boolean isHoverStyled(Object e) {
        return this._hoverElements.contains(e);
    }

    public boolean isActiveStyled(Object e) {
        return this._activeElements.contains(e);
    }

    public boolean isFocusStyled(Object e) {
        return this._focusElements.contains(e);
    }

    protected Mapper matchElement(Object e) {
        Mapper child;
        Object parent = this._treeRes.getParentElement(e);
        if (parent != null) {
            Mapper m = this.getMapper(parent);
            child = m.mapChild(e);
        } else {
            child = this.docMapper.mapChild(e);
        }
        return child;
    }

    Mapper createDocumentMapper(List<Stylesheet> stylesheets, String medium) {
        TreeMap<String, Selector> sorter = new TreeMap<String, Selector>();
        this.addAllStylesheets(stylesheets, sorter, medium);
        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.MATCH_MATCHER_CREATED_WITH_SELECTOR, sorter.size());
        return new Mapper(sorter.values());
    }

    private void addAllStylesheets(List<Stylesheet> stylesheets, TreeMap<String, Selector> sorter, String medium) {
        int count = 0;
        int pCount = 0;
        for (Stylesheet stylesheet : stylesheets) {
            for (Object obj : stylesheet.getContents()) {
                MediaRule mediaRule;
                if (obj instanceof Ruleset) {
                    for (Selector selector : ((Ruleset)obj).getFSSelectors()) {
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                    continue;
                }
                if (obj instanceof PageRule) {
                    ((PageRule)obj).setPos(++pCount);
                    this._pageRules.add((PageRule)obj);
                    continue;
                }
                if (!(obj instanceof MediaRule) || !(mediaRule = (MediaRule)obj).matches(medium)) continue;
                Iterator<Ruleset> iterator2 = mediaRule.getContents().iterator();
                while (iterator2.hasNext()) {
                    Ruleset o;
                    Ruleset ruleset = o = iterator2.next();
                    Iterator<Selector> iterator3 = ruleset.getFSSelectors().iterator();
                    while (iterator3.hasNext()) {
                        Selector o1;
                        Selector selector = o1 = iterator3.next();
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                }
            }
            this._fontFaceRules.addAll(stylesheet.getFontFaceRules());
        }
        Collections.sort(this._pageRules, new Comparator<PageRule>(){

            @Override
            public int compare(PageRule p1, PageRule p2) {
                if (p1.getOrder() - p2.getOrder() < 0L) {
                    return -1;
                }
                if (p1.getOrder() == p2.getOrder()) {
                    return 0;
                }
                return 1;
            }
        });
    }

    private void link(Object e, Mapper m) {
        this._map.put(e, m);
    }

    private Mapper getMapper(Object e) {
        Mapper m = this._map.get(e);
        if (m != null) {
            return m;
        }
        m = this.matchElement(e);
        return m;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private Ruleset getElementStyle(Object e) {
        if (this._attRes == null || this._styleFactory == null) {
            return null;
        }
        String style = this._attRes.getElementStyling(e);
        if (Matcher.isNullOrEmpty(style)) {
            return null;
        }
        return this._styleFactory.parseStyleDeclaration(2, style);
    }

    private Ruleset getNonCssStyle(Object e) {
        if (this._attRes == null || this._styleFactory == null) {
            return null;
        }
        String style = this._attRes.getNonCssStyling(e);
        if (Matcher.isNullOrEmpty(style)) {
            return null;
        }
        return this._styleFactory.parseStyleDeclaration(2, style);
    }

    public static class AllDescendantMapper {
        private final List<Selector> axes;
        private final List<Selector> mappedSelectors = new ArrayList<Selector>();
        private final Set<Selector> topSelectors = new HashSet<Selector>();
        private final AttributeResolver attRes;
        private final TreeResolver treeRes;

        AllDescendantMapper(List<Selector> axes, AttributeResolver attRes, TreeResolver treeRes) {
            this.axes = axes;
            this.attRes = attRes;
            this.treeRes = treeRes;
        }

        String toCSS() {
            StringBuilder sb = new StringBuilder();
            for (Selector sel : this.mappedSelectors) {
                sel.toCSS(sb, this.topSelectors);
                sel.getRuleset().toCSS(sb);
            }
            return sb.toString();
        }

        void map(Object e) {
            ArrayDeque<Selector> queue = new ArrayDeque<Selector>();
            for (Selector sel : this.axes) {
                if (!sel.matches(e, this.attRes, this.treeRes) || sel.getChainedSelector() == null) continue;
                queue.addLast(sel);
                this.topSelectors.add(sel);
            }
            while (!queue.isEmpty()) {
                Selector current = (Selector)queue.removeFirst();
                Selector chain = current.getChainedSelector();
                if (chain == null) {
                    this.mappedSelectors.add(current);
                    continue;
                }
                queue.addLast(chain);
            }
        }
    }

    class Mapper {
        private final List<Selector> axes;
        private final Map<String, List<Selector>> pseudoSelectors;
        private final List<Selector> mappedSelectors;
        private Map<String, Mapper> children;

        Mapper(Collection<Selector> selectors) {
            this.axes = new ArrayList<Selector>(selectors);
            this.pseudoSelectors = Collections.emptyMap();
            this.mappedSelectors = Collections.emptyList();
        }

        private Mapper(List<Selector> axes, List<Selector> mappedSelectors, Map<String, List<Selector>> pseudoSelectors) {
            this.axes = axes;
            this.mappedSelectors = mappedSelectors;
            this.pseudoSelectors = pseudoSelectors;
        }

        Mapper mapChild(Object e) {
            ArrayList<Selector> childAxes = null;
            ArrayList<Selector> mappedSelectors = null;
            HashMap<String, List> pseudoSelectors = null;
            StringBuilder key = new StringBuilder();
            for (Selector sel : this.axes) {
                if (sel.getAxis() == 0) {
                    if (childAxes == null) {
                        childAxes = new ArrayList<Selector>();
                    }
                    childAxes.add(sel);
                } else if (sel.getAxis() == 2) {
                    throw new RuntimeException();
                }
                if (!sel.matches(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                String pseudoElement = sel.getPseudoElement();
                if (pseudoElement != null) {
                    if (pseudoSelectors == null) {
                        pseudoSelectors = new HashMap<String, List>();
                    }
                    List l = pseudoSelectors.computeIfAbsent(pseudoElement, kee -> new ArrayList());
                    l.add(sel);
                    key.append(sel.getSelectorID()).append(":");
                    continue;
                }
                if (sel.isPseudoClass(2)) {
                    Matcher.this._visitElements.add(e);
                }
                if (sel.isPseudoClass(8)) {
                    Matcher.this._activeElements.add(e);
                }
                if (sel.isPseudoClass(4)) {
                    Matcher.this._hoverElements.add(e);
                }
                if (sel.isPseudoClass(16)) {
                    Matcher.this._focusElements.add(e);
                }
                if (!sel.matchesDynamic(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                key.append(sel.getSelectorID()).append(":");
                Selector chain = sel.getChainedSelector();
                if (chain == null) {
                    if (mappedSelectors == null) {
                        mappedSelectors = new ArrayList<Selector>();
                    }
                    mappedSelectors.add(sel);
                    continue;
                }
                if (chain.getAxis() == 2) {
                    throw new RuntimeException();
                }
                if (childAxes == null) {
                    childAxes = new ArrayList();
                }
                childAxes.add(chain);
            }
            if (this.children == null) {
                this.children = new HashMap<String, Mapper>();
            }
            List normalisedChildAxes = childAxes == null ? Collections.emptyList() : childAxes;
            List normalisedMappedSelectors = mappedSelectors == null ? Collections.emptyList() : mappedSelectors;
            Map normalisedPseudoSelectors = pseudoSelectors == null ? Collections.emptyMap() : pseudoSelectors;
            Mapper childMapper = this.children.computeIfAbsent(key.toString(), kee -> new Mapper(normalisedChildAxes, normalisedMappedSelectors, normalisedPseudoSelectors));
            Matcher.this.link(e, childMapper);
            return childMapper;
        }

        CascadedStyle getCascadedStyle(Object e) {
            Ruleset elementStyling = Matcher.this.getElementStyle(e);
            Ruleset nonCssStyling = Matcher.this.getNonCssStyle(e);
            ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
            if (nonCssStyling != null) {
                propList.addAll(nonCssStyling.getPropertyDeclarations());
            }
            for (Selector sel : this.mappedSelectors) {
                propList.addAll(sel.getRuleset().getPropertyDeclarations());
            }
            if (elementStyling != null) {
                propList.addAll(elementStyling.getPropertyDeclarations());
            }
            if (propList.isEmpty()) {
                return CascadedStyle.emptyCascadedStyle;
            }
            return new CascadedStyle(propList.iterator());
        }

        public CascadedStyle getPECascadedStyle(Object e, String pseudoElement) {
            if (this.pseudoSelectors.isEmpty()) {
                return null;
            }
            List<Selector> pe = this.pseudoSelectors.get(pseudoElement);
            if (pe == null) {
                return null;
            }
            ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
            for (Selector sel : pe) {
                propList.addAll(sel.getRuleset().getPropertyDeclarations());
            }
            if (propList.isEmpty()) {
                return CascadedStyle.emptyCascadedStyle;
            }
            return new CascadedStyle(propList.iterator());
        }
    }
}

