/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.thinclient.terminal.ThinClientTerminalHost;
import com.jetbrains.thinclient.terminal.ThinClientTerminalInputStream;
import com.jetbrains.thinclient.terminal.ThinClientTerminalOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalProcess;", "Ljava/lang/Process;", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "getModel", "()Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "outputStream", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalOutputStream;", "inputStream", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalInputStream;", "waitFor", "", "destroy", "", "getOutputStream", "getInputStream", "getErrorStream", "Ljava/io/InputStream;", "exitValue", "intellij.terminal.frontend.split"})
public final class ThinClientTerminalProcess
extends Process {
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdTerminalSession model;
    @NotNull
    private final ThinClientTerminalOutputStream outputStream;
    @NotNull
    private final ThinClientTerminalInputStream inputStream;

    public ThinClientTerminalProcess(@NotNull Project project, @Nullable String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.lifetimeDef = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        this.lifetime = this.lifetimeDef.getLifetime();
        this.model = ThinClientTerminalHost.Companion.getInstance(project).getOrCreate(this.lifetime, workingDirectory);
        this.outputStream = new ThinClientTerminalOutputStream(this.model);
        this.inputStream = new ThinClientTerminalInputStream(this.lifetime, this.model);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final RdTerminalSession getModel() {
        return this.model;
    }

    @Override
    public int waitFor() {
        return 0;
    }

    @Override
    public void destroy() {
        if (RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
            this.model.getClosed().set((Object)true);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDef, (boolean)false, (int)1, null);
    }

    @Override
    @NotNull
    public ThinClientTerminalOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    @NotNull
    public ThinClientTerminalInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    @NotNull
    public InputStream getErrorStream() {
        InputStream inputStream = InputStream.nullInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"nullInputStream(...)");
        return inputStream;
    }

    @Override
    public int exitValue() {
        return -1;
    }
}

